: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

# Khoros: $Id$
# $Log$

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#========================================================================
#
# Program Name:	klint - checks database consistency and the object's
#			directory integrity
#
# Purpose:	The script will check the see if the database matches
#		the files in the object's directories.  If nothing
#		specified on the command line than all toolboxes found
#		in the files specified by KHOROS_TOOLBOX and all the
#		objects within are checked.  You can specify multiple
#		toolboxes by doing:
# !                                               
# !                   % klint -tb toolbox1,toolbox2
# !                                               
#                You can specify multiple objects by doing, but the object
#		 will have to be in every toolbox:
# !                                               
# !                   % klint -oname object1,object2
# !                                               
#		 If you combine the two options the objects specified must
#		 be in every toolbox specified.
# !                                               
# !                   % klint -tb toolbox1,toolbox2 -oname object1,object2
# !                                               
#
#     Arguments: tb    - toolbox(es) to lint
#                oname - object(s) to lint
#
#   Exit Status: 1 if any object does not lint correctly, 0 otherwise
#
#      Comments: Use kecho to determine what is in the database and search
#		 the objects directories to find out what is actual out there.
# Written By:	John M. Salas, Mark Young and Neil Bowers
# Date:		Mar 09, 1994
#
#========================================================================

@khoros_toolbox = ('KHOROS_TOOLBOX');
if (! eval("\$toolboxes = \$ENV{\"KHOROS_TOOLBOX\"}"))
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
@toolbox_list = split(':', $toolboxes);
foreach $toolbox_file (sort(@toolbox_list))
{
   if ( ! open(TBS,"<$toolbox_file"))
   {
      print "Can not open $toolbox_file.  Please check to make sure your\n";
      die   "KHOROS_TOOLBOX environment variable points to existing files.\n";
   }

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq 'S'.'UPPORT')
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}

@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";

#
# list of directories which we can expect to see in the toplevel of a toolbox
#
%tbdirs = (	'bin',		'executables',
		'data',		'sample data files',
		'examples',	'example programs',
		'help',		'help files',
		'include',	'public includes',
		'lib',		'library files',
		'mach',		'multiple architecture shadow trees',
		'manual',	'toolbox manual(s)',
		'objects',	'objects live in here',
		'repos',	'toolbox file repository',
		'testsuite',	'testsuites for objects in this toolbox'
	);


$whatis = 'checks database consistancy and the object\'s directory integrity';
@klint_args  = (
   '[tb]',    'toolbox1[,toolbox2]', 'name of toolbox(es) [all defined in KHOROS_TOOLBOX]',
   '[oname]', 'oname1[,oname2]',     'name of object(s) [all in the toolbox]',
);

#
# Initialize Khoros perl lib
#
&khoros'initialize("SUPPORT",$whatis,@klint_args);

# parse command line args
&khoros'parse_args(@ARGV);

$opt_t = $khoros'seenswitch{"tb"};
$opt_o = $khoros'seenswitch{"oname"};

#
# Get the -t option.  This option allows multiple toolboxes to be specified
# by doing -t toolbox1,toolbox2.  If not specified all the toolboxes are
# checked.
#
if ($opt_t)
{
   $_ = &khoros'get_tb_name;
   tr/,/\ /;
   @toolbox = split(' ', $_);
   for ( $i = 0 ; $i <= $#toolbox ; $i++ )
   {
      $tbpath = `kecho -tb $toolbox[$i] -echo path`;
      if ( $? )
      {
          die "toolbox $toolbox[$i] does not exist\n";
      }
   }
}
else
{
   @toolbox = split(' ',`kecho -echo toolboxes`);
}

#
# Check each toolbox specified
#
TOOLBOX: foreach $tb (sort(@toolbox))
{
   print "$tb\n";

#
# Verify that toolbox exists in database
#
   chop($tbpath = `kecho -tb $tb -echo path`);
   chop($tbfullpath = `kecho -tb $tb -echo path -fullpath`);
   unless ( -d $tbpath )
   {
      print "toolbox directory does not exist\n";
      next TOOLBOX;
   }

#
# check whether there are any bogus files or directories in toolbox
#
   opendir(TBDIR,"$tbfullpath") && do {
	@entries = grep(/^[^\.]/,readdir(TBDIR));
	closedir(TBDIR);
	foreach $entry (@entries) {

		# only $BOOTSTRAP can have a config directory
		next if $entry eq 'config' && $tb =~ /^bootstrap$/i;

		print "\t>>> Unexpected file: \$\U$tb\E/$entry\n"
					unless defined($tbdirs{$entry});
	}
   };

#
# Get the -o option.  This option allows multiple objects to be specified
# by doing -o object1,object2.  If not specified all the objects in the
# toolbox are checked.
#
   if ($opt_o)
   {
      $_ = $khoros'argval{"oname"};
      tr/,/\ /;
      @objects = split(' ', $_);
      for ( $i = 0 ; $i <= $#objects ; $i++ )
      {
         $objectpath = `kecho -tb $tb -oname $objects[$i] -echo path`;
         if ( $? )
         {
	     die "object $objects[$i] does not exist in $tb\n";
         }
      }
   }
   else
   {
      @objectsck = sort(split(' ',`kecho -tb $tb -echo objects`));
      @objects = sort(&ckobjects("$tbpath/objects"));
      if ( $#objectsck != $#objects ) 
      {
	  print "\t>>> The objects in $tb do not match the database.\n\n";
	  print "\t>>> Here is what kecho returns:\n\n";
	  print "\t>>> @objectsck\n\n";
	  print "\t>>> Here are the directories in the toolbox:\n\n";
	  print "\t>>> @objects\n\n";
	  print "\t>>> Please fix!\n";
	  $exit_status = 1;
	  next TOOLBOX;
      }
   }


#
# Check each object specified
#
   foreach $object (@objects)
   {
      print "     $object\n";

      #
      # Verify that object exists in database
      #
      $objectpath = `kecho -tb $tb -oname $object -echo path`;
      if ( $? )
      {
	 die "object $object does not exist in $tb\n";
      }
      chop($objectpath);

      &CheckUIS($object, $objectpath);

      $tbdir  = &determinetbdir("$tbpath");
      $objdir = &determineobjdir("$tbdir","$objectpath");
#
# Find the top level directory relative to the object
#
      @dir = split('/',$tbpath);
      chop($dir[$#dir]);
      $pos = index($objectpath,$dir[$#dir]) + length($dir[$#dir]) + 2;
      $toplevel = substr($objectpath,$pos);

#
# Get the files in the object's directory tree.
#
      @files = sort(&ckobj($objectpath,$toplevel));

#
# Get the database files
#
      @filesck = &sortfiles($objdir,split(' ',`kecho -tb $tb -oname $object -echo allfiles`));

#
# Create the associate arrays
#
      for ( $i = 0 ; $i <= $#filesck ; $i++ )
      {
	 $list1{$filesck[$i]} = 1;
      }
      for ( $i = 0 ; $i <= $#files ; $i++ )
      {
	 $list2{$files[$i]} = 1;
      }
#
# Cross check the associate arrays
#
      foreach $f (keys %list1)
      {
	 if ( !defined($list2{$f}) && ! -f "$tbpath/$f" )
	 {
	    print "        not in object:   $f\n";
	    $exit_status = 1;
	 }
      }

      foreach $f (keys %list2)
      {
	 next if $f =~ /db\/function$/;	# neilb
	 next if $f =~ /db\/$object\.cksum$/;	# neilb
	 if ( !defined($list1{$f}) )
	 {
	    print "        not in database: $f\n";
	    $exit_status = 1;
	 }
      }

#
# Reset the associate arrays
#
      undef %list1;
      undef %list2;
   }
}
exit($exit_status);

#------------------------------------------------------------------------
# Routine Name: ckobj - will search the objects directory for every file
#			contained within
#
# Purpose:	To search the directory passed and all subdirectories for
#		every file passed in except Makefile's and Imakefile's.
#
# Input:	objectpath - path to the object
#		updir      - directory name(s) relative to the toolbox
#
# Returns:	list of files
#
# Status:	Private Routine
# Written By:	John M Salas
# Date:		Mar 10, 1994
#------------------------------------------------------------------------

sub ckobj {

   local($objectpath) = @_[0];
   local($updir) = @_[1];
   local(@files);
   local(@name);

   return unless -d $objectpath;
   opendir(OBJECTDIR,$objectpath) || die "can not open $objectpath\n";
   foreach $name ( sort readdir(OBJECTDIR))
   {
      next if ( $name eq '.' );
      next if ( $name eq '..' );
      next if ( $name eq 'Imakefile' );
      next if ( $name eq 'Makefile' );
      if ( -d "$objectpath/$name" )
      {
         push(@files,&ckobj("$objectpath/$name","$updir/$name"));
      }
      else
      {
         push(@files,"$updir/$name");
      }
   }
   closedir(OBJECTDIR);
   return @files;
}

#------------------------------------------------------------------------
# Routine Name:	sortfiles - will parse the files passed on and remove the
#			    toolbox name
#
# Purpose:	To parse the files passed in and remove the toolbox name.
# !
# !              $KHOROS/objects/scripts/... will become objects/scripts/...
# !
#
# Input:	files - array of files to parse
#
# Returns:	list of parsed files
#
# Status:	Private Routine
# Written By:	John M Salas
# Date:		Mar 10, 1994
#------------------------------------------------------------------------
sub sortfiles
{
   local(@objdir) = shift;
   local(@files) = @_;
   local(@list);
   local($file);

   foreach $file (@files)
   {
      @parsed = split('/',$file);
      shift(@parsed);
      next if ( $parsed[$#parsed] eq 'Makefile' );
      $file = join("/",@parsed);
      push(@list,$file);
   }

   # 
   #  Since kecho does not return the $object/Imakefile, put it on the list.
   # 
   push(@list,"$objdir/Imakefile");

   return sort(@list);
}

#------------------------------------------------------------------------
# Routine Name: ckobjects - will return all objects found below directory
#			    passed in
#
# Purpose:	To check for directories that contain objects below the
#		directory passed in by the calling routine.  ., .., any
#		normal file, special files Makefile and Imakefile and the
#		directory bootstrap are ignored.
#
# Input:	tbpath - directory containing object directories
#
# Returns:	list of objects
#
# Status:	Private Routine
# Written By:	John M Salas
# Date:		Mar 10, 1994
#------------------------------------------------------------------------
sub ckobjects
{
      local($tbpath) = @_;
      local(@objects);

      return unless -d $tbpath;
      opendir(OBJECTSDIR,"$tbpath") || die "can not open $tbpath\n";
      foreach $name ( sort readdir(OBJECTSDIR))
      {
	 if ( $name ne "."	   && $name ne ".."       &&
	      $name ne "bootstrap" && -d "$tbpath/$name"  &&
	      $name ne "Imakefile" && $name ne "Makefile" )
	 {
	    push(@objects, &recordobjects("$tbpath/$name"));
	 }
      }
      closedir(OBJECTSDIR);
      return @objects;
}

#------------------------------------------------------------------------
# Routine Name: recordobjects - will create an array of every directory
#		in the directory passed in
#
# Purpose:	To create a list of every directory under the one passed
#		in by the calling routine.  Each directory is an object
#		of the toolbox.  ., .., any normal file and special files
#		like Makefile and Imakefile are ignored.
#
# Input:	typepath - directory to search for directories (objects)
#
# Returns:	list of directories (objects)
#
# Status:	Private Routine
# Written By:	John M Salas
# Date:		Mar 10, 1994
#------------------------------------------------------------------------
sub recordobjects
{
      local($typepath) = @_;
      local(@directories);

      opendir(TYPEDIR,$typepath) || die "can not open $typepath\n";
      foreach $name ( sort readdir(TYPEDIR))
      {
	 next if ( $name eq '.' );
	 next if ( $name eq '..' );
	 next if ( $name eq 'Imakefile' );
	 next if ( $name eq 'Makefile' );
	 if ( -d "$typepath/$name" )
	 {
	    push(@directories,$name);
	 }
      }
      closedir(TYPEDIR);
      return @directories;
}
#------------------------------------------------------------------------
# Routine Name:	determinetbdir - determine toolbox directory?
#
# Purpose:
#
# Input:	filename - file containing pack index
#
# Returns:	nothing
#
# Status:	Private Routine
# Written By:	John M Salas
# Date:		Apr 14, 1994
#------------------------------------------------------------------------
sub determinetbdir
{
   local($tbpath) = @_[0];
   local(@enddir);

   @enddir = split('/',$tbpath);

   return("$enddir[$#enddir]");
}

#------------------------------------------------------------------------
# Routine Name:	determineobjdir -
#
# Purpose:
#
# Input:	filename - file containing pack index
#
# Returns:	nothing
#
# Status:	private
# Written By:	John M Salas
# Date:		Apr 14, 1994
#------------------------------------------------------------------------
sub determineobjdir
{
   local($tbdir)   = @_[0];
   local($objdir)  = @_[1];
   local($i)       = 0;
   local($dir);
   local(@returndir);

   @dir = split('/',$objdir);

   while ( "$dir[$i]" ne "$tbdir" )
   {
      $i++;
   }

   $i++;
   while ( $i <= $#dir )
   {
      push(@returndir,$dir[$i]);
      $i++;
   }

   return(join("/",@returndir));
}

#------------------------------------------------------------------------
# Routine Name:	CheckUIS - check any UIS files associated with object
#
# Purpose:	This routine performs a number of checks on UIS files
#		associated with the object.  Currently the only check
#		performed is whether help files (-H) actually exist.
#
# Input:	object - name of software object being checked
#		opath  - path to top of software object
#
# Returns:	nothing
#
# Status:	private
# Written By:	Neil Bowers
# Date:		1-nov-94
#------------------------------------------------------------------------
sub CheckUIS
{
   local($object, $opath) = @_;
   local(@files);
   local($file);
   local($fullpath);
   local(*DIR);
   local(*UIS);
   local($uisdir);
   local($_);


   $uisdir = $opath.'/uis';
   return unless -d $uisdir;
   opendir(DIR, $uisdir) || return;
   @files = grep(/^[^.]/, readdir(DIR));
   closedir(DIR);

   foreach $file (@files)
   {
      next if $file =~ /~$/;
      next if $file =~ /\.bak$/;
      open(UIS, "< $uisdir/$file") || next;
      while (<UIS>)
      {
         next unless /^\s*-H.*\s+(\S+)\s+(\S+)\s*$/;
         $helpfile = $1;
         $fullpath = &khoros'fullpath($helpfile);
         unless (defined $fullpath && (-f $fullpath || -d _))
         {
	    print "        uis/$file($.): help file $helpfile not found\n";
         }
      }
      close UIS;
   }
}
