: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

# Khoros: $Id$
# $Log$

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#========================================================================
#
#  Program Name: kcksum - checks checksum's created by kcrsum
#
#       Purpose: The script will check the checksum's for the file in
#		 in a toolboxes' object.  If nothing specified on the
#		 command line than all toolboxes found in the files
#		 specified by KHOROS_TOOLBOX and all the objects within
#		 are checked.  You can specify multiple toolboxes by
#		 doing:
# !
# !                   % kcksum -tb toolbox1,toolbox2
# !
#                You can specify multiple objects by doing, but the object
#                will have to be in every toolbox:
# !
# !                   % kcksum -oname object1,object2
# !
#                If you combine the two options the objects specified must
#                be in every toolbox specified.
# !
# !                   % kcksum -tb toolbox1,toolbox2 -oname object1,object2
# !
#
#		 By default the current checksum for the files in the
#		 object are compared to the previous checksum for the
#		 object's files located in
#		 {toolbox}/objects/{object type}/{object}/db/{object}.cksum.
#
#		 where {toolbox} is the path to the toolboxes' top directory,
#		 {object type} is library, script, kroutine, etc. and {object}
#		 is the object name.
#
#		 If -version is specified than the checksum for the
#		 files in the object are compared against that version.
#		 The checksum for the object under that version by
#		 default is located in
#		 {toolbox}/objects/{object type}/{object}/db/{version}/{object}.cksum.
#
#		 If -dir1 is specified than the default checksum directory
#		 is changed from
#		 {toolbox}/{toolbox}/objects/{object type}/{object}/db
#		 to the directory specified.
#
#		 If -dir2 is specified -dir1 must also be specified.  The
#		 checksum's for the files in the objects are not calculated,
#		 but the object file checksum's found in -dir1 are compared
#		 to those in -dir2.  If -oname specified just those specified
#		 are compared.  You can not specify -version or -tb when
#		 -dir1 and -dir2 are specified.
#
#     Arguments: tb      - toolbox(es) to check
#		 oname   - object(s) to check
#		 version - version to compare against
#		 dir1    - location of files to compare against
#		 dir2    - files to compare those located in dir1 with
#
#   Exit Status: 1 if can not perform checking, 0 otherwise
#
#      Comments:
#    Written By: John M. Salas, Neil Bowers, Steve Kubica and Mark Young
#          Date: Apr 1, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#========================================================================
@khoros_toolbox = ('KHOROS_TOOLBOX');
if (! eval("\$toolboxes = \$ENV{\"KHOROS_TOOLBOX\"}"))
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
@toolbox_list = split(':', $toolboxes);
foreach $toolbox_file (sort(@toolbox_list))
{
   if ( ! open(TBS,"<$toolbox_file"))
   {
      print "Can not open $toolbox_file.  Please check to make sure your\n";
      die   "KHOROS_TOOLBOX environment variable points to existing files.\n";
   }

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}

@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "stat.pl";

#
# list of directories which we can expect to see in the toplevel of a toolbox
#
%tbdirs = (     'bin',          'executables',
                'data',         'sample data files',
                'examples',     'example programs',
                'help',         'help files',
                'include',      'public includes',
                'lib',          'library files',
                'mach',         'multiple architecture shadow trees',
                'manual',       'toolbox manual(s)',
                'objects',      'objects live in here',
                'repos',        'toolbox file repository',
                'testsuite',    'testsuites for objects in this toolbox'
        );

$whatis         = 'checks checksum\'s created by kcrsum';
@kcksum_args  = (
  '[tb]',       'toolbox1[,toolbox2]', 'name of toolbox(es) [all defined in KHOROS_TOOLBOX]',
  '[oname]',    'oname1[,oname2]',     'name of object(s) [all in the toolbox]',
  '[version]',  'version',             'the version name to checksum [none]',
  '[dir1]',     'dir1',   'directory 1 containing checksum files [{toolbox}/objects/{object type}/{object}/db]',
  '[dir2]',     'dir2',   'directory 2 containing checksum files to compare againts [none]',
);

#
# Initialize Khoros perl lib
#
&khoros'initialize("SUPPORT",$whatis,@kcksum_args);

# parse command line args
&khoros'parse_args(@ARGV);

#
# Get tmp directory to store temporary checksum files and tar files
#
$tmpdir = $ENV{'TMPDIR'};
if ($tmpdir eq '')
{
   $tmpdir = "/usr/tmp";
}

#
# Get the commandline.
#
$opt_t  = $khoros'seenswitch{"tb"};
$opt_o  = $khoros'seenswitch{"oname"};
$opt_v  = $khoros'seenswitch{"version"};
$opt_d1 = $khoros'seenswitch{"dir1"};
$opt_d2 = $khoros'seenswitch{"dir2"};

if ($opt_v)
{
  $version = $khoros'argval{"version"};
}

#
# Can not specify -tb, -dir1 and -dir2.
#
if (($opt_v || $opt_t) && $opt_d1 && $opt_d2)
{
   print "Do not specify -tb toolbox and/or -version version -dir1 path1 -dir2 path2\n";
   print "but -tb toolbox -dir1 path1,\n";
   print "-tb toolbox -version version -dir1 path1,\n";
   print "-version version -dir1 path1\n";
   print "or\n";
   print "-dir1 path1 -dir2 path2.\n";
   exit(1);
}

#
# Set $dir1 to specified value.
#
if ($opt_d1)
{
  $dir1 = $khoros'argval{"dir1"};
}

#
# Set -dir2 to specified value.  If -dir1 not specified than ignore it.
#
if ($opt_d2)
{
  $dir2 = $khoros'argval{"dir2"};
}

if (! $opt_d1 && $opt_d2)
{
  print "Must specify -dir1 for -dir2 to be used, ignoring -dir2's value.\n";
  $dir2 = "";
}


#
# If -dir1 and -dir2 specified and -oname specified, just compare those
# objects specified else do every file in -dir1.
#
if ($opt_d1 && $opt_d2)
{
   if ($opt_o)
   {
      $_ = $khoros'argval{"oname"};
      tr/,/\ /;
      @objects = split(' ', $_);
   }
   else
   {
      if ( ! opendir(DIR1,$dir1) )
      {
         print "Failed to open $dir1: $!\n";
	 exit(1);
      }

      while ($file = readdir(DIR1))
      {
	 next if ($file eq '.');
	 next if ($file eq '..');
         push(@objects,$file);
      }
      closedir(DIR1);
   }

#
# Check each object
#
   foreach $object (@objects)
   {
      print "$object\n";
      &compare_files("$dir1/$object","$dir2/$object");
   }
}
else
{
#
# Get the -tb option.  This option allows multiple toolboxes to be specified
# by doing -tb toolbox1,toolbox2.  If not specified all the toolboxes are
# checked.
#
   if ($opt_t)
   {
      $_ = &khoros'get_tb_name;
      $num = tr/,/\ /;
      @toolbox = split(' ', $_);
      for ( $i = 0 ; $i <= $#toolbox ; $i++ )
      {
         chop($tbpath = `kecho -tb $toolbox[$i] -echo path`);
         if ( $? )
         {
             print "toolbox $toolbox[$i] does not exist\n";
	     exit(1);
         }
      }
   }
   else
   {
      @toolbox = split(' ',`kecho -echo toolboxes`);
   }


#
# Create checksum for each object in the toolbox specified
#
   TOOLBOX: foreach $tb (sort(@toolbox))
   {
      print "$tb\n";

#
# Verify that toolbox exists in database
#
      chop($tbpath = `kecho -tb $tb -echo path`);
      unless ( -d $tbpath )
      {
         print "toolbox directory $tbpath does not exist\n";
         next TOOLBOX;
      }
      else
      {
         chdir("$tbpath");
      }

#
# Get the -oname option.  This option allows multiple objects to be specified
# by doing -oname object1,object2.  If not specified all the objects in the
# toolbox are checked.
#
      if ($opt_o)
      {
         $_ = $khoros'argval{"oname"};
         tr/,/\ /;
         @objects = split(' ', $_);
         for ( $i = 0 ; $i <= $#objects ; $i++ )
         {
            chop($objectpath = `kecho -tb $tb -oname $objects[$i] -echo path`);
            if ( $? )
            {
                print "object $objects[$i] does not exist in $tb\n";
		exit(1);
            }
         }
      }
      else
      {
         @objectsck = sort(split(' ',`kecho -tb $tb -echo objects`));
         @objects = sort(&ckobjects("$tbpath/objects"));
         if ( $#objectsck != $#objects ) 
         {
             print "\t>>> The objects in $tb do not match the database.\n\n";
             print "\t>>> Here is what kecho returns:\n\n";
             print "\t>>> @objectsck\n\n";
             print "\t>>> Here are the directories in the toolbox:\n\n";
             print "\t>>> @objects\n\n";
             print "\t>>> Please fix!\n";
             $exit_status = 1;
             next TOOLBOX;
         }
      }

#
# Check to see if previous checksum files exist.
#
      if ( $opt_d1 )
      {
         if ( ! -d "$dir1" )
         {
            print "Failed in accessing $tb/$dir1: $!\n";
            exit (1);
         }
         if ( $opt_v && ! -d "$dir1/$version" )
         {
            print "Failed in accessing $tb/$dir1/$version: $!\n";
            exit (1);
         }
      }
#
# Check each object specified
#
      foreach $object (@objects)
      {
         print "     $object\n";

#
# Verify that object exists in database
#
         chop($objectpath = `kecho -tb $tb -oname $object -echo path`);
         if ( $? )
         {
            print "object $object does not exist in $tb\n";
            exit (1);
         }

         $tbdir  = &determinetbdir("$tbpath");
         $objdir = &determineobjdir("$tbdir","$objectpath");
#
# Set the $dir variable if -dir not specified.
#
         if ( ! $opt_d )
         {
            $dir1   = "$objdir/db";

            if ( $opt_v && ! -d "$dir1/$version" )
            {
               print "Failed in accessing $tb/$dir1/$version: $!\n";
               exit (1);
            }
         }

#
# Open temporary checksum file for the object.
#
         if ( ! open(SUMOUT,">$tmpdir/$object.$$") )
         {
            print "Can not open output object checksum file $tmpdir/$object.$$\n";
            exit (1);
         }
#
# Get all the files in the object.
#
         @filesck = &sortfiles($objdir,split(' ',`kecho -tb $tb -oname $object -echo allfiles`));


#
# Calculate checksum for each file.
#
         for ( $i = 0 ; $i <= $#filesck ; $i++ )
         {
	    next if ( $filesck[$i] eq "$objdir/db/$object.cksum" );

	    if ( ! open(FILE,"<$filesck[$i]") )
            {
                print "Can not open object file $filesck[$i] for checking\n";
                exit (1);
            }
#
# Get checksum SYSV style.
#
	    $checksum = 0;
	    while (<FILE>)
	    {
	       $checksum += unpack("%32C*",$_);
	    }
	    $checksum = $checksum % 65535;
#
# Get blocks and size.
#
	    @stats = stat(FILE);
	    $st_size = @stats[$ST_SIZE];
	    $blocks = int($st_size / 512);
	    $blocks++ if ( $blocks );

	    print SUMOUT "$filesck[$i]:$checksum:$blocks:$st_size\n";
	    close(FILE);
         }
	 close(SUMOUT);

#
# Compare previous checksum with current.
#
         if ($opt_v)
         {
            &compare_files("$dir1/$version/$object.cksum","$tmpdir/$object.$$");
         }
         elsif (! $opt_v)
         {
            &compare_files("$dir1/$object.cksum","$tmpdir/$object.$$");
         }
#
# Cleanup
#
         unlink("$tmpdir/$object.$$");
      }
   }
}
exit($exit_status);

#------------------------------------------------------------------------
#
#  Routine Name: compare_files - routine compare to checksum files
#
#       Purpose: This routine will take the two specified checksum files
#		 and compare them.
#
#         Input: file1 - first checksum file to compare
#		 file2 - second checksum file to compare
#
#       Returns: TRUE if the same, FALSE if different or bad file name
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 4, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub compare_files {
   local($file1) = @_[0];
   local($file2) = @_[1];
   local($return_status) = 1;
   local(%filename1);
   local(%filename2);
   local(%checksum1);
   local(%checksum2);
   local(%blocks1);
   local(%blocks2);
   local(%size1);
   local(%size2);

#
# Open checksum files
#
   if ( ! open(SUMIN1, "<$file1") )
   {
      print "Can not open object file $file1 for checking\n";
      return (0);
   }

   if ( ! open(SUMIN2, "<$file2") )
   {
      print "Can not open object file $file2 for checking\n";
      close(SUMIN1);
      return (0);
   }

#
# Create associate arrays for each field in the checksum file: the filename,
# checksum, blocks and size.
#
   while(<SUMIN1>)
   {
      chop();
      @line = split(':',$_);
      $filename1{$line[0]} = 1;
      $checksum1{$line[0]} = $line[1];
      $blocks1{$line[0]}   = $line[2];
      $size1{$line[0]}     = $line[3];
      $count1++;
   }

   while(<SUMIN2>)
   {
      chop();
      @line = split(':',$_);
      $filename2{$line[0]} = 1;
      $checksum2{$line[0]} = $line[1];
      $blocks2{$line[0]}   = $line[2];
      $size2{$line[0]}     = $line[3];
      $count2++;
   }

#
# Compare the file1 filenames with those in file2.
#
   foreach $f (keys %filename1)
   {
      if ( !defined($filename2{$f}) )
      {
	 print "        not in $file2 checksum but in $file1: $f\n";
	 $return_status = 0;
	 $count1--;
      }

      if ( $checksum1{$f} != $checksum2{$f} ||
	   $blocks1{$f}   != $blocks2{$f} ||
	   $size1{$f}     != $size2{$f} )
      {
	 print "        checksum does not match for: $f\n";
	 $filename2{$f}  = 0;
	 $return_status = 0;
      }
   }

#
# If the count of files in file1 is different than that of file2 find the
# checksums in file2 that do not match those in file1.
#
   if ($count1 == $count2)
   {
      foreach $f (keys %filename2)
      {
         if ( !defined($filename1{$f}) )
         {
	    print "        not in $file1 checksum but in $file2: $f\n";
	    $return_status = 0;
         }

         if ( $filename2{$f} &&
	      ( $checksum1{$f} != $checksum2{$f} ||
	        $blocks1{$f}   != $blocks2{$f} ||
	        $size1{$f}     != $size2{$f} ) )
         {
	    print "        checksum does not match for: $f\n";
	    $return_status = 0;
         }
      }
   }
   return($return_status);
}

#------------------------------------------------------------------------
#
#  Routine Name: sortfiles - will parse the files passed on and remove the toolbox name
#
#       Purpose: To parse the files passed in and remove the toolbox name.
# !
# !              $KHOROS/objects/scripts/... will become objects/scripts/...
# !
#
#         Input: files - array of files to parse
#
#       Returns: list of parsed files
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Mar 10, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub sortfiles {

   local(@objdir) = shift;
   local(@files) = @_;
   local(@list);
   local($file);

   foreach $file (@files)
   {
      @parsed = split('/',$file);
      shift(@parsed);
      next if ( $parsed[$#parsed] eq 'Makefile' );
      $file = join("/",@parsed);
      push(@list,$file);
   }

#
#  Since kecho does not return the $object/Imakefile, put it on the list.
#
   push(@list,"$objdir/Imakefile");

   return sort(@list);
}


#------------------------------------------------------------------------
#
#  Routine Name: ckobjects - will return all objects found below directory passed in
#
#       Purpose: To check for directories that contain objects below the
#                directory passed in by the calling routine.  ., .., any
#		 normal file, special files Makefile and Imakefile and the
#		 directory bootstrap are ignored.
#
#         Input: tbpath - directory containing object directories
#
#       Returns: list of objects
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Mar 10, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub ckobjects {

      local($tbpath) = @_;
      local(@objects);

      opendir(OBJECTSDIR,"$tbpath") || die "can not open $tbpath\n";
      foreach $name ( sort readdir(OBJECTSDIR))
      {
         if ( $name ne "."         && $name ne ".."       &&
              $name ne "bootstrap" && -d "$tbpath/$name"  &&
              $name ne "Imakefile" && $name ne "Makefile" )
         {
            push(@objects, &recordobjects("$tbpath/$name"));
         }
      }
      closedir(OBJECTSDIR);
      return @objects;
}

#------------------------------------------------------------------------
#
#  Routine Name: recordobjects - will create an array of every directory in the directory passed in
#
#       Purpose: To create a list of every directory under the one passed
#                in by the calling routine.  Each directory is an object
#                of the toolbox.  ., .., any normal file and special files
#		 like Makefile and Imakefile are ignored.
#
#         Input: typepath - directory to search for directories (objects)
#
#       Returns: list of directories (objects)
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Mar 10, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub recordobjects {

      local($typepath) = @_;
      local(@directories);

      opendir(TYPEDIR,$typepath) || die "can not open $typepath\n";
      foreach $name ( sort readdir(TYPEDIR))
      {
         next if ( $name eq '.' );
         next if ( $name eq '..' );
         next if ( $name eq 'Imakefile' );
         next if ( $name eq 'Makefile' );
         if ( -d "$typepath/$name" )
         {
            push(@directories,$name);
         }
      }
      closedir(TYPEDIR);
      return @directories;
}

#------------------------------------------------------------------------
#
#  Routine Name: determinetbdir -
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 14, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub determinetbdir {
   local($tbpath) = @_[0];
   local(@enddir);

   @enddir = split('/',$tbpath);

   return("$enddir[$#enddir]");
}

#------------------------------------------------------------------------
#
#  Routine Name: determineobjdir -
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 14, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub determineobjdir {
   local($tbdir)   = @_[0];
   local($objdir)  = @_[1];
   local($i)       = 0;
   local($dir);
   local(@returndir);

   @dir = split('/',$objdir);

   while ( "$dir[$i]" ne "$tbdir" )
   {
      $i++;
   }

   $i++;
   while ( $i <= $#dir )
   {
      push(@returndir,$dir[$i]);
      $i++;
   }

   return(join("/",@returndir));
}


