eval 'exec perl -S $0 $*'
                if $runnning_under_some_shell;

#========================================================================
# Program Name: kad2doc - generate documentation source from app-defaults
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.


if (! defined $ENV{'KHOROS_TOOLBOX'})
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
foreach $toolbox_file (sort split(/:/, $ENV{'KHOROS_TOOLBOX'}))
{
   open(TBS,"<$toolbox_file") || do
   {
      warn "Can not open $toolbox_file.  Please check to make sure your\n";
      die  "KHOROS_TOOLBOX environment variable points to existing files.\n";
   };

   while (<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            warn "The SUPPORT toolbox is defined twice.  Please check your\n";
            warn "KHOROS_TOOLBOX environment variable and the file(s)\n";
            warn "pointed to by it and make sure that all toolboxes are\n";
            die  "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}


@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "kutils.pl";

$whatis = 'generate documentation source from app-defaults';
@clui_args  = (
        '[i]',   'file-name',   'input file',
        '[o]',   'file-name',   'output file'
);

chop($VERSION = `kecho -tb table -oname kattrtable -echo version`);
chop($DATE = `date`);
($PROGRAM = $0) =~ s/.*\///;

# initialize Khoros perl lib
&khoros'initialize("SUPPORT",$whatis,@clui_args);

&khoros'parse_args(@ARGV);                   # parse the command-line

# ------------------------------------------------------------------------
# Was an input file specified?  If not, default to stdin
# ------------------------------------------------------------------------

if ($khoros'seenswitch{'i'})
{
   open(INFILE, "< $khoros'argval{'i'}") || do
   {
      die "Unable to read input file $khoros'argval{'i'}: $!\n";
   };
}
else
{
   *INFILE = *STDIN;
}

# ------------------------------------------------------------------------
# Was an output file specified?  If not, default to stdout
# ------------------------------------------------------------------------

if ($khoros'seenswitch{'o'})
{
   open(OUTFILE, "> $khoros'argval{'o'}") || do
   {
      die "Unable to write output file $khoros'argval{'o'}: $!\n";
   };
}
else
{
   *OUTFILE = *STDOUT;
}

&GenerateHeader(*OUTFILE);
&GenerateFromInput(*INFILE, *OUTFILE);

close INFILE if $khoros'seenswitch{'i'};
close OUTFILEFILE if $khoros'seenswitch{'o'};

# ========================================================================
# Function Name: GenerateHeader() - generate comment block at head of file
# Purpose:       This function generates a block of roff comments to go
#		 at the head of the generated file.
# ========================================================================
sub GenerateHeader
{
   local(*HANDLE) = @_;
   local($oldfh);


   $oldfh = select(HANDLE);
   print ".\\\" ----------------------------------------------------------\n";
   print ".\\\" DO NOT MODIFY - this file is auto-generated\n";
   print ".\\\"\n";
   print ".\\\" Generated by:   $PROGRAM $VERSION\n";
   print ".\\\" Date Generated: $DATE\n";
   print ".\\\" ----------------------------------------------------------\n";
   select($oldfh);
}

# ========================================================================
# Function Name: GenerateFromInput
# Purpose:       This function generates a block of roff comments to go
#		 at the head of the generated file.
# ========================================================================
sub GenerateFromInput
{
   local(*IN, *OUT) = @_;
   local($inbody);


   $inbody = 0;
   while (<IN>)
   {
      if ($inbody == 0 && /^!\s*INHERITANCE/)
      {
	 $inbody=1;
	 print OUT ".begin code\n";
      }

      next unless $inbody;

      print OUT;
   }

   print OUT ".end code\n" if $inbody;
}
