 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Search Object Utility
   >>>>
   >>>>  Private:
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "kgrepobj.h"


/*-----------------------------------------------------------
|
|  Routine Name: search_object - search a program object for the
|				 desired string
|
|       Purpose: This program searches a program object for a particular
|		 key.  The key is a regular expression which is formatted
|		 to look for a routine name, function, or string.
|
|         Input: program - the program object to be searched
|		 key     - the key to be search for
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Sep 28, 1993
| Modifications:
|
------------------------------------------------------------*/

void search_object(
   kobject program,
   char	   *key)
{
	int  status;
	kobject fileobj;
	klist	*list = NULL;
	char *data, *function, *tmp, *path;


	kcms_get_attribute(program, KCMS_CMOBJ_ALL_SRC, &list);
	while (list != NULL)
	{
	   fileobj = klist_clientdata(list);
	   kcms_get_attribute(fileobj, KCMS_FOBJ_FULLNAME, &path);
	   if ((data = kreadfile(path, NULL)) != NULL)
	   {
	      tmp = data;
	      while ((tmp = kparse_string_search(tmp, key, KIGNORE_CASE,
			&function, &status)) != NULL)
	      {
	         kprintf("found function: '%s' in file: '%s'\n",function, path);
	         kfree(function);
	      }
	      kfree(data);
	   }
	   else
	   {
	      kinfo(KSTANDARD, "Unable to open file '%s'\n", path);
	   }
	   list = klist_next(list);
	}
}
