 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgentbindex
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgentbindex.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - generate index for a toolbox manual
|
|       Purpose: main program for kgentbindex
|
|         Input:
|		Required M.E. group:
|		    int clui_info->alltb_flag; {TRUE if -alltb specified}
|
|		    char *clui_info->tb_string; {Generate a manual index for a single toolbox}
|		    int   clui_info->tb_flag; {TRUE if -tb specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
   int	PROCESS_ALL_TBS = 0;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "SUPPORT");
	kexit_handler(kgentbindex_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "SUPPORT", "kgentbindex",
		kgentbindex_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgentbindex_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
   PROCESS_ALL_TBS = process_cmd_line();

   if (PROCESS_ALL_TBS)
      process_all_tbs();
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgentbindex_usage_additions
| 
|       Purpose: Prints usage additions in kgentbindex_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgentbindex
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgentbindex_usage_additions(void)
{
	kfprintf(kstderr, "\tgenerate index for a toolbox manual\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgentbindex_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgentbindex_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgentbindex
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgentbindex_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
