#!/bin/csh -f

#
#  Khoros: $Id$
#
# $Log$
#

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#************************************************************
#
#  Routine Name: kfix - update khoros 1.0 code to khoros 2.0 code
#
#       Purpose: This routine runs a series of shell scripts on source
#		 code files, that convert the old vgparm & transport, vexpr,
#		 and vmath routine calls to their 2.0 kutils, kexpr, and
#		 kmath equivalent.
#  Restrictions: This shell script cannot pick up all conversions since
#		 some calls involve parameter changes.
#    Written By: Steven Jorgensen
#          Date: Feb 02, 1993
#  Side Effects: This routine modifies all .c's and .h's in the current
#		 directory.  The original files are in *.old
# Modifications:
#
#************************************************************/

set path = ( . $path /usr/local/bin /usr/ucb \
             /usr/bin /bin /usr/local/etc/ /usr/etc /etc )

set nonomatch
set noecho

set TOOLBOX = migration
set KHOROS_TOOLBOXES = (`echo $KHOROS_TOOLBOX | sed -e 's/:/ /g'`)
foreach tbfile ($KHOROS_TOOLBOXES)
	set TBPATH = `kecho -tb $TOOLBOX -oname kfix -echo path`
	if ("$TBPATH" != "") break
end

if ( "$TBPATH" == "" ) then
  echo ""
  echo "kfix:  Error, The $TOOLBOX entry does not exist in your toolbox file"
  echo "       '$KHOROS_TOOLBOX'.  Please add the toolbox entry to it before"
  echo "       using kfix"
  echo ""
  exit 1
endif

set flag = "nogo"
set oldfiles = *.old
set cfiles = *.c
set lfiles = *.l
set yfiles = *.y
set hfiles = *.h
set scripts = $TBPATH/misc/*.sed

if ( ! $#argv && $#oldfiles > 0 && $oldfiles[1] != '*.old' ) then
  echo ""
  echo "NOTICE: '.old' files already exist (perhaps from a previous session)."
  echo "The '.old' files will be overwritten by the original '.c', '.l',"
  echo "'.y', or '.h' files"
  echo -n "Do you you want to continue? (y/n) "
  set a = $<
  if ( $a != 'y' && $a != 'Y' ) then
    echo ""
    exit 0
  endif
  echo "Continuing as requested..."
endif

if ( ! $#argv && \
     $#cfiles == 1 && $cfiles[1] == '*.c' && \
     $#lfiles == 1 && $lfiles[1] == '*.l' && \
     $#hfiles == 1 && $hfiles[1] == '*.h' && \
     $#yfiles == 1 && $yfiles[1] == '*.y' ) then
  echo ""
  echo "NO '.c', '.l', '.y', or '.h' files exist.  Cannot perform any updates."
  echo ""
  exit 0
endif

set ok = "nogo"
set sfiles = ""
if ( ! $#argv ) then
  set doall = "no"
  if ( $cfiles[1] != '*.c' ) then
    set sfiles = `echo $sfiles $cfiles`
    set ok = "go"
  endif
  if ( $lfiles[1] != '*.l' ) then
    set sfiles = `echo $sfiles $lfiles`
    set ok = "go"
  endif
  if ( $yfiles[1] != '*.y' ) then
    set sfiles = `echo $sfiles $yfiles`
    set ok = "go"
  endif

  if ( $hfiles[1] != '*.h' ) then
    echo ""
    echo "NOTICE: '.h' files exist."
    echo -n "Do you want to convert them also? (y/n) "
    set a = $<
    if ( $a == 'y' || $a == 'Y' ) then
      set sfiles = `echo $sfiles $hfiles`
      set ok = "go"
    endif
  endif
else
  set ok = "go"
  set sfiles = `echo $argv`
  set doall = "yes"
endif

if ( $ok == "nogo") then
  exit 0
endif

echo ""
echo "Khoros 2.0 conversion script"
echo ""
if ( $doall == "yes" ) then
  echo "This script will convert all 2.0 library calls."
else
  echo "This script will convert library calls for the following libraries, or"
  echo "all of the 2.0 libraries."
endif
echo ""

if ( $doall == "no") then
  while ( $flag == "nogo" )

    @ cnt = 1

    foreach i ( $scripts )
      echo -n "$cnt.  Convert "
      set t = $i:t
      echo "$t:r library calls"
      @ cnt++
    end
    echo "$cnt.  Convert all library calls"
    echo ""
    echo -n "Please enter your selection: "
    set ans = $<

    if ( $ans <= 0 || $ans > $cnt ) then
      echo "ERROR!  Invalid choice"
      echo ""
      continue
    endif
    set flag = "go"
  end
else
  @ cnt = $#scripts
  @ ans = $#scripts
  @ cnt++
  @ ans++
endif

if ( $ans == $cnt ) then
  foreach i ( $sfiles )
    echo ""
    @ cnt1 = 1
    /bin/cp $i $i.$$
    while ($cnt1 < $cnt)
      set t = $scripts[$cnt1]:t
      echo "Converting $i for $t:r library calls"
      /bin/mv -f $i $i.old
      sed -f $scripts[$cnt1] $i.old > $i
      if ( $status != 0 ) then
	echo ""
	echo "ERROR! $i conversion for $t:r library calls failed"
	echo "moving original file back"
	/bin/mv -f $i.$$ $i
	exit 1
      endif
      @ cnt1++
    end
    /bin/mv -f $i.$$ $i.old
  end
exit 0
endif

foreach i ( $sfiles )
  set t = $scripts[$ans]:t
  echo "Converting $i for $t:r library calls"
  /bin/mv -f $i $i.old
  sed -f $scripts[$ans] $i.old > $i
  if ( $status != 0 ) then
    echo ""
    echo "ERROR! $i conversion for $t:r library calls failed"
    echo "moving original file back"
    /bin/mv -f $i.$$ $i
    exit 1
  endif
end
exit 0
