 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Contents Title
   >>>>
   >>>>   Static:
   >>>>   Public:
   >>>>		  gr_read_configfile()
   >>>>		  gr_read_path()
   >>>>  Private:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

char *gr_read_path PROTO((kfile *, char *));

/************************************************************
*
*  Routine Name: gr_read_configfile - read a Khoros 1.0 file ending in .conf
*
*      Purpose: This routine gets path info from the config file -
*		if it can't get path for any of the files, it will
*		set the pathname to the local "." directory.
*		Prompts the user to be sure all paths are set correctly,
*		and will exit the program if the user does not respond "y".
*
*        Input: filename - full path to config file 
*		config_keys - the list of search keys in the .conf file
*		num - the number of keys in the conf file
*
*	Output: config_paths - path names associated with config_keys
*      Returns: TRUE (1) on success, FALSE (0) on failure
*	  Date: Aug 29, 1994
*   Written By: Danielle Argiro
*
*************************************************************/
int gr_read_configfile(
	char *filename,
	char **config_keys,
	int num,
	char **config_paths)
{
     kfile *config_file;
     int   i;

    /*
     *  Open configuration file
     */
     if ((config_file = kfopen(filename, "r")) == NULL)
     {
         kwarn("ghost","gr_read_configfile" "Unable to open '%s' to read "
	       "config file\n", filename);
	 for (i = 0; i < num; i++)
	     config_paths[i] =  NULL;
	 return(FALSE);
     }

     for (i = 0; i < num; i++)
	config_paths[i] = gr_read_path(config_file, config_keys[i]);
     return(TRUE);
}


/************************************************************
*
*  Routine Name: gr_read_path() - read a single path out of a Khoros 1.0 .conf
*				  file
*
*      Purpose: This routine gets a single path from the config file 
*	        based on the config key passed in.
*
*        Input: config_file - open stream to config file
*		config_key  - key that will mark the desired path.
*
*      Returns: the correct path from the config file if successful,
*		NULL on failure.
*
*   Written By: Danielle Argiro
*
*************************************************************/

char *gr_read_path(
	kfile *config_file,
	char *config_key)
{
	int i=0, indx, found;
	char buffer[KLENGTH];
	char *path;

	/*
	 *   look for the config key passed in, and
 	 *   return null if we can't find it 
	 */
        found = FALSE;
	krewind(config_file);
    	while (!found) 
	{
	    /* get a line from the config file */
            if (kfgets(buffer, KLENGTH, config_file) == NULL) 
	        return (NULL);

	    /*  ignore any leading blanks or tabs */
	    i = 0;  while ((buffer[i] == ' ') || (buffer[i]=='\t'))  i++;

	    /* see if we've found our config key */
            if (kstrncmp(&buffer[i], config_key, kstrlen(config_key)) == 0) 
                 found = TRUE;

        }

	/* 
	 * the path appears after any tabs or blanks, and after the 
	 * config key itself, which will be followed by a colon.  Need
	 * to skip by all these items before copying any text into our path.
	 *
	 * note: no need to expand tildas now; that will be done later, when
	 *       the path found is actually used to get information for
	 *	 ghostreader.
	 */

	path = kstrdup(&buffer[i + kstrlen(config_key) +1]);

	/*  
	 * need to ignore any blanks or tabs that may follow "key:" 
	 */
	indx = 0;  while ((path[indx] == ' ') || (path[indx]=='\t')) indx++;
	/*  
	 * also need to cut off any trailing blanks and 
	 * the <cr> at end of path string
	 */  
	i = indx;  
	while ((path[i] != ' ') && (path[i]!='\t') && (path[i] != '\n')) i++;
	path[i] = '\0';
	return(&path[indx]);
}
