 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for ktbupdb
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "ktbupdb.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Update Toolbox database to point to new toolbox.def file
|
|       Purpose: main program for ktbupdb
|
|         Input:
|		char *clui_info->tb_string; {Toolbox that needs its toolbox updated}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
   kobject  object;
   kstring *toolbox_names = NULL;
   kstring  toolbox_path;
   kdbm    *cms;
   char     tpbuf[KLENGTH];
   char     upper[KLENGTH];
   int      toolbox_count = 0;
   int      i;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MIGRATION");
	kexit_handler(ktbupdb_free_args, NULL);

/* -main_get_args_call */
   pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MIGRATION", "ktbupdb",
		          ktbupdb_usage_additions);

   if (!(kclui_check_args()))
      kexit(KEXIT_FAILURE);
   ktbupdb_get_args(pane);
   kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
   if (clui_info->tb_flag == TRUE)
   {
      toolbox_names = kparse_string_delimit(clui_info->tb_string, ", \t",
		      KDELIM_CLEAN, &toolbox_count);
   }
   else
      toolbox_names = kcms_query_toolboxes(&toolbox_count);
   for (i = 0; i < toolbox_count; i++)
   {
      if ((object = kcms_open_toolbox(toolbox_names[i])) == NULL)
      {
	 kinfo(KSTANDARD, "Cannot open toolbox '%s', skipping...",
		toolbox_names[i]);
	 continue;
      }
      if (kcms_get_attribute(object, KCMS_PATH, &toolbox_path) == FALSE)
      {
	 kinfo(KSTANDARD, "Cannot get path for toolbox '%s', skipping...",
		toolbox_names[i]);
	 continue;
      }
      ksprintf(tpbuf, "%s/repos/db/cms", toolbox_path);
      if ((cms = kdbm_open(tpbuf, KOPEN_WRONLY, 0777)) == NULL)
      {
	 kinfo(KSTANDARD,
	       "Cannot open toolbox database for toolbox '%s', skipping...",
	       toolbox_names[i]);
	 continue;
      }
      kstring_upper(toolbox_names[i], upper);
      ksprintf(tpbuf, "$%s/repos/config/imake_config/toolbox.def", upper);
      kinfo(KSTANDARD, "Updating toolbox: '%s'", toolbox_names[i]);
      kcms_db_update_string(cms, tpbuf, KCMS_KEY_CONFIG_FILE);
      kdbm_close(cms);
   }
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: ktbupdb_usage_additions
| 
|       Purpose: Prints usage additions in ktbupdb_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ktbupdb
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ktbupdb_usage_additions(void)
{
	kfprintf(kstderr, "\tUpdate Toolbox database to point to new toolbox.def file\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: ktbupdb_free_args
| 
|       Purpose: Frees CLUI struct allocated in ktbupdb_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ktbupdb
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
ktbupdb_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
