 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kdarwin
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kdarwin.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - A program to evolve 1.0 programs to 2.0 objects
|
|       Purpose: main program for kdarwin
|
|         Input:
|		char *clui_info->tb_string; {Toolbox object to hold the new software object}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->oname_string; {Software object name to use the for the converted vroutine}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		char *clui_info->cat_string; {Category Name used in Cantata}
|		int   clui_info->cat_flag; {TRUE if -cat specified}
|
|		char *clui_info->subcat_string; {Subcategory Name used in Cantata}
|		int   clui_info->subcat_flag; {TRUE if -subcat specified}
|
|		char *clui_info->description_string; {The short description of the object}
|		int   clui_info->description_flag; {TRUE if -description specified}
|
|		char *clui_info->icon_string; {Icon Name used for glyph in Cantata}
|		int   clui_info->icon_flag; {TRUE if -icon specified}
|
|		Required M.E. group:
|		    M.I. group:
|			char *clui_info->prog_file; {Khoros 1.0 Prog filename to get program code and documentation information from}
|			int   clui_info->prog_flag; {TRUE if -prog specified}
|
|			char *clui_info->pane_file; {Khoros 1.0 Pane Filename to get program uis information from}
|			int   clui_info->pane_flag; {TRUE if -pane specified}
|
|		    char *clui_info->conf_file; {Khoros 1.0 conf filename to use to get paths for *.pane and *.prog}
|		    int   clui_info->conf_flag; {TRUE if -conf specified}
|
|		char *clui_info->lname_string; {Library object to put the vroutine l*.c file into}
|		int   clui_info->lname_flag; {TRUE if -lname specified}
|
|        Output:
|       Returns:
|
|    Written By: Steven Jorgensen
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject toolbox, routine, library = NULL, file_object;
	kfile *prog;
	char temp [KLENGTH], temp1[KLENGTH], oldname[KLENGTH];
	char **prog_spec;
	char *prog_path, *pane_path, *tmp, *tmp1;
	char *conf_info[KG_MAX_CONF_KEYS], *conf_keys[KG_MAX_CONF_KEYS];
	char **keynames[2];
	int result, i;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MIGRATION");
	kexit_handler(kdarwin_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MIGRATION", "kdarwin",
		kdarwin_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kdarwin_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/*
	 * make sure 2.0 stuff is ready to accept input
	 */
	if ((toolbox = kcms_open_toolbox(clui_info->tb_string)) == NULL)
	{
		kerror(NULL, NULL, "Cannot open the toolbox '%s'\n",
			clui_info->tb_string);
		kexit(KEXIT_FAILURE);
	}
	if (clui_info->lname_flag && ((library = kcms_open_cmobj(toolbox,
	    clui_info->lname_string))==NULL))
	{
		kerror(NULL, NULL, "Cannot open library object '%s' in toolbox '%s'.  The library object must be created before running kdarwin", clui_info->lname_string, clui_info->tb_string);
		kcms_close(toolbox);
		kexit(KEXIT_FAILURE);
	}
	else if (! clui_info->lname_flag)
		kinfo(KSTANDARD, "No lname was specified on the commandline.  \
This implies that the prog sections for the library and man 3 page will be \
ignored.  This includes the short description, long description, input, output,\
returns, restrictions, verify, side effects, modifications, definition, code, \
and includes.\n");
	kinfo(KSTANDARD, "Generating template object");
	if ((routine = kcms_open_cmobj(toolbox, clui_info->oname_string)) !=
	     NULL)
	{
		if (kprompt(KSTANDARD, NULL, NULL, 0, "The software object '%s' already exists in the toolbox '%s', use this routine to put the 1.0 info into?",clui_info->oname_string, clui_info->tb_string) == FALSE)
		{
			if (library) kcms_close(library);
			kcms_close(routine);
			kcms_close(toolbox);
			kexit(KEXIT_FAILURE);
		}
	}
	else if ((routine = kcms_generate_cmobj(toolbox,
		  clui_info->oname_string, KCMS_KROUTINE, NULL,
		  clui_info->cat_string, clui_info->subcat_string,
		  clui_info->description_string, clui_info->lname_string,
		  KCMS_NOLANG, FALSE, TRUE, TRUE, NULL)) == NULL)
	{
		kerror(NULL, NULL, "Cannot generate the object '%s'",
		      clui_info->oname_string);
		if (library) kcms_close(library);
		kcms_close(toolbox);
		kexit(KEXIT_FAILURE);
	}
	kinfo(KSTANDARD, "Generating empty ghostwriter files");
	if ((routine = ghost_it(routine)) == NULL)
	{
		if (library) kcms_close(library);
		kcms_close(toolbox);
		kexit(KEXIT_FAILURE);
	}
	kcms_set_attribute(routine,KCMS_CMOBJ_ICON_NAME,clui_info->icon_string);
	/*
	 * get 1.0 information to pass on.
	 */
	if (clui_info->conf_flag)
	{
		gw_init_config_keys(conf_keys);
		result = gr_read_configfile(clui_info->conf_file, conf_keys,
		     			    KG_MAX_CONF_KEYS, conf_info);
		for (i = 0; i < KG_MAX_CONF_KEYS; i++)
			kfree(conf_keys[i]);
		if (result == FALSE)
		{
			kerror(NULL, NULL, "Cannot open '%s'",
			       clui_info->conf_file);
			if (library) kcms_close(library);
			kcms_close(routine);
			kcms_close(toolbox);
			kexit(KEXIT_FAILURE);
		}
		kbasename(clui_info->conf_file, temp);
		temp[kstrchr(temp,'.') - temp] = '\0';
		ksprintf(temp1, "%s/%s.prog", conf_info[KG_PROGPATH], temp);
		prog_path = kstrdup(temp1);
		ksprintf(temp1, "%s/%s.pane", conf_info[KG_PANEPATH], temp);
		pane_path = kstrdup(temp1);
		for (i = 0; i < KG_MAX_CONF_KEYS; i++)
			kfree(conf_keys[i]);
	}
	else
	{
		prog_path = kstrdup(clui_info->prog_file);
		pane_path = kstrdup(clui_info->pane_file);
	}

	kbasename(pane_path, oldname);
	tmp = kstrrchr(oldname, '.');
	if ( tmp )
		*tmp = '\0';

	if (kaccess(pane_path, R_OK) == -1)
	{
/* MY: need to prompt for path to pane */
		kerror(NULL, NULL, "Cannot access pane file '%s'", pane_path);
		if (library) kcms_close(library);
		kcms_close(routine);
		kcms_close(toolbox);
		kfree(prog_path);
		kfree(pane_path);
		kexit(KEXIT_FAILURE);
	}

	kinfo(KSTANDARD, "Get PROG information");
	gw_init_keynames(keynames);
	if ((prog = kfinput(prog_path)) == NULL)
	{
/* MY: need to prompt for path to prog */
		kerror(NULL, NULL, "Cannot open prog file in path '%s'",
			prog_path);
		if (library) kcms_close(library);
		kcms_close(routine);
		kcms_close(toolbox);
		kfree(prog_path);
		kfree(pane_path);
		kexit(KEXIT_FAILURE);
	}
	prog_spec = gw_read_progfile(prog);
	for (i = 0; i < MAX_PROGSPEC_SIZE; i++)
	{
		kfree(keynames[0][i]);
		kfree(keynames[1][i]);
	}
	kfree(keynames[0]);
	kfree(keynames[1]);

	kinfo(KSTANDARD, "Update UIS file to 2.0 format");
	if (uis_replace_update(routine, pane_path) == FALSE)
	{
		if (library) kcms_close(library);
		kcms_close(routine);
		kcms_close(toolbox);
		kfree(prog_path);
		kfree(pane_path);
		kexit(KEXIT_FAILURE);
	}

	kinfo(KSTANDARD, "Update UIS to comply with cantata standard format");
	tmp = clui_info->description_string;
	if (uis_cantata_update(routine, tmp) == FALSE)
	{
		if (library) kcms_close(library);
		kcms_close(routine);
		kcms_close(toolbox);
		kfree(prog_path);
		kfree(pane_path);
		kexit(KEXIT_FAILURE);
	}

	kinfo(KSTANDARD, "Regenerate command line UIS code");
	if ((routine = ghost_it(routine)) == NULL)
	{
		if (library) kcms_close(library);
		kcms_close(toolbox);
		kfree(prog_path);
		kfree(pane_path);
		kexit(KEXIT_FAILURE);
	}

	kinfo(KSTANDARD, "Update sections of object from prog spec");
	ksprintf(temp,"%s->", oldname);
	ksprintf(temp1,"clui_info->");
	kcms_get_attribute(routine, KCMS_NAME, &tmp1);
	kinfo(KSTANDARD, "-- Convert '%s' to '%s' in prog sections",temp,temp1);
	for (i = 0; i < MAX_PROGSPEC_SIZE; i++)
	{
		tmp = kstring_replace(prog_spec[i], temp, temp1, NULL);
		kfree(prog_spec[i]);
		prog_spec[i] = tmp;
		tmp = kstring_replace(prog_spec[i], oldname, tmp1, NULL);
		kfree(prog_spec[i]);
		prog_spec[i] = tmp;
		tmp = kstring_cleanup(prog_spec[i], NULL);
		kfree(prog_spec[i]);
		prog_spec[i] = kstring_cat(tmp, "\n", NULL);
		kfree(tmp);
	}
	kinfo(KSTANDARD, "-- Update the program related prog sections");
	for (i=AUTHORS; i < MAN3_SHORTDESC; i++)
	{
		if (i != MAIN_GETARGS && i != MAIN_VARIABLES &&
		    i != INCLUDE_ADDITIONS)
			kcms_set_attribute(routine, kgen_ghost2att(i),
				   prog_spec[i]);
		else if (i != INCLUDE_ADDITIONS)
		{
			kcms_get_attribute(routine, kgen_ghost2att(i), &tmp);
			if (i == MAIN_GETARGS)
			      tmp1 = kstring_3cat(
					"\tprogram = kprog_get_program();\n",
					tmp, prog_spec[i], NULL);
			else
				tmp1 = kstring_3cat("char *program = NULL;\n",
						tmp, prog_spec[i], NULL);
			kcms_set_attribute(routine, kgen_ghost2att(i), tmp1);
			kfree(tmp1);
		}
	}

	if (library)
	{
		kinfo(KSTANDARD, "-- Update the library related prog sections");
		tmp = NULL;
		for (i=MAN3_SHORTDESC;i <= MAN3_MANUAL;i++)
		{
			kcms_get_attribute(library, kgen_ghost2att(i), &tmp);
			tmp = kstring_cat(tmp, prog_spec[i], NULL);
			kcms_set_attribute(library, kgen_ghost2att(i), tmp);
			kfree(tmp);
		}

		kinfo(KSTANDARD, "Run kfix l%s.c", clui_info->oname_string);

	        kcms_get_attribute(routine, KCMS_CMOBJ_GEN_LFILE, &file_object);

	        if (file_object == NULL)
	        {
	        	kerror("kdarwin",  "main", "Library routine for this \
program object does not appear in database");
	        	kcms_close(toolbox);
	        	kfree(prog_path);
	        	kfree(pane_path);
	        	kexit(KEXIT_FAILURE);
	        }
        
	        kcms_get_attribute(file_object, KCMS_FOBJ_FULLNAME, &tmp);

		if (kfix_it(tmp) == FALSE)
		{
			kcms_close(library);
			kcms_close(routine);
			kcms_close(toolbox);
			kfree(prog_path);
			kfree(pane_path);
			kexit(KEXIT_FAILURE);
		}

		(void) protoize_it(routine, library);
		
		kinfo(KSTANDARD,"Update the man page database for the library");
		if ((library = ghost_it(library)) == NULL)
		{
			kcms_close(routine);
			kcms_close(toolbox);
			kfree(prog_path);
			kfree(pane_path);
			kexit(KEXIT_FAILURE);
		}

        	for (i = 0; i < MAX_PROGSPEC_SIZE; i++)
        	{
                	kfree(prog_spec[i]);
		}

	}

	kcms_get_attribute(routine, KCMS_CMOBJ_TOPSRC, &tmp);
	kinfo(KSTANDARD, "Run kfix %s.c", clui_info->oname_string);
	ksprintf(temp, "%s/%s.c", tmp, clui_info->oname_string);
	if (kfix_it(temp) == FALSE)
	{
		if (library) kcms_close(library);
		kcms_close(routine);
		kcms_close(toolbox);
	}

	kinfo(KSTANDARD, "Run kfix %s.h", clui_info->oname_string);
	ksprintf(temp, "%s/%s.h", tmp, clui_info->oname_string);
	if (kfix_it(temp) == FALSE)
	{
		if (library) kcms_close(library);
		kcms_close(routine);
		kcms_close(toolbox);
	}

	if ((routine = ghost_it(routine)) == NULL)
	{
		if (library) kcms_close(library);
		kcms_close(toolbox);
		kfree(prog_path);
		kfree(pane_path);
		kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
	if (library) kcms_close(library);
	kcms_close(routine);
	kcms_close(toolbox);
	kfree(prog_path);
	kfree(pane_path);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kdarwin_usage_additions
| 
|       Purpose: Prints usage additions in kdarwin_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kdarwin
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kdarwin_usage_additions(void)
{
	kfprintf(kstderr, "\tA program to evolve 1.0 programs to 2.0 objects\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kdarwin_free_args
| 
|       Purpose: Frees CLUI struct allocated in kdarwin_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kdarwin
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kdarwin_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
	kfree(clui_info->cat_string);
	kfree(clui_info->subcat_string);
	kfree(clui_info->description_string);
	kfree(clui_info->icon_string);
	kfree(clui_info->prog_file);
	kfree(clui_info->lname_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
