 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for dbcnvrt
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "dbcnvrt.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Convert from a pre-Khoros 2.0 kdbm file to a 2.0 kdbm file
|
|       Purpose: main program for dbcnvrt
|
|         Input:
|		Required M.E. group:
|		    M.I. group:
|			char *clui_info->i_file; {Input database file}
|			int   clui_info->i_flag; {TRUE if -i specified}
|
|			char *clui_info->o_file; {Output Database Filename}
|			int   clui_info->o_flag; {TRUE if -o specified}
|
|		    char *clui_info->tb_string; {Change the cms databases for a whole toolbox}
|		    int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		int clui_info->rm_flag; {TRUE if -rm specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MIGRATION");
	kexit_handler(dbcnvrt_free_args, NULL);

/* -main_get_args_call */
  pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MIGRATION", "dbcnvrt",
		dbcnvrt_usage_additions);

  if (!(kclui_check_args()))
    kexit(KEXIT_FAILURE);
  dbcnvrt_get_args(pane);
  kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
   if (clui_info->tb_flag)
   {
      if (convert_tb(clui_info->tb_string) == FALSE)
      {
	 kerror(NULL, NULL, "Unable to convert toolbox dbfiles from '%s'",
		clui_info->tb_string);
         kexit(KEXIT_FAILURE);
      }
   }
   else
   {
      if (convert_file(clui_info->i_file, clui_info->o_file,
		       clui_info->rm_flag) == FALSE)
      {
	 kerror(NULL, NULL, "Unable to convert dbfile from '%s' to '%s'",
		clui_info->i_file, clui_info->o_file);
         kexit(KEXIT_FAILURE);
      }
   }
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: dbcnvrt_usage_additions
| 
|       Purpose: Prints usage additions in dbcnvrt_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname dbcnvrt
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void dbcnvrt_usage_additions(void)
{
	kfprintf(kstderr, "\tConvert from a pre-Khoros 2.0 kdbm file to a 2.0 kdbm file\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: dbcnvrt_free_args
| 
|       Purpose: Frees CLUI struct allocated in dbcnvrt_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname dbcnvrt
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
dbcnvrt_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
