#! /bin/sh

echo "running test1.sh for minvert ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb MATRIX -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1: invert diagonal matrix
# ------------------------------------------------------------------------
test_num=1
descr="invert diagonal matrix"
cat <<EOF > $tmpdir/ascii.$$
1 0 0
0 2 0
0 0 4
EOF
minvert -i $tmpdir/ascii.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
1 0   0 
0 0.5 0
0 0   0.25
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  2: invert diagonal only (square)
# ------------------------------------------------------------------------
test_num=2
descr="invert diagonal only (square)"
cat <<EOF > $tmpdir/ascii.$$
1 1 1
2 2 2
4 4 4
EOF
minvert -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -diag
cat <<EOF > $tmpdir/ascii.$$
1 1 1
2 0.5 2
4 4 0.25
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  3: invert diagonal only (nonsquare)
# ------------------------------------------------------------------------
test_num=3
descr="invert diagonal only (nonsquare)"
cat <<EOF > $tmpdir/ascii.$$
1 1 1
2 2 2
4 4 4
5 5 5
EOF
minvert -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -diag
cat <<EOF > $tmpdir/ascii.$$
1 1 1
2 0.5 2
4 4 0.25
5 5 5
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  4: invert rotation matrix
# ------------------------------------------------------------------------
test_num=4
descr="invert rotation matrix"
cat <<EOF > $tmpdir/ascii.$$
1 0 0
0 0.8660254 0.5
0 -0.5 0.8660254
EOF
minvert -i $tmpdir/ascii.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
1 0 0
0 0.8660254 -0.5
0 0.5 0.8660254
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  5: invert general matrix (real)
# ------------------------------------------------------------------------
test_num=5
descr="invert general matrix (real)"
cat <<EOF > $tmpdir/ascii.$$
1 2 3
1 3 5
2 2 4
EOF
minvert -i $tmpdir/ascii.$$ -o $tmpdir/out.$$
mmul -i1 $tmpdir/ascii.$$ -i2 $tmpdir/out.$$ -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
1 0 0
0 1 0
0 0 1
EOF
report $test_num "$tmpdir/result.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  6: invert general matrix (complex)
# ------------------------------------------------------------------------
test_num=6
descr="invert general matrix (complex)"
cat <<EOF > $tmpdir/ascii.$$
(1,0) (2,0) (3,-2)
(1,0) (3,1) (5,0)
(2,0) (2,1) (4,5)
EOF
minvert -i $tmpdir/ascii.$$ -o $tmpdir/out.$$
mmul -i1 $tmpdir/ascii.$$ -i2 $tmpdir/out.$$ -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
(1,0) (0,0) (0,0)
(0,0) (1,0) (0,0)
(0,0) (0,0) (1,0)
EOF
report $test_num "$tmpdir/result.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

exit $status

