 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for mreplicate
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lmreplicate
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lmreplicate - replicate a given matrix as submatrices of a larger matrix
* 
*       Purpose: lmreplicate is used to replicate an input matrix in
*                a rectagular array, forming a larger output matrix.
*                The input matrix thus appears as submatrices of the
*                output matrix.
*
*         Input: in_obj - input object
*                r - replication count along row direction
*                c - replication count along column direction
*
*        Output: out_obj - output matrix
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: Scott Wilson
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lmreplicate(
kobject in_obj,
int r,
int c,
kobject out_obj)
/* -library_def_end */

/* -library_code */
{
        char *lib = "kmatrix", *rtn = "lmreplicate";
        klist *objlist=NULL;
        int w,h,d,t,e;
        int nplanes;
        int type,ttype;
        int wc,hc,dc,tc,ec;
        double *A=NULL;
        kdcomplex *AZ=NULL;

        /* Make sure we have a valid input and output objects */
        if (in_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus input object");
            return(FALSE);
          }
        if (out_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus output object");
            return(FALSE);
          }

        /* Reference the input object to avoid side effects, then add the
           reference to the list of goodies to be automatically free'd on
           error. */
        KCALL((in_obj = kpds_reference_object(in_obj)));
        objlist = klist_add(objlist,in_obj,"KOBJECT");

        /* See if the data type of the input object is real or complex */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_DATA_TYPE,&type));
        if (type == KCOMPLEX || type == KDCOMPLEX) ttype = KDCOMPLEX;
        else ttype = KDOUBLE;

        /* Constrain the input data to double or double complex for read */
        KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_DATA_TYPE, ttype));

        /* See how big the data is */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_SIZE,&wc,&hc,&dc,&tc,&ec));

        /* Set up to process input by planes */
        KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_REGION_SIZE,wc,hc,1,1,1));
        nplanes = dc*tc*ec;

        /* Set the output object sizes and data types */
        if (!kpds_query_value(out_obj)) KCALL(kpds_create_value(out_obj));
        KCALL(kpds_set_attributes(out_obj,
                             KPDS_VALUE_SIZE,c*wc,r*hc,dc,tc,ec,
                             KPDS_VALUE_DATA_TYPE,type,NULL));
        KCALL((out_obj = kpds_reference_object(out_obj)));
        objlist = klist_add(objlist,out_obj,"KOBJECT");

        /* Set the presentation data type to match that used internally */
        KCALL(kpds_set_attributes(out_obj,
                             KPDS_VALUE_DATA_TYPE,ttype,NULL));

        /* Set the output region to the dimensions of a single plane
           of the input object. We'll spit out multiple copies later. */
        KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_REGION_SIZE,wc,hc,1,1,1));

        /* Allocate plane buffer */
        if (ttype == KDCOMPLEX)
          {
            KCALL(!((AZ=(kdcomplex *)kmalloc(wc*hc*sizeof(kdcomplex)))== NULL));
            objlist = klist_add(objlist,AZ,"KMALLOC");
          }
        else
          {
            KCALL(!((A=(double *)kmalloc(wc*hc*sizeof(double)))== NULL));
            objlist = klist_add(objlist,A,"KMALLOC");
          }

        for (e=0; e<ec; e++)
          {
            for (t=0; t<tc; t++)
              {
                for (d=0; d<dc; d++)
                  {
                    /* Get a plane from the input object */
                    if (ttype == KDCOMPLEX)
                      AZ=(kdcomplex *)kpds_get_data(in_obj,KPDS_VALUE_REGION,(kaddr)AZ);
                    else
                      A=(double *)kpds_get_data(in_obj,KPDS_VALUE_REGION,(kaddr)A);
                    /* Copy it into the output object as replicas. */
                    for (w=0; w<c; w++)
                      {
                        for (h=0; h<r; h++)
                          {
                            kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,wc*w,hc*h,d,t,e);
                            if (ttype == KDCOMPLEX)
                              {
                                KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)AZ));
                              }
                                else
                              {
                                KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)A));
                              }
                          }
                      }
                  }
              }
          }

        (void)klist_free(objlist, (kfunc_void)lkcall_free);
	return TRUE;
}
/* -library_code_end */
