 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for mrcsum
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lmrcsum
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lmrcsum - compute row and column sums for a matrix
* 
*       Purpose: lmrcsum conputes the row and column sums for a matrix
*                object. If the rowsum object pointer is NULL, then the
*                row sums are not computed, and likewise for the colsum
*                object pointer.
*
*         Input: kobject in_obj - input matrix object
*               integer scale_type - 1 for scaling by unity,
*                                    2 for scaling by 1/N,
*                                    3 for scaling by 1/(N-1),
*                                    any other value is treated as scaling by
*                                    unity.
*
*        Output: kobject rowsum_obj - output object to receive the
*                                     row sum vectors (NULL if not wanted).
*                kobject colsum_obj - output object to receive the
*                                     column sum vectors (NULL if not wanted).
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*    Written By: Scott Wilson
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lmrcsum(
kobject in_obj,
int scale_type,
kobject rowsum_obj,
kobject colsum_obj)
/* -library_def_end */

/* -library_code */
{
        char *lib = "kmatrix", *rtn = "lmrcsum";
        double *A=NULL,*S=NULL;
        kdcomplex *AZ=NULL,*SZ=NULL;
        double acc;
        kdcomplex accZ;
        int i,j,n,nplanes;
        int type, otype;
        int wc,hc,dc,tc,ec;
        int len;
        int do_scale;
        double scale;
        klist *objlist=NULL;

        if (in_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus input object");
            return(FALSE);
          }

        /* Reference the input object to avoid side effects, then add the
           reference to the list of goodies to be autmatically free'd on
           error. */
        KCALL((in_obj = kpds_reference_object(in_obj)));
        objlist = klist_add(objlist,in_obj,"KOBJECT");

        /* See if the data type of the input object is real or complex */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_DATA_TYPE,&type));
        if (type == KCOMPLEX || type == KDCOMPLEX) otype = KDCOMPLEX;
        else otype = KDOUBLE;

        /* Constrain the input data to double real or double complex for read */
        KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_DATA_TYPE, otype));
 
        /* See how big the data is */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_SIZE,&wc,&hc,&dc,&tc,&ec));
        /* Set up to process input by planes */
        KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_REGION_SIZE,wc,hc,1,1,1));
        nplanes = dc*tc*ec;
        len = kmax(wc,hc);

        if (scale_type <= 1 || scale_type > 3) do_scale = 0;
        else do_scale = scale_type;

        /* Allocate buffers */
        if (otype == KDOUBLE)
          {
            KCALL(!((A=(double *)kmalloc(hc*wc*sizeof(double))) == NULL));
            objlist = klist_add(objlist,A,"KMALLOC");
            KCALL(!((S=(double *)kmalloc(len*sizeof(double))) == NULL));
            objlist = klist_add(objlist,S,"KMALLOC");
          }
        else
          {
            KCALL(!((AZ=(kdcomplex *)kmalloc(hc*wc*sizeof(kdcomplex)))==NULL));
            objlist = klist_add(objlist,AZ,"KMALLOC");
            KCALL(!((SZ=(kdcomplex *)kmalloc(len*sizeof(kdcomplex)))==NULL));
            objlist = klist_add(objlist,SZ,"KMALLOC");
          }

        if (rowsum_obj != KOBJECT_INVALID)
          {
            /* Set output object size and data type */
            if (!kpds_query_value(rowsum_obj)) KCALL(kpds_create_value(rowsum_obj));
            KCALL(kpds_set_attributes(rowsum_obj,
                                 KPDS_VALUE_SIZE,1,hc,dc,tc,ec,
                                 KPDS_VALUE_DATA_TYPE,otype,NULL));
            KCALL((rowsum_obj = kpds_reference_object(rowsum_obj)));
            objlist = klist_add(objlist,rowsum_obj,"KOBJECT");
            KCALL(kpds_set_attribute(rowsum_obj,KPDS_VALUE_REGION_SIZE,
                                            1,hc,1,1,1));
          }
        if (colsum_obj != KOBJECT_INVALID)
          {
            /* Set output object size and data type */
            if (!kpds_query_value(colsum_obj)) KCALL(kpds_create_value(colsum_obj));
            KCALL(kpds_set_attributes(colsum_obj,
                                 KPDS_VALUE_SIZE,wc,1,dc,tc,ec,
                                 KPDS_VALUE_DATA_TYPE,otype,NULL));
            KCALL((colsum_obj = kpds_reference_object(colsum_obj)));
            objlist = klist_add(objlist,colsum_obj,"KOBJECT");
            KCALL(kpds_set_attribute(colsum_obj,KPDS_VALUE_REGION_SIZE,
                                            wc,1,1,1,1));
          } 

        for (n=0; n<nplanes; n++)
          {
            /* Get a plane from the input object */
            if (otype == KDOUBLE)
              A = (double *)kpds_get_data(in_obj,KPDS_VALUE_REGION,(kaddr)A);
            else
              AZ=(kdcomplex *)kpds_get_data(in_obj,KPDS_VALUE_REGION,(kaddr)AZ);

            if (rowsum_obj != KOBJECT_INVALID)
              {
                switch(do_scale)
                  {
                    case 2: scale = wc;
                            break;
                    case 3: scale = wc-1;
                            break;
                    default: scale = 1;
                  }

                /* Form row sum vector */
                if (otype == KDOUBLE)
                  {
                    for (j=0; j<hc; j++)
                      {
                        acc = 0.0;
                        for (i=0; i<wc; i++)
                          {
                            acc += A[j*wc+i];
                          }
                        S[j] = acc;
                      }
                    if (do_scale) for (j=0; j<hc; j++) S[j] /= scale;
                    KCALL(kpds_put_data(rowsum_obj,KPDS_VALUE_REGION,(kaddr)S));
                  }
                else /* Complex case */
                  {
                    for (j=0; j<hc; j++)
                      {
                        accZ.r = 0.0;
                        accZ.i = 0.0;
                        for (i=0; i<wc; i++)
                          {
                            accZ = kdcadd(AZ[j*wc+i],accZ);
                          }
                        SZ[j] = accZ;
                      }
                    if (do_scale) 
                      {
                        for (j=0; j<hc; j++)
                          {
                            SZ[j].r /= scale;
                            SZ[j].i /= scale;
                          }
                      }
                    KCALL(kpds_put_data(rowsum_obj,KPDS_VALUE_REGION,(kaddr)SZ));
                  }
              }

            if (colsum_obj != KOBJECT_INVALID)
              {
                switch(do_scale)
                  {
                    case 2: scale = hc;
                            break;
                    case 3: scale = hc-1;
                            break;
                    default: scale = 1;
                  }

                /* Form col sum vector */
                if (otype == KDOUBLE)
                  {
                    for (i=0; i<wc; i++)
                      {
                        acc = 0.0;
                        for (j=0; j<hc; j++)
                          {
                            acc += A[j*wc+i];
                          }
                        S[i] = acc;
                      }
                    if (do_scale) for (j=0; j<wc; j++) S[j] /= scale;
                    KCALL(kpds_put_data(colsum_obj,KPDS_VALUE_REGION,(kaddr)S));
                  }
                else /* Complex case */
                  {
                    for (i=0; i<wc; i++)
                      {
                        accZ.r = 0.0;
                        accZ.i = 0.0;
                        for (j=0; j<hc; j++)
                          {
                            accZ = kdcadd(AZ[j*wc+i],accZ);
                          }
                        SZ[i] = accZ;
                      }
                    if (do_scale) 
                      {
                        for (j=0; j<wc; j++)
                          {
                            SZ[j].r /= scale;
                            SZ[j].i /= scale;
                          }
                      }
                    KCALL(kpds_put_data(colsum_obj,KPDS_VALUE_REGION,(kaddr)SZ));
                  }
              }
          }

        (void)klist_free(objlist, (kfunc_void)lkcall_free);

	return TRUE;
}
/* -library_code_end */
