 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for mrcsum
   >>>> 
   >>>>    Written By: Scott Wilson
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _mrcsum_h_
#define _mrcsum_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <matrix.h>

/* -include_includes */
#include <kmatrix/kmatrix.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$MATRIX/objects/kroutine/mrcsum/uis/mrcsum.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input matrix object (required infile)
 */
char	*i_file;	/* Input matrix object FILENAME */
int	 i_flag;	/* Input matrix object FLAG */

/*
 * scale by 1, 1/N or 1/(N-1) (Optional flag toggle)
 *	1 (Do not scale the output data)
 *	2 (Scale output data by 1/N)
 *	3 (Scale output data by 1/(N-1)),
 */
int	 scale_toggle;		/* scale by 1, 1/N or 1/(N-1) FLAG TOGGLE */
int	 scale_flag;		/* scale by 1, 1/N or 1/(N-1) FLAG */

/*
 *  Row sum output object (optional outfile)
 */
char	*or_file;	/* Row sum output object FILENAME */
int	 or_flag;	/* Row sum output object FLAG */

/*
 *  Column sum output object (optional outfile)
 */
char	*oc_file;	/* Column sum output object FILENAME */
int	 oc_flag;	/* Column sum output object FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void mrcsum_get_args PROTO((kform *));
void mrcsum_usage_additions PROTO((void));
void mrcsum_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
