 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for mmul
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "mmul.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Matrix Multiply (C=AB)
|
|       Purpose: main program for mmul
|
|         Input:
|		char *clui_info->i1_file; {Input matrix #1 (A)}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->i2_file; {Input matrix #2 (B)}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->o_file; {Output matrix (C)}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in1_obj = NULL;
kobject in2_obj = NULL;
kobject out_obj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MATRIX");
	kexit_handler(mmul_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MATRIX", "mmul",
		mmul_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	mmul_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ((in1_obj = kpds_open_input_object(clui_info->i1_file)) 
		== KOBJECT_INVALID)
        {
           kerror("mmul","main", "Cannot open input object #1.");
           kexit(KEXIT_FAILURE);
        }
	if ((in2_obj = kpds_open_input_object(clui_info->i2_file)) 
		== KOBJECT_INVALID)
        {
           kerror("mmul","main", "Cannot open input object #2.");
           kexit(KEXIT_FAILURE);
        }
       if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
	    == KOBJECT_INVALID)
         {
           kerror("mmul","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
         }
       if (!kpds_copy_object_attr(in1_obj, out_obj))
         {
           kerror("mmul","main", 
             "Unable to copy attributes from input #1 to output object.");
           kexit(KEXIT_FAILURE);
         }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lmmul(in1_obj,in2_obj,out_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output objects and write */
        if (!kpds_set_attribute(out_obj,KPDS_HISTORY,kpds_history_string()))
          {
            kerror("mmul", "main","Unable to set history on output object");
            kexit(KEXIT_FAILURE);
          }
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: mmul_usage_additions
| 
|       Purpose: Prints usage additions in mmul_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mmul
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mmul_usage_additions(void)
{
	kfprintf(kstderr, "\tMatrix Multiply (C=AB)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: mmul_free_args
| 
|       Purpose: Frees CLUI struct allocated in mmul_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mmul
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
mmul_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
