 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for mgdiag
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "mgdiag.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generate a Diagonal Matrix
|
|       Purpose: main program for mgdiag
|
|         Input:
|		int   clui_info->type_cycle; {Output data type}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		double clui_info->cr_double; {Real part of constant diagonal value}
|		int    clui_info->cr_flag; {TRUE if -cr specified}
|
|		double clui_info->ci_double; {Imaginary part of constant diagonal value}
|		int    clui_info->ci_flag; {TRUE if -ci specified}
|
|		char *clui_info->i_file; {Vector of diagonal elements}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		M.I. group:
|		    int clui_info->r_int; {Number of rows}
|		    int clui_info->r_flag; {TRUE if -r specified}
|
|		    int clui_info->c_int; {Number of columns}
|		    int clui_info->c_flag; {TRUE if -c specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject vec_obj=NULL,out_obj=NULL;
int type;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MATRIX");
	kexit_handler(mgdiag_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MATRIX", "mgdiag",
		mgdiag_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	mgdiag_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
                == KOBJECT_INVALID)
          {
            kerror("mgdiag","main", "Cannot open output object.");
            kexit(KEXIT_FAILURE);
          }

        if (clui_info->i_flag)
          {
	    if ((vec_obj = kpds_open_input_object(clui_info->i_file)) 
		    == KOBJECT_INVALID)
              {
                kerror("mgdiag","main", "Cannot open input object.");
                kexit(KEXIT_FAILURE);
              }
            if (!kpds_copy_object_attr(vec_obj, out_obj))
	      {
                kerror("mgdiag","main", 
		  "Unable to copy attributes from input to output object.");
                kexit(KEXIT_FAILURE);
              }
          }

        switch(clui_info->type_cycle)
          {
            case 1: type=KFLOAT;
                    break;
            case 2: type=KCOMPLEX;
                    break;
            case 3: type=KDOUBLE;
                    break;
            case 4: type=KDCOMPLEX;
                    break;
            default: 
                    kerror("mgdiag","main",
                       "Unsupported data type.");
                    kexit(KEXIT_FAILURE);
                    break;
          }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lmgdiag(vec_obj,
                     clui_info->r_int,
                     clui_info->c_int,
                     clui_info->cr_double,
                     clui_info->ci_double,
                     type,
                     out_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: mgdiag_usage_additions
| 
|       Purpose: Prints usage additions in mgdiag_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mgdiag
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mgdiag_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerate a Diagonal Matrix\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: mgdiag_free_args
| 
|       Purpose: Frees CLUI struct allocated in mgdiag_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mgdiag
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
mgdiag_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->type_label);
	kfree(clui_info->o_file);
	kfree(clui_info->i_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
