 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for mextract_diag
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "mextract_diag.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Extract Matrix Diagonal, Row, or Column
|
|       Purpose: main program for mextract_diag
|
|         Input:
|		char *clui_info->i_file; {Input matrix}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Output vector}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->row_flag; {TRUE if -row specified}
|
|		    int clui_info->col_flag; {TRUE if -col specified}
|
|		    int clui_info->diag_flag; {TRUE if -diag specified}
|
|		int clui_info->num_int; {Row or column number}
|		int clui_info->num_flag; {TRUE if -num specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in_obj = NULL;
kobject out_obj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MATRIX");
	kexit_handler(mextract_diag_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MATRIX", "mextract_diag",
		mextract_diag_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	mextract_diag_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj = kpds_open_input_object(clui_info->i_file))
                == KOBJECT_INVALID)
        {
           kerror("mextract_diag","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

       if ((out_obj = kpds_open_output_object(clui_info->o_file))
                 == KOBJECT_INVALID)
         {
            kerror("mextract_diag","main", "Cannot open output object.");
            kexit(KEXIT_FAILURE);
         }
       if (!kpds_copy_object_attr(in_obj, out_obj))
         {
           kerror("mextract_diag","main",
           "Unable to copy attributes from input to output object.");
            kexit(KEXIT_FAILURE);
         }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lmextract_diag(in_obj,
                            clui_info->row_flag,
                            clui_info->col_flag,
                            clui_info->diag_flag,
                            clui_info->num_int,
                            out_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output objects and write */
        if (!kpds_set_attribute(out_obj,KPDS_HISTORY,kpds_history_string()))
          {
            kerror("mextract_diag", "main","Unable to set history on output object");
            kexit(KEXIT_FAILURE);
          }
        kpds_close_object(out_obj);
        kpds_close_object(in_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: mextract_diag_usage_additions
| 
|       Purpose: Prints usage additions in mextract_diag_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mextract_diag
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mextract_diag_usage_additions(void)
{
	kfprintf(kstderr, "\tExtract Matrix Diagonal, Row, or Column\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: mextract_diag_free_args
| 
|       Purpose: Frees CLUI struct allocated in mextract_diag_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mextract_diag
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
mextract_diag_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
