 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for itexture
   >>>> 
   >>>>    Written By: Scott Wilson (stolen from K2.0.1 RETRO toolbox)
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 11, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _itexture_h_
#define _itexture_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <image.h>

/* -include_includes */
#include <kimage_proc/kimage_proc.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$IMAGE/objects/kroutine/itexture/uis/itexture.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input object (required infile)
 */
char	*i_file;	/* input object FILENAME */
int	 i_flag;	/* input object FLAG */

/*
 *  output object (required outfile)
 */
char	*o_file;	/* output object FILENAME */
int	 o_flag;	/* output object FLAG */

/*----- optional   group ----*/
/*
 *  If set, apply L5L5 texture kernel (optional flag)
 */
int	 L5L5_flag;  	/* If set, apply L5L5 texture kernel FLAG */

/*
 *  If set, apply E5L5 texture kernel (optional flag)
 */
int	 E5L5_flag;  	/* If set, apply E5L5 texture kernel FLAG */

/*
 *  If set, apply S5L5 texture kernel (optional flag)
 */
int	 S5L5_flag;  	/* If set, apply S5L5 texture kernel FLAG */

/*
 *  If set, apply W5L5 texture kernel (optional flag)
 */
int	 W5L5_flag;  	/* If set, apply W5L5 texture kernel FLAG */

/*
 *  If set, apply R5L5 texture kernel (optional flag)
 */
int	 R5L5_flag;  	/* If set, apply R5L5 texture kernel FLAG */

/*
 *  If set, apply L5E5 texture kernel (optional flag)
 */
int	 L5E5_flag;  	/* If set, apply L5E5 texture kernel FLAG */

/*
 *  If set, apply E5E5 texture kernel (optional flag)
 */
int	 E5E5_flag;  	/* If set, apply E5E5 texture kernel FLAG */

/*
 *  If set, apply S5E5 texture kernel (optional flag)
 */
int	 S5E5_flag;  	/* If set, apply S5E5 texture kernel FLAG */

/*
 *  If set, apply W5E5 texture kernel (optional flag)
 */
int	 W5E5_flag;  	/* If set, apply W5E5 texture kernel FLAG */

/*
 *  If set, apply R5E5 texture kernel (optional flag)
 */
int	 R5E5_flag;  	/* If set, apply R5E5 texture kernel FLAG */

/*
 *  If set, apply L5S5 texture kernel (optional flag)
 */
int	 L5S5_flag;  	/* If set, apply L5S5 texture kernel FLAG */

/*
 *  If set, apply E5S5 texture kernel (optional flag)
 */
int	 E5S5_flag;  	/* If set, apply E5S5 texture kernel FLAG */

/*
 *  If set, apply S5S5 texture kernel (optional flag)
 */
int	 S5S5_flag;  	/* If set, apply S5S5 texture kernel FLAG */

/*
 *  If set, apply W5S5 texture kernel (optional flag)
 */
int	 W5S5_flag;  	/* If set, apply W5S5 texture kernel FLAG */

/*
 *  If set, apply R5S5 texture kernel (optional flag)
 */
int	 R5S5_flag;  	/* If set, apply R5S5 texture kernel FLAG */

/*
 *  If set, apply L5W5 texture kernel (optional flag)
 */
int	 L5W5_flag;  	/* If set, apply L5W5 texture kernel FLAG */

/*
 *  If set, apply E5W5 texture kernel (optional flag)
 */
int	 E5W5_flag;  	/* If set, apply E5W5 texture kernel FLAG */

/*
 *  If set, apply S5W5 texture kernel (optional flag)
 */
int	 S5W5_flag;  	/* If set, apply S5W5 texture kernel FLAG */

/*
 *  If set, apply W5W5 texture kernel (optional flag)
 */
int	 W5W5_flag;  	/* If set, apply W5W5 texture kernel FLAG */

/*
 *  If set, apply R5W5 texture kernel (optional flag)
 */
int	 R5W5_flag;  	/* If set, apply R5W5 texture kernel FLAG */

/*
 *  If set, apply L5R5 texture kernel (optional flag)
 */
int	 L5R5_flag;  	/* If set, apply L5R5 texture kernel FLAG */

/*
 *  If set, apply E5R5 texture kernel (optional flag)
 */
int	 E5R5_flag;  	/* If set, apply E5R5 texture kernel FLAG */

/*
 *  If set, apply S5R5 texture kernel (optional flag)
 */
int	 S5R5_flag;  	/* If set, apply S5R5 texture kernel FLAG */

/*
 *  If set, apply W5R5 texture kernel (optional flag)
 */
int	 W5R5_flag;  	/* If set, apply W5R5 texture kernel FLAG */

/*
 *  If set, apply R5R5 texture kernel (optional flag)
 */
int	 R5R5_flag;  	/* If set, apply R5R5 texture kernel FLAG */

/*-- optional   group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void itexture_get_args PROTO((kform *));
void itexture_usage_additions PROTO((void));
void itexture_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
