 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for imedian
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "imedian.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Median Filter for Image Data
|
|       Purpose: main program for imedian
|
|         Input:
|		char *clui_info->i_file; {Input image}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Output image}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->wsize_int; {Width of window}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int clui_info->hsize_int; {Heigth of window}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int clui_info->reps_int; {number of repetitions of filter to perform}
|		int clui_info->reps_flag; {TRUE if -reps specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson (stolen from K1.5 vhmed and vqmed, which were
written by Ramiro Jordan and Marcelo Teran)
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj = NULL;
        kobject out_obj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "IMAGE");
	kexit_handler(imedian_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "IMAGE", "imedian",
		imedian_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	imedian_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj = kpds_open_input_object(clui_info->i_file))
                == KOBJECT_INVALID)
        {
           kerror("imedian","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }
 
        if ((out_obj = kpds_open_output_object(clui_info->o_file))
                == KOBJECT_INVALID)
        {
           kerror("imedian","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }
 
        if (!kpds_copy_object_attr(in_obj, out_obj))
        {
           kerror("imedian","main",
                  "Unable to copy attributes from input to output object.");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!limedian(in_obj,
                      clui_info->wsize_int,
                      clui_info->hsize_int,
                      clui_info->reps_int,
                      out_obj))
                 kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
        {
           kerror("imedian", "main",
                  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
        }
 
        kpds_close_object(in_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: imedian_usage_additions
| 
|       Purpose: Prints usage additions in imedian_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname imedian
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void imedian_usage_additions(void)
{
	kfprintf(kstderr, "\tMedian Filter for Image Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: imedian_free_args
| 
|       Purpose: Frees CLUI struct allocated in imedian_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname imedian
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
imedian_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
