 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for igeowarp
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "igeowarp.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Perform Direct Bilinear Geometric Warping
|
|       Purpose: main program for igeowarp
|
|         Input:
|		char *clui_info->i_file; {Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    char *clui_info->wcoeffs_file; {W warp function coeffs object}
|		    int   clui_info->wcoeffs_flag; {TRUE if -wcoeffs specified}
|
|		    M.I. group:
|			double clui_info->a00_double; {A00 (W warp function, constant term)}
|			int    clui_info->a00_flag; {TRUE if -a00 specified}
|
|			double clui_info->a01_double; {A01 (W warp function, w term)}
|			int    clui_info->a01_flag; {TRUE if -a01 specified}
|
|			double clui_info->a10_double; {A10 (W warp function, h term)}
|			int    clui_info->a10_flag; {TRUE if -a10 specified}
|
|			double clui_info->a11_double; {A11 (W warp function, wh term)}
|			int    clui_info->a11_flag; {TRUE if -a11 specified}
|
|		Required M.E. group:
|		    char *clui_info->hcoeffs_file; {H warp function coeffs object}
|		    int   clui_info->hcoeffs_flag; {TRUE if -hcoeffs specified}
|
|		    M.I. group:
|			double clui_info->b00_double; {B00 (H warp function, constant term)}
|			int    clui_info->b00_flag; {TRUE if -b00 specified}
|
|			double clui_info->b01_double; {B01 (H warp function, w term)}
|			int    clui_info->b01_flag; {TRUE if -b01 specified}
|
|			double clui_info->b10_double; {B10 (H warp function, h term)}
|			int    clui_info->b10_flag; {TRUE if -b10 specified}
|
|			double clui_info->b11_double; {B11 (H warp function, wh term)}
|			int    clui_info->b11_flag; {TRUE if -b11 specified}
|
|		int clui_info->planes_flag; {TRUE if -planes specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject in_obj = NULL;
	kobject out_obj = NULL;
	kobject xc_obj = NULL;
	kobject yc_obj = NULL;
        double a00,a01,a10,a11;
        double b00,b01,b10,b11;
        double *data;
        int w,h,d,t,e;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "IMAGE");
	kexit_handler(igeowarp_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "IMAGE", "igeowarp",
		igeowarp_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	igeowarp_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ((in_obj = kpds_open_input_object(clui_info->i_file)) 
		== KOBJECT_INVALID)
        {
           kerror("khisto","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

	if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
		== KOBJECT_INVALID)
        {
           kerror("khisto","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if (!kpds_copy_object_attr(in_obj, out_obj))
	{
           kerror("khisto","main", 
		  "Unable to copy attributes from input to output object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->wcoeffs_flag != 0)
          {
	    if ((xc_obj = kpds_open_input_object(clui_info->wcoeffs_file)) 
		== KOBJECT_INVALID)
              {
                kerror("geowarp","main", "Cannot open W coeffs object.");
                kexit(KEXIT_FAILURE);
              }
            xc_obj = kpds_reference_object(xc_obj);
            kpds_set_attribute(xc_obj,KPDS_VALUE_DATA_TYPE, KDOUBLE);
            kpds_get_attribute(xc_obj,KPDS_VALUE_SIZE, &w,&h,&d,&t,&e);
            kpds_set_attribute(xc_obj,KPDS_VALUE_REGION_SIZE,w,h,d,t,e);    
            data = kpds_get_data(xc_obj,KPDS_VALUE_REGION,(kaddr)data);
            a00 = data[0]; a01 = data[1]; a10 = data[2]; a11 = data[3];
            kpds_close_object(xc_obj);
          }
        else
          {
            a00 = clui_info->a00_double;
            a01 = clui_info->a01_double;
            a10 = clui_info->a10_double;
            a11 = clui_info->a11_double;
          }

        if (clui_info->hcoeffs_flag != 0)
          {
            if ((yc_obj = kpds_open_input_object(clui_info->hcoeffs_file))
                == KOBJECT_INVALID)
              {
                kerror("igeowarp","main", "Cannot open H coeffs object.");
                kexit(KEXIT_FAILURE);
              }
            yc_obj = kpds_reference_object(yc_obj);
            kpds_set_attribute(yc_obj,KPDS_VALUE_DATA_TYPE, KDOUBLE);
            kpds_get_attribute(yc_obj,KPDS_VALUE_SIZE, &w,&h,&d,&t,&e);
            kpds_set_attribute(yc_obj,KPDS_VALUE_REGION_SIZE,w,h,d,t,e); 
            data = kpds_get_data(yc_obj,KPDS_VALUE_REGION,(kaddr)data);
            b00 = data[0]; b01 = data[1]; b10 = data[2]; b11 = data[3];
            kpds_close_object(yc_obj);
          } 
        else
          {
            b00 = clui_info->b00_double;
            b01 = clui_info->b01_double;
            b10 = clui_info->b10_double;
            b11 = clui_info->b11_double;
          }

        if (data != NULL) kfree(data);
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!ligeowarp(in_obj,
                        a00,a01,a10,a11,
                        b00,b01,b10,b11,
			clui_info->planes_flag,
                        out_obj))
                 kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
        {
           kerror("igeoowarp", "main",
                  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
        }
 
        kpds_close_object(in_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: igeowarp_usage_additions
| 
|       Purpose: Prints usage additions in igeowarp_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igeowarp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void igeowarp_usage_additions(void)
{
	kfprintf(kstderr, "\tPerform Direct Bilinear Geometric Warping\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: igeowarp_free_args
| 
|       Purpose: Frees CLUI struct allocated in igeowarp_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igeowarp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
igeowarp_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->wcoeffs_file);
	kfree(clui_info->hcoeffs_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
