 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "igauss_func.h"
/*-----------------------------------------------------------
| 
|  Routine Name: igauss_func_get_args
| 
|       Purpose: Gets command line args for igauss_func
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igauss_func
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void igauss_func_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for igauss_func is out of sync with arguments specified in igauss_func's *.pane file; please rerun ghostwriter on igauss_func.";


	/*
	 * allocate the igauss_func structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_int(pane, "wsize",
			  &(clui_info->wsize_int),
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsize",
			  &(clui_info->hsize_int),
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_list),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "wpeak",
			  &(clui_info->wpeak_int),
			  &(clui_info->wpeak_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hpeak",
			  &(clui_info->hpeak_int),
			  &(clui_info->hpeak_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "wvar",
			  &(clui_info->wvar_double),
			  &(clui_info->wvar_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "hvar",
			  &(clui_info->hvar_double),
			  &(clui_info->hvar_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "coeff",
			  &(clui_info->coeff_double),
			  &(clui_info->coeff_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "peakval",
			  &(clui_info->peakval_double),
			  &(clui_info->peakval_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "norm",
			  &(clui_info->norm_logic),
			  &(clui_info->norm_flag))))
	{
	    kerror(NULL, "igauss_func_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



