 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for igamut
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "igamut.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Compress Color Multiband Image to Single Band with Map
|
|       Purpose: main program for igamut
|
|         Input:
|		char *clui_info->i_file; {Multiband input image (elements dimension > 1)}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->n_int; {Number of colors to compress down to}
|		int clui_info->n_flag; {TRUE if -n specified}
|
|		int clui_info->p_int; {Number of bits of precision to use during quantization}
|		int clui_info->p_flag; {TRUE if -p specified}
|
|		float clui_info->r_float; {Fraction of color splits based on subspace 2-norm}
|		int   clui_info->r_flag; {TRUE if -r specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject src,dest;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "IMAGE");
	kexit_handler(igamut_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "IMAGE", "igamut",
		igamut_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	igamut_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
if ((src = kpds_open_input_object(clui_info->i_file)) == KOBJECT_INVALID)
  {
    kerror(NULL,"igamut", "Cannot open source object.");
    kexit(KEXIT_FAILURE);
  }

if ((dest = kpds_open_output_object(clui_info->o_file)) == KOBJECT_INVALID)
  {
    kerror(NULL,"igamut", "Cannot open destination object.");
    kpds_close_object(src);
    kexit(KEXIT_FAILURE);
  }

if (!kpds_copy_object(src, dest))
  {
    kerror(NULL,"igamut", "kpds_copy_object failed.");
    kpds_close_object(src);
    kpds_close_object(dest);
    kexit(KEXIT_FAILURE);
  }
/* -main_before_lib_call_end */

/* -main_library_call */
if (!kcolor_gamut_object(src,
             clui_info->n_int,
             clui_info->p_int,
             clui_info->r_float,
             dest))
  {
     kpds_close_object(src);
     kexit(KEXIT_FAILURE);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
/* add history to the output object */
if (!kpds_set_attribute(dest, KPDS_HISTORY, kpds_history_string()))
{
   kerror(NULL, "igamut", 
	  "Unable to set history on the destination object");
   kexit(KEXIT_FAILURE);
}

kpds_close_object(src);
kpds_close_object(dest);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: igamut_usage_additions
| 
|       Purpose: Prints usage additions in igamut_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igamut
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void igamut_usage_additions(void)
{
	kfprintf(kstderr, "\tCompress Color Multiband Image to Single Band with Map\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: igamut_free_args
| 
|       Purpose: Frees CLUI struct allocated in igamut_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igamut
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
igamut_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
