
/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#ifndef __shader_h
#define __shader_h

/* surface rendering modes */
#define NSHADERS 8
#define VOLUME_SHADER_BASE 5

#define KSHADER_NO_LIGHT 0
#define KSHADER_FLAT 1
#define KSHADER_GOUROUD 2
#define KSHADER_PHONG 3
#define KSHADER_INHERIT 4


/**
  * volume rendering modes:
  * these correspond to the list of functions in volrender.c
  *
  * VOXEL_DOT will add a zbucket entry at each voxel vertex.  this
  * is the quickest and dirtiest method, and may be useful for
  * composing a useful colormap.
  *
  * the SPLAT_HOMOGENOUS method will compute the 2d bounding box of
  * the voxel footprint on the screen, then for every pixel within this
  * bounding box, add a zbucket entry (for buffered transparency) of
  * constant color and opacity.  this method is slower than VOXEL_DOT,
  * and produces "blocky" but better images.
  *
  * SPLAT_HOMOGENOUS_GAUSS does the same thing as SPLAT_HOMOGENOUS, but
  * uses a 2d gaussian filter to attenuate the voxel opaticy across the
  * footprint using a spherical (assuming a square footprint) filter.
  * this method is slightly slower than SPLAT_HOMOGENOUS but produces
  * smoother images.  there are two parameters in the volrender.c file
  * which control this renderer which are currently compiled in.  one
  * parameter scales the width of the computed voxel footprint (making it
  * larger or smaller), while the other controls the spread of voxel
  * opacity within the footprint.  refer to the code for more information.
  * 
**/
#define KSHADER_VOXEL_DOT 5
#define KSHADER_SPLAT_HOMOGENEOUS 6
#define KSHADER_SPLAT_HOMOGENEOUS_GAUSS 7

/**
  * the following strings reflect the english version of the
  * shader used for reporting something intelligible to the user
  * via the GUI.
**/

static char *shader_strings[NSHADERS] =
{
    "No light",
    "Flat",
    "Gouroud",
    "Phong",
    "Inherit",
    "Voxel-Dot",
    "Voxel-Splat-Homogeneous",
    "Voxel-Splat-Gaussian"
};

/**
  *
**/

#include "rmonster_objs.h"

int vertex_shader PROTO((vertex_3d *verts, vertex_3d *normals, int nverts, \
			 surface_colors_rgba *in_fcolors, \
			 surface_colors_rgba **out_fcolors, \
			 surface_attribs *sa,\
			 float *global_alpha, \
			 int shader));

int tstrip_facet_shader PROTO((vertex_3d *verts, vertex_3d *normals, int nverts, \
			       surface_colors_rgba *in_fcolors, \
			       surface_colors_rgba **out_fcolors, \
			       surface_attribs *sa,\
			       float *global_alpha, \
			       int shader));

int vertex_per_face_normal_shader PROTO((vertex_3d *verts, vertex_3d *normals, int nverts, \
					 surface_colors_rgba *in_fcolors, \
					 surface_colors_rgba **out_fcolors, \
					 surface_attribs *sa,\
					 float *global_alpha, \
					 int shader));

int volume_vertex_shader PROTO((vertex_3d *verts, vertex_3d *normals, \
				int nverts, \
				surface_colors_rgba *in_fcolors, \
				surface_colors_rgba **out_fcolors, \
				surface_attribs *sa,\
				float *global_alpha, \
				int shader));

void nvertex_scaled_shade PROTO((surface_colors_rgba *out, \
				 float *scale, \
				 surface_colors_rgba *in, \
				 int nverts));

void nvertex_scaled_shade_per_face_norms PROTO((surface_colors_rgba *out, \
				 float *scale, \
				 surface_colors_rgba *in, \
				 int nverts));

void nvertex_scaled_shade_spec PROTO((surface_colors_rgba *out,float *scalar, \
				      surface_colors_rgba *in, \
				      int n,float *blend_coeff, \
				      vertex_3d *blend_color ));

void blend_vertex_shade PROTO((surface_colors_rgba *d,float *blend_coeff, \
			       vertex_3d *blend_color,int nverts));

#endif
