
/*********************************************************************

Copyright (C) 1995, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus it is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory
                Berkeley, California 

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

/*
 * Khoros: $Id$
 */
 
#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Title
   >>>>
   >>>>  this file contains arch specific code.
   >>>>
   >>>>
   >>>>
   >>>>
   >>>>  Static:
   >>>>             _static_routines()
   >>>>  Public:
   >>>>             public_routines()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "rmonster.h"
#include "imaging.h"

static char HARDWARE_COOKIE[] =

#ifdef sgi
{"SGI-SUNDRY-NONSTANDARD"};
#elif __sparc
{"SUN_OVL"};
#else 
{"none"};
#endif

static char VENDOR_NAMES[] =

#ifdef sgi
  {"Silicon Graphics"};
#elif __sparc
  {"Sun Microsystems"};
#else 
{"none"};
#endif

static char NATIVE_RENDERER_NAMES[] =
#ifdef sgi
{"GL"};
#elif __sparc
{"XGL"};
#else 
{"none"};
#endif


int
find_gfx_hardware (char **exts,
		   int nexts,
		   char *vendor,
		   char *native_renderer_name)
{
    /**
      * the purpose of this routine is to determine if there is any
      * support for accelerated graphics on the $DISPLAY.  how this
      * is determined varies from vendor to vendor.  for example, in
      * the case of code compiled for the SGI, we take the following
      * steps:
      *  1. check the XDisplayVendor to verify that $DISPLAY is set
      *     to point to an SGI-device, and
      *  2. possibly check for some minimum amount of hardware before
      *     allowing for a hardware renderer.
    **/

    int i,status;

    /** we could just query for a particular extension, but until
      i get a good handle on this, i'll continue to scan through
      a list...**/

    status = FALSE;
    if (kstrncmp(vendor,VENDOR_NAMES,kstrlen(VENDOR_NAMES)) == 0)
    {
        /* if we got here, then at least the Vendor of $DISPLAY is correct..*/
#ifdef sgi
	status = FALSE;
#ifdef IN_NEXT_RELEASE

        /**
	  * for GL, the min hardware configuration that we will allow
	  * for is single-buffered RGB.
	**/
	status = gl_min_config(); /* in gl.c */
	if (status)
	{
	    kstrcpy(native_renderer_name,NATIVE_RENDERER_NAMES);
	    status = TRUE;
	}
	else
	    status = FALSE;
#endif
	
#elif __sparc
        /* check for what? */

	status = TRUE;
	kstrcpy(native_renderer_name,NATIVE_RENDERER_NAMES);
	
	status = FALSE;  /* xgl port not ready yet.  22 jan 95, wes */
	
#endif
    }

#if 0
    status = FALSE;
    for (i=0;i<nexts;i++)
    {
	if (strcmp(HARDWARE_COOKIE,exts[i]) == 0)
	    status = TRUE;
    }
#endif

    return(status);  /* don't know how to do anything else right now. */

}
