 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane Objects
   >>>> 
   >>>>  Private: 
   >>>> 	Objects_current_object
   >>>> 	Objects_object_shader
   >>>> 	Objects_post_obj
   >>>> 	Objects_obj_red
   >>>> 	Objects_obj_green
   >>>> 	Objects_obj_blue
   >>>> 	Objects_obj_alpha
   >>>> 	Objects_obj_ambient
   >>>> 	Objects_obj_diffuse
   >>>> 	Objects_obj_spec
   >>>> 	Objects_obj_spec_exp
   >>>> 	Objects_obj_spec_metal
   >>>> 	Objects_object_info
   >>>> 	Objects_action1
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "rmonster.h"
#include "shader.h"

int return_object_names PROTO((char ***, int *));

static RenderMonster_Objects *loc_Objects=NULL;


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_current_object
| 
|       Purpose: Do routine which is called when
|                  list selection current_object is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_current_object(
     RenderMonster_Objects *Objects_info)
{
    rmonsterobj *r;
    int status;
    char *s;

    /* set s to point to first non-blank character of the object
       name - we prepend blanks to represent heirarchies. */

    for (s=Objects_info->current_object_label;*s == ' ';s++)
        ;

    status = find_rmonsterobj(s,&r);
    if (status != CHILL) /* an internal error of some type */
    {
errno = KINTERNAL;
        kerror("GEOMETRY","Objects_current_object","Rmonster can't find one of it's objects.  HELP!");
        return;
    }
    set_current_object(r);
    update_object_pane(r);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_object_shader
| 
|       Purpose: Do routine which is called when
|                  list selection object_shader is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_object_shader(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *r;
    rmonster_prim *p;
    int shader,cur_shader;
    
    r = get_current_object();
    p = r->prims; 
    shader = Objects_info->object_shader;
    cur_shader = get_object_shader(r,&cur_shader);

    /**
      * do some sanity checking: this is a problem since the
      * primitives may be non-homogeneous and different primitives
      * support different shader types.  what we'll do as a compromise
      * is to look at the first primtive in an object and assume that
      * all the primtives in the object are of the same type.  then,
      * well constrain the user's choice of shaders to that which make
      * sense for the first primtive.
      *
      * note that the shader value is set in the rmonsterobj structure,
      * not in the primitive.  the choice of shaders applies to the
      * entire object, and if the shader doesn't make sense for the
      * entire collection of object primitives, the renderer will make
      * some decision for you about which shader to use.
    **/

    if (p == NULL)
        return;
    switch (p->type)
    {
    case KGEOM_POLYLINE_DISJOINT:
    case KGEOM_POLYLINE_CONNECTED:
        if (shader != KSHADER_NO_LIGHT)
        {
            kerror("GEOMETRY",NULL,"For vector-based primtives, ONLY the no-light shader is supported.\n");
            shader = cur_shader;
        }
        
        break;

    case KGEOM_TRIANGLES_DISJOINT:
    case KGEOM_TRIANGLES_CONNECTED:
    case KGEOM_SPHERES:
    case KGEOM_CYLINDERS:
#if 0
    case KGEOM_QUADMESH_LOCATION:
    case KGEOM_POLYHEDRA_FACE:
    case KGEOM_POLYHEDRA_VERTICES:
#endif
        if ((shader != KSHADER_NO_LIGHT) &&
            (shader != KSHADER_FLAT) &&
            (shader != KSHADER_GOUROUD) &&
            (shader != KSHADER_PHONG) &&
            (shader != KSHADER_INHERIT))
        {
            kerror("GEOMETRY","","","For surface-based primtives, only NO_LIGHT,FLAT, GOUROUD, PHONG and INHERIT shaders are supported.\n");
            shader = cur_shader;
        }
        break;

    case KGEOM_DIRECTED_POINTS:
        if ((shader != KSHADER_FLAT) && (shader != KSHADER_NO_LIGHT))
        {
            kerror("GEOMETRY","","","For directed point primtivies, only NO_LIGHT and FLAT shaders are supported.\n");
            shader = cur_shader;
        }
        break;

#if 0
    case KGEOM_OCTMESH:
        if ((shader != KSHADER_VOXEL_DOT) &&
            (shader != KSHADER_SPLAT_HOMOGENEOUS) &&
            (shader != KSHADER_SPLAT_HOMOGENEOUS_GAUSS))
        {
            kerror("GEOMETRY","","","For volume primtives, only VOXEL_DOT, SPLAT_HOMOGENEOUS, or SPLAT_HOMOGENEOUS_GAUSS shaders are supported.");
            shader = cur_shader;
        }
        break;
#endif
    }
    
    set_object_shader(r,shader);

    xvf_set_attribute(Objects_info->object_shader_struct,
                   XVF_LIST_VAL,
                   shader);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_post_obj
| 
|       Purpose: Do routine which is called when
|                  logical selection post_obj is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_post_obj(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *r;
    r = get_current_object();
    set_object_display_status(r,Objects_info->post_obj);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_obj_red
| 
|       Purpose: Do routine which is called when
|                  float selection obj_red is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_obj_red(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *o;
    float r,g,b,a;
    o = get_current_object();
    get_object_rgba(o,&r,&g,&b,&a);
    set_object_rgba(o,Objects_info->obj_red,g,b,a);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_obj_green
| 
|       Purpose: Do routine which is called when
|                  float selection obj_green is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_obj_green(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *o;
    float r,g,b,a;
    o = get_current_object();
    get_object_rgba(o,&r,&g,&b,&a);
    set_object_rgba(o,r,Objects_info->obj_green,b,a);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_obj_blue
| 
|       Purpose: Do routine which is called when
|                  float selection obj_blue is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_obj_blue(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *o;
    float r,g,b,a;
    o = get_current_object();
    get_object_rgba(o,&r,&g,&b,&a);
    set_object_rgba(o,r,g,Objects_info->obj_blue,a);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_obj_alpha
| 
|       Purpose: Do routine which is called when
|                  float selection obj_alpha is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_obj_alpha(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *o;
    float r,g,b,a;
    o = get_current_object();
    get_object_rgba(o,&r,&g,&b,&a);
    set_object_rgba(o,r,g,b,Objects_info->obj_alpha);
    if (Objects_info->obj_alpha != 1.)
        o->is_transparent = TRUE;
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_obj_ambient
| 
|       Purpose: Do routine which is called when
|                  float selection obj_ambient is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_obj_ambient(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *r;
    r = get_current_object();
    set_object_amb(r,Objects_info->obj_ambient);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_obj_diffuse
| 
|       Purpose: Do routine which is called when
|                  float selection obj_diffuse is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_obj_diffuse(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *r;
    r = get_current_object();
    set_object_diff(r,Objects_info->obj_diffuse);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_obj_spec
| 
|       Purpose: Do routine which is called when
|                  float selection obj_spec is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_obj_spec(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *r;
    r = get_current_object();
    set_object_spec(r,Objects_info->obj_spec);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_obj_spec_exp
| 
|       Purpose: Do routine which is called when
|                  float selection obj_spec_exp is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_obj_spec_exp(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *r;
    r = get_current_object();
    set_object_spec_exp(r,Objects_info->obj_spec_exp);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_obj_spec_metal
| 
|       Purpose: Do routine which is called when
|                  float selection obj_spec_metal is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_obj_spec_metal(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    rmonsterobj *r;
    r = get_current_object();
    set_object_metal(r,Objects_info->obj_spec_metal);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_object_info
| 
|       Purpose: Do routine which is called when
|                  pane action button object_info is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_object_info(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Objects_action1
| 
|       Purpose: Do routine which is called when
|                  pane action button action1 is used
| 
|         Input: Objects_info - ptr to PaneInfo struct for Objects pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Objects_action1(
     RenderMonster_Objects *Objects_info)
{
	/* PUT YOUR CODE HERE ! */
    identity_current_object_matrix();
}

void
init_object_list_GUI(RenderMonster_Objects *Objects_info)
{
    char **list;
    int nobjects,i;
    rmonsterobj *r;
    RenderMonster_Objects *o;

    if (Objects_info == NULL)  /* rebuilding the GUI rather than
                                  initializing it. */
    {
        if (loc_Objects == NULL)
        {
            kerror("","init_object_list_GUI","I can't rebuild the GUI cuz it never got initialized.");
            return;
        }
        o = loc_Objects;
    }
    else
    {
        loc_Objects = Objects_info;
        o = Objects_info;
    }
    
    /* get object names from internal database, and
       build the GUI for the benefit of the user */

    /* first, cleanse the list */
    
    xvf_set_attribute(o->current_object_struct,
                      XVF_LIST_DELETEALL,NULL);

    /* grab a list of strings containing object names. */
    return_object_names(&list,&nobjects);

    /* add them all to the GUI */
#if 0
    /* the stuff inside this if 0/endif exposes a bug
       in xvforms. 7-22-94 wes */
    xvf_set_attribute(Objects_info->current_object_struct,
                      XVF_LIST_SIZE,0);
    
    for (i=0;i<nobjects;i++)
        xvf_set_attribute(Objects_info->current_object_struct,
                          XVF_LIST_ADD,
                          list[i],
                          NULL);
#endif

    xvf_set_attributes(o->current_object_struct,
                       XVF_LIST_SIZE,nobjects,
                       XVF_LIST_CONTENTS,
                       list,
                       NULL);

    /* ok, now have built the list of objects, and stashed that
       away into the list.  get the current object, and update
       all the stuff in the object pane GUI to reflect it's
       parameters. */

    r = get_current_object();
    set_current_object(r);
    
/*    update_object_pane(r); */
}

void
update_object_pane(rmonsterobj *r)
{
/*    extern RenderMonster_Objects *Objects; */
    RenderMonster_Objects *Objects_info; 
    int status,i;
    float red,green,blue,a;
    float amb,diff,spec,spec_exp,spec_metal;

    if (loc_Objects == NULL)
        return;
    
    Objects_info = loc_Objects;
    
    /* update the shader thingy */
    status = get_object_shader(r,&i);
    xvf_set_attribute(Objects_info->object_shader_struct,
                   XVF_LIST_VAL,
                   i);

    /* update the display status of the selected object */
    status = get_object_display_status(r,&i);
    xvf_set_attribute(Objects_info->post_obj_struct,
                   XVF_LOGIC_VAL,
                   i);

    /* update the object color sliders */
    status = get_object_rgba(r,&red,&green,&blue,&a);

    xvf_set_attribute(Objects_info->obj_red_struct,
                   XVF_FLOAT_VAL,
                   red);

    xvf_set_attribute(Objects_info->obj_green_struct,
                   XVF_FLOAT_VAL,
                   green);

    xvf_set_attribute(Objects_info->obj_blue_struct,
                   XVF_FLOAT_VAL,
                   blue);

    xvf_set_attribute(Objects_info->obj_alpha_struct,
                   XVF_FLOAT_VAL,
                   a);
    

    /* update the object attributes sliders */

    get_object_amb(r,&amb);
    get_object_diff(r,&diff);
    get_object_spec(r,&spec);
    get_object_spec_exp(r,&spec_exp);
    get_object_metal(r,&spec_metal);

    
    xvf_set_attribute(Objects_info->obj_ambient_struct,
                   XVF_FLOAT_VAL,
                   amb);
    
    xvf_set_attribute(Objects_info->obj_diffuse_struct,
                   XVF_FLOAT_VAL,
                   diff);
    
    xvf_set_attribute(Objects_info->obj_spec_struct,
                   XVF_FLOAT_VAL,
                   spec);
    
    xvf_set_attribute(Objects_info->obj_spec_exp_struct,
                   XVF_FLOAT_VAL,
                   spec_exp);
    
    xvf_set_attribute(Objects_info->obj_spec_metal_struct,
                   XVF_FLOAT_VAL,
                   spec_metal);

    /* update the transformation pane with this object's transformation
       informaiton */
}
