 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for gapplytex
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lgapplytex
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
static int check_for_texture_coords	PROTO((kobject));
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lgapplytex - *
* 
*       Purpose: This should be a complete description that anyone
*                could understand;  it should have acceptable grammar
*                and correct spelling.
*
*         Input: in_geom - the geometry object to which the texture
*                          will be applied
*                in_texture - (presumably an image or volume) the texture
*                          object which will provide color information in
*                          the texture mapping renderer
*                in_texture_tname - name of the transport containing the
*                          texture
*
*        Output: out_geom - copy of input object with a texture attribute
*                          set
*
*       Returns: CHILL on success, WHACKED otherwise
*
*  Restrictions: dimensionality of texture coords and input texture must agree
*    Written By: wes
*          Date: Apr 13, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int
lgapplytex(kobject in_geom,
	       kobject out_geom,
	       kobject in_texture,
	       char *in_texture_tname)
/* -library_def_end */

/* -library_code */
{
    /**
      * validity checking on input consists of checking the dimensionality
      * of the input texture and comparing it to the dimensionality of
      * the texture coordinates on the input object.
      *
      * for the sake of simplicity, we will assume
      *
      * if they jibe, the texture attribute will be set in the geom
      * object.  if not, an error message will be issued notifying the
      * user of the inconsistency between the dimensionality of the
      * texture and texture coordinates.
    **/

    int texture_dims[5],*td,tdims,geom_tdims;
    int result;
    char err_string[256];
    int any_texture_coords;

    td = texture_dims;
    kpds_get_attribute(in_texture,KPDS_VALUE_SIZE,td,td+1,td+2,td+3,td+4,td+5);

    /**
      * look only at w,h,d in value segment for image sizing.  we will be
      * somewhat restrictive in permitting 2d textures only in w,h; 3d
      * textures in w,h,d.
      *
      * thus, in the 2d case, (u,v) == (0.,0) will correspond to
      * (w=0,h=0) in the image; (u=1,v=1) will correspond to
      * (w=w-1,h=h-1) in the image, and similarly for the 3d case
      *
      * note that to be counted as a 2d texture, w&h must both be
      * greater than 1.
    **/

    tdims = 0;  /* undefined. */
    
    if ((td[0] != 1) && (td[1] != 1) && (td[2] == 1))
	tdims = 2;
    else if ((td[0] != 1) && (td[1] != 1) && (td[2] != 1))
	tdims = 3;

    /**try to grab a texture coord to see if there's anything really there. **/
    
    any_texture_coords = check_for_texture_coords(in_geom);

    /** now, grab dimensionality of texture coords from the input
         geom object.  **/
    kgeom_get_attribute(in_geom,KGEOM_OBJECT,KGEOM_TEXTURE_COORD_SIZE,
			&geom_tdims);

    if (any_texture_coords == 0)
    {
	ksprintf(err_string,"The input geometry object contains NO texture coordinates.  Aborting.\n");
	kerror("GEOMETRY","lkapplytexture",err_string);
    }
    
    if (((geom_tdims == 3) && (tdims == 3)) ||
	((geom_tdims == 2) && (tdims == 2)))
    {
	/**
	  * we've found an acceptable match.
	**/

	kpds_copy_object(in_geom,out_geom);
	kgeom_set_attribute(out_geom,KGEOM_OBJECT,KGEOM_TEXTURE,
			    in_texture_tname);
	result = CHILL;
    }
    else
    {
	/* bark at user. */
	ksprintf(err_string,"There is a dimension mismatch between the input geometry and input texture.\n Input texture dims = %d, texture coordinate dims = %d.\nThese values MUST be identical.  Aborting.\n",tdims,geom_tdims);
	kerror("GEOMETRY","lkapplytexture",err_string);

	result = WHACKED;
    }
    return(result);
}

static int
check_for_texture_coords(kobject in)
{
    int found_some=0;
    int i,nprims;
    int *prim_list=NULL;
    float *tc=NULL;

    kgeom_get_attribute(in,KGEOM_OBJECT,KGEOM_NUMBER_PRIMITIVES,&nprims);
    kgeom_get_attribute(in,KGEOM_OBJECT,KGEOM_PRIMITIVE_LIST,&prim_list);

    for (i=0;i<nprims;i++)
    {
	kgeom_set_attribute(in,KGEOM_OBJECT,KGEOM_PRIMITIVE_POSITION,i);
	switch(prim_list[i])
	{
	    /* check only those object types which can have texture coords.*/

	case KGEOM_TRIANGLES_DISJOINT:
	    kgeom_get_data(in,KGEOM_TRIANGLES_DISJOINT,NULL,NULL,NULL,&tc);
	    break;
	case KGEOM_TRIANGLES_CONNECTED:
	    kgeom_get_data(in,KGEOM_TRIANGLES_CONNECTED,NULL,NULL,NULL,&tc);
	    break;
	case KGEOM_QUADMESH:
	    kgeom_get_data(in,KGEOM_QUADMESH_TEXTURE_COORD_VERTEX,&tc);
	    break;
	case KGEOM_OCTMESH:
	    kgeom_get_data(in,KGEOM_OCTMESH_TEXTURE_COORD_VERTEX,&tc);
	    break;

	    /* the following objects won't have texture coords. */
	case KGEOM_POLYLINE_DISJOINT:
	case KGEOM_POLYLINE_CONNECTED:
	case KGEOM_SPHERES:
	default:
	    break;
	}

	if (tc != NULL)
	{
	    found_some = 1;
	    break;
	}
    }
    return(found_some);
}
/* -library_code_end */
