
/*####################################################################

Copyright (C) 1994, 1995 Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is nearly 100% hand-crafted by a human being in the USA"

####################################################################*/

#include "internals.h"

int
lunion_boxes(vertex_3d *s1_min,
	     vertex_3d *s1_max,
	     vertex_3d *s2_min,
	     vertex_3d *s2_max,
	     vertex_3d *dst_min,
	     vertex_3d *dst_max)
{
    /**
      * do a "union" of the bounding boxes s1 and s2.  place
      * results in dst.  written so that dst can be the same as
      * either of s1 or s2.
    **/
    int i;
    for (i=0;i<3;i++)
    {
	dst_min->v[i] = MIN(s1_min->v[i],s2_min->v[i]);
	dst_max->v[i] = MAX(s1_max->v[i],s2_max->v[i]);
    }
    return(CHILL);
}

int
lcompute_bbox(vertex_3d *v,
	      int n,
	      vertex_3d *bmin,
	      vertex_3d *bmax)
{
    register KGEOM_VERTEX_TYPE *tv;
    register int i;
    vertex_3d min,max;

    for (i=0;i<3;i++)
    {
	min.v[i] = KGEOM_BIGNUM;
	max.v[i] = KGEOM_SMALLNUM;
    }

    /**
      * the following loop has been optimized for speed, not
      * readability.  sorry.
      *
      * the general idea is that we'll loop/stride through all
      * the x coords first, all the y coords next and finally
      * all the z coords.
    **/
    
    tv = &(v->v[0]);
    /* do x coords. */
    for (i=0;i<n;i++,tv+=3)  /* assume that a vertex_3d is composed of
				3 contiguous KGEOM_VERTEX_TYPE's, and just
				stride over them. */
    {
	if (*tv < min.v[0])
	    min.v[0] = *tv;
	if (*tv > max.v[0])
	    max.v[0] = *tv;
    }
    
    /* do y coords. */
    
    tv = &(v->v[1]);
    for (i=0;i<n;i++,tv+=3)
    {
	if (*tv < min.v[1])
	    min.v[1] = *tv;
	if (*tv > max.v[1])
	    max.v[1] = *tv;
    }
    
    /* do z coords. */
    tv = &(v->v[2]);
    for (i=0;i<n;i++,tv+=3)
    {
	if (*tv < min.v[2])
	    min.v[2] = *tv;
	if (*tv > max.v[2])
	    max.v[2] = *tv;
    }

    VCOPY(bmin,&min);
    VCOPY(bmax,&max);

    return(CHILL);
}

int
lcompute_bbox_ptrs(vertex_3d **v,
		   int n,
		   vertex_3d *bmin,
		   vertex_3d *bmax)
{
    register vertex_3d **ptv;
    register KGEOM_VERTEX_TYPE tv;
    register int i;
    vertex_3d min,max;

    for (i=0;i<3;i++)
    {
	min.v[i] = KGEOM_BIGNUM;
	max.v[i] = KGEOM_SMALLNUM;
    }

    /**
      * the following loop has been optimized for speed, not
      * readability.  sorry.
      *
      * the general idea is that we'll loop/stride through all
      * the x coords first, all the y coords next and finally
      * all the z coords.
    **/
    
    ptv = v;
    /* do x coords. */
    for (i=0;i<n;i++,ptv++)  /* assume that a vertex_3d is composed of
				3 contiguous KGEOM_VERTEX_TYPE's, and just
				stride over them. */
    {
	tv = (*ptv)->v[0];
	if (tv < min.v[0])
	    min.v[0] = tv;
	if (tv > max.v[0])
	    max.v[0] = tv;
    }
    
    /* do y coords. */
    
    ptv = v;
    for (i=0;i<n;i++,ptv++)
    {
	tv = (*ptv)->v[1];
	if (tv < min.v[1])
	    min.v[1] = tv;
	if (tv > max.v[1])
	    max.v[1] = tv;
    }
    
    /* do z coords. */
    ptv = v;
    for (i=0;i<n;i++,ptv++)
    {
	tv = (*ptv)->v[2];
	if (tv < min.v[2])
	    min.v[2] = tv;
	if (tv > max.v[2])
	    max.v[2] = tv;
    }

    VCOPY(bmin,&min);
    VCOPY(bmax,&max);

    return(CHILL);
}

int
lget_min_max_ptrs(vertex_3d **v,
		  int n,
		  vertex_3d **xmin,
		  vertex_3d **xmax,
		  vertex_3d **ymin,
		  vertex_3d **ymax)
{
    /**
      * this takes as input a list of ptrs to vertex_3d's.  it will
      * scan through the list, returning pointers to the vertex_3d
      * within the list that has minx, max, .etc.
    **/
    vertex_3d *vminx,*vmaxx,*vminy,*vmaxy,*p;
    int i,tsize;

    tsize = sizeof(vertex_3d);

    vminx = vmaxx = vminy = vmaxy = *v;

    for (i=1,p=*v;i<n;i++,p++)
    {
	if (p->v[0] < vminx->v[0])
	    vminx = p;
	if (p->v[0] > vmaxx->v[0])
	    vmaxx = p;
	if (p->v[1] < vminy->v[1])
	    vminy = p;
	if (p->v[1] > vmaxy->v[1])
	    vmaxy = p;
    }
    return(TRUE);
}

