 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kslicer
   >>>> 
   >>>>    Written By: Steven Kubica
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Dec 13, 1994
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kslicer_h_
#define _kslicer_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <geometry.h>

/* -include_includes */
#include "geometry/geometry.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$GEOMETRY/objects/kroutine/kslicer/uis/kslicer.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input file to slice (required infile)
 */
char	*i_file;	/* input file to slice FILENAME */
int	 i_flag;	/* input file to slice FLAG */

/*
 *  output file containing slice (required outfile)
 */
char	*o_file;	/* output file containing slice FILENAME */
int	 o_flag;	/* output file containing slice FLAG */

/*
 * choose orthogonal slice plane (Optional boolean toggle)
 *	1 (slice along constant width)
 *	2 (slice along constant height)
 *	3 (slice along constant depth)
 *	4 (slice along constant time)
 *	5 (slice along constant element),
 */
int	 p_toggle;		/* choose orthogonal slice plane LOGICAL TOGGLE */
int	 p_flag;		/* choose orthogonal slice plane FLAG */

/*
 *  reorient slice to face image plane (optional flag)
 */
int	 reo_flag;  	/* reorient slice to face image plane FLAG */

/*
 *  force explicit location data (optional flag)
 */
int	 loc_flag;  	/* force explicit location data FLAG */

/*----- optional ME group ----*/
/*
 *  slice at percentage depth on slice plane (optional float)
 */
float	 ps_float;	/* slice at percentage depth on slice plane FLOAT */
int	 ps_flag;   	/* slice at percentage depth on slice plane FLAG */

/*
 *  slice at position on slice plane (optional float)
 */
float	 s_float;	/* slice at position on slice plane FLOAT */
int	 s_flag;   	/* slice at position on slice plane FLAG */

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kslicer_get_args PROTO((kform *));
void kslicer_usage_additions PROTO((void));
void kslicer_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
