 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "gtubeness.h"
/*-----------------------------------------------------------
| 
|  Routine Name: gtubeness_get_args
| 
|       Purpose: Gets command line args for gtubeness
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gtubeness
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gtubeness_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for gtubeness is out of sync with arguments specified in gtubeness's *.pane file; please rerun ghostwriter on gtubeness.";


	/*
	 * allocate the gtubeness structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "gtubeness_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "scale",
			  &(clui_info->scale_float),
			  &(clui_info->scale_flag))))
	{
	    kerror(NULL, "gtubeness_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "subdivisions",
			  &(clui_info->subdivisions_int),
			  &(clui_info->subdivisions_flag))))
	{
	    kerror(NULL, "gtubeness_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "cap_style", KVF_LIST_LABEL,
			  &(clui_info->cap_style_label),
			  &(clui_info->cap_style_flag)) &&
	      kclui_get_value(pane, "cap_style", KVF_LIST_VAL,
			  &(clui_info->cap_style_list),
			  &(clui_info->cap_style_flag))))
	{
	    kerror(NULL, "gtubeness_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "gtubeness_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



