 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "gquadmesh.h"
/*-----------------------------------------------------------
| 
|  Routine Name: gquadmesh_get_args
| 
|       Purpose: Gets command line args for gquadmesh
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gquadmesh
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gquadmesh_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for gquadmesh is out of sync with arguments specified in gquadmesh's *.pane file; please rerun ghostwriter on gquadmesh.";


	/*
	 * allocate the gquadmesh structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "name",
			  &(clui_info->name_string),
			  &(clui_info->name_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "cmap",
			  &(clui_info->cmap_file),
			  &(clui_info->cmap_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "tc2d",
			  &(clui_info->tc2d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "umin2d",
			  &(clui_info->umin2d_double),
			  &(clui_info->umin2d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "umax2d",
			  &(clui_info->umax2d_double),
			  &(clui_info->umax2d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "vmin2d",
			  &(clui_info->vmin2d_double),
			  &(clui_info->vmin2d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "vmax2d",
			  &(clui_info->vmax2d_double),
			  &(clui_info->vmax2d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "tc3d",
			  &(clui_info->tc3d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "umin3d",
			  &(clui_info->umin3d_double),
			  &(clui_info->umin3d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "umax3d",
			  &(clui_info->umax3d_double),
			  &(clui_info->umax3d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "vmin3d",
			  &(clui_info->vmin3d_double),
			  &(clui_info->vmin3d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "vmax3d",
			  &(clui_info->vmax3d_double),
			  &(clui_info->vmax3d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "wmin3d",
			  &(clui_info->wmin3d_double),
			  &(clui_info->wmin3d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "wmax3d",
			  &(clui_info->wmax3d_double),
			  &(clui_info->wmax3d_flag))))
	{
	    kerror(NULL, "gquadmesh_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



