 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gextents
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gextents.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generate Geometry Representing Extents Around Data
|
|       Purpose: main program for gextents
|
|         Input:
|		char *clui_info->i_file; {input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output geometry object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->color_toggle; {box color}
|		int clui_info->color_flag; {TRUE if -color specified}
|
|		int clui_info->type_toggle; {box type}
|		int clui_info->type_flag; {TRUE if -type specified}
|
|		char *clui_info->name_string; {object name}
|		int   clui_info->name_flag; {TRUE if -name specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
    kobject input,output;
    int style,type;
    char *objname;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gextents_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "gextents",
		gextents_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	gextents_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
    /* open the objects. */
    input = kpds_open_input_object(clui_info->i_file);
    output = kgeom_open_output_object(clui_info->o_file);

    /* grab parms from structure. */
    style = clui_info->color_toggle;
    type = clui_info->type_toggle;
    objname = clui_info->name_string;
/* -main_before_lib_call_end */

/* -main_library_call */
    make_extents_box(input,output,style,objname,type);
/* -main_library_call_end */

/* -main_after_lib_call */
    /* close the objects */
    kpds_close_object(input);
    kgeom_close_object(output);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gextents_usage_additions
| 
|       Purpose: Prints usage additions in gextents_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gextents
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gextents_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerate Geometry Representing Extents Around Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gextents_free_args
| 
|       Purpose: Frees CLUI struct allocated in gextents_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gextents
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gextents_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->name_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
