 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for gcuberille
   >>>> 
   >>>>    Written By: Wes Bethel
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 13, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _gcuberille_h_
#define _gcuberille_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <geometry.h>

/* -include_includes */
#include <geometry/geometry.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$GEOMETRY/objects/kroutine/gcuberille/uis/gcuberille.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input 3d data object (required infile)
 */
char	*i_file;	/* input 3d data object FILENAME */
int	 i_flag;	/* input 3d data object FLAG */

/*
 *  input vis colormap (required infile)
 */
char	*cmap_file;	/* input vis colormap FILENAME */
int	 cmap_flag;	/* input vis colormap FLAG */

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

/*
 *  ratio of cuberille size to grid block size. (optional float)
 */
float	 shrink_float;	/* ratio of cuberille size to grid block size. FLOAT */
int	 shrink_flag;   	/* ratio of cuberille size to grid block size. FLAG */

/*
 *  object name (optional string)
 */
char	*name_string;	/* object name STRING */
int	 name_flag;   	/* object name FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void gcuberille_get_args PROTO((kform *));
void gcuberille_usage_additions PROTO((void));
void gcuberille_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
