 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for xprism Form
   >>>> 
   >>>>    Written By: conductor -name xprism -l 1
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 20, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'file' Pane
 */
typedef struct _Plot_file{

kform_struct *input_blank_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

char         *input_file;         /* filename for 'input_file'*/
kform_struct *input_file_struct;  /* pass to xvf_set_attributes() */
int          input_file_selected; /* TRUE on <cr> for 'input_file' */

int          plot_where_val;      /* value of toggle 'plot_where'*/
int          plot_where_num;      /* number of toggle member selected (1-N) */
kform_struct *plot_where_struct;  /* pass to xvf_set_attributes() */

int          object_type_val;      /* value of toggle 'object_type'*/
int          object_type_num;      /* number of toggle member selected (1-N) */
kform_struct *object_type_struct;  /* pass to xvf_set_attributes() */

} Plot_file;

/*
 * Pane Info Struct for 'function' Pane
 */
typedef struct _Plot_function{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          plot_dim;          /* int value of 'plot_dim'*/
char         *plot_dim_label;   /* label representing int value of 'plot_dim'*/
kform_struct *plot_dim_struct;  /* pass to xvf_set_attributes() */
int          plot_dim_selected; /* TRUE on <cr> for 'plot_dim' */

char         *func_3D;         /* string for 'func_3D'*/
kform_struct *func_3D_struct;  /* pass to xvf_set_attributes() */

char         *func_2D;         /* string for 'func_2D'*/
kform_struct *func_2D_struct;  /* pass to xvf_set_attributes() */

char         *x_min;         /* string for 'x_min'*/
kform_struct *x_min_struct;  /* pass to xvf_set_attributes() */

char         *x_max;         /* string for 'x_max'*/
kform_struct *x_max_struct;  /* pass to xvf_set_attributes() */

char         *xnum_pts;         /* string for 'xnum_pts'*/
kform_struct *xnum_pts_struct;  /* pass to xvf_set_attributes() */

char         *y_min;         /* string for 'y_min'*/
kform_struct *y_min_struct;  /* pass to xvf_set_attributes() */

char         *y_max;         /* string for 'y_max'*/
kform_struct *y_max_struct;  /* pass to xvf_set_attributes() */

char         *ynum_pts;         /* string for 'ynum_pts'*/
kform_struct *ynum_pts_struct;  /* pass to xvf_set_attributes() */

int          where_plot_val;      /* value of toggle 'where_plot'*/
int          where_plot_num;      /* number of toggle member selected (1-N) */
kform_struct *where_plot_struct;  /* pass to xvf_set_attributes() */

int          plot_function;          /* TRUE when user clicks on 'plot_function'*/
kform_struct *plot_function_struct;  /* pass to xvf_set_attributes() */

kform_struct *func_3D_blk_struct; /* pass to xvf_set_attributes() */

kform_struct *func_2D_blk_struct; /* pass to xvf_set_attributes() */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

kform_struct *X_blk_struct; /* pass to xvf_set_attributes() */

kform_struct *Y_blk_struct; /* pass to xvf_set_attributes() */

} Plot_function;

/*
 * Pane Info Struct for 'plot_control' Pane
 */
typedef struct _Plot_plot_control{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          plot2d_type_val;      /* value of toggle 'plot2d_type'*/
int          plot2d_type_num;      /* number of toggle member selected (1-N) */
kform_struct *plot2d_type_struct;  /* pass to xvf_set_attributes() */

int          plot3d_type_val;      /* value of toggle 'plot3d_type'*/
int          plot3d_type_num;      /* number of toggle member selected (1-N) */
kform_struct *plot3d_type_struct;  /* pass to xvf_set_attributes() */

} Plot_plot_control;

/*
 * Subform Info Struct for 'Plot' Subform
 */
typedef struct _xprism_Plot {

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

Plot_file   *file;          /* ptr to Pane Info struct for pane 'file' */
int        file_selected;          /* TRUE if input was from pane 'file' */
kform_struct *file_struct;          /* pass to xvf_set_attributes() */

Plot_function  *function;          /* ptr to Pane Info struct for pane 'function' */
int           function_selected;          /* TRUE if input was from pane 'function' */
kform_struct  *function_struct;          /* pass to xvf_set_attributes() */

Plot_plot_control  *plot_control;          /* ptr to Pane Info struct for pane 'plot_control' */
int               plot_control_selected;          /* TRUE if input was from pane 'plot_control' */
kform_struct      *plot_control_struct;          /* pass to xvf_set_attributes() */

}  xprism_Plot;

/*
 * Pane Info Struct for 'options' Pane
 */
typedef struct _Options_options{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          area_list;          /* int value of 'area_list'*/
char         *area_list_label;   /* label representing int value of 'area_list'*/
kform_struct *area_list_struct;  /* pass to xvf_set_attributes() */
int          area_list_selected; /* TRUE on <cr> for 'area_list' */

int          plot_list;          /* int value of 'plot_list'*/
char         *plot_list_label;   /* label representing int value of 'plot_list'*/
kform_struct *plot_list_struct;  /* pass to xvf_set_attributes() */
int          plot_list_selected; /* TRUE on <cr> for 'plot_list' */

int          open_area;          /* TRUE when user clicks on 'open_area'*/
kform_struct *open_area_struct;  /* pass to xvf_set_attributes() */

int          open_plot;          /* TRUE when user clicks on 'open_plot'*/
kform_struct *open_plot_struct;  /* pass to xvf_set_attributes() */

int          delete_area;          /* TRUE when user clicks on 'delete_area'*/
kform_struct *delete_area_struct;  /* pass to xvf_set_attributes() */

int          delete_plot;          /* TRUE when user clicks on 'delete_plot'*/
kform_struct *delete_plot_struct;  /* pass to xvf_set_attributes() */

} Options_options;

/*
 * Subform Info Struct for 'Options' Subform
 */
typedef struct _xprism_Options {

Options_options  *options;          /* ptr to Pane Info struct for pane 'options' */
int             options_selected;          /* TRUE if input was from pane 'options' */
kform_struct    *options_struct;          /* pass to xvf_set_attributes() */

}  xprism_Options;

/*
 * Pane Info Struct for 'screen_dump' Pane
 */
typedef struct _Print_screen_dump{

kform_struct *display_output_blank_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'QUIT' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          dump_what_val;      /* value of toggle 'dump_what'*/
int          dump_what_num;      /* number of toggle member selected (1-N) */
kform_struct *dump_what_struct;  /* pass to xvf_set_attributes() */

char         *display_file;         /* filename for 'display_file'*/
kform_struct *display_file_struct;  /* pass to xvf_set_attributes() */
int          display_file_selected; /* TRUE on <cr> for 'display_file' */

} Print_screen_dump;

/*
 * Subform Info Struct for 'Print' Subform
 */
typedef struct _xprism_Print {

Print_screen_dump  *screen_dump;          /* ptr to Pane Info struct for pane 'screen_dump' */
int               screen_dump_selected;          /* TRUE if input was from pane 'screen_dump' */
kform_struct      *screen_dump_struct;          /* pass to xvf_set_attributes() */

}  xprism_Print;

/*
 * Pane Info Struct for 'colormap' Pane
 */
typedef struct _Colormap_colormap{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'QUIT' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

xvobject     wksp1;          /* address of workspace 'wksp1'*/
kform_struct *wksp1_struct;  /* pass to xvf_set_attributes() */

xvobject     wksp2;          /* address of workspace 'wksp2'*/
kform_struct *wksp2_struct;  /* pass to xvf_set_attributes() */

kform_struct *b1_struct; /* pass to xvf_set_attributes() */

kform_struct *b2_struct; /* pass to xvf_set_attributes() */

} Colormap_colormap;

/*
 * Subform Info Struct for 'Colormap' Subform
 */
typedef struct _xprism_Colormap {

Colormap_colormap  *colormap;          /* ptr to Pane Info struct for pane 'colormap' */
int               colormap_selected;          /* TRUE if input was from pane 'colormap' */
kform_struct      *colormap_struct;          /* pass to xvf_set_attributes() */

}  xprism_Colormap;

/*
 * Pane Info Struct for 'deflts' Pane
 */
typedef struct _Deflts_deflts{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          new_plot;          /* int value of 'new_plot'*/
char         *new_plot_label;   /* label representing int value of 'new_plot'*/
kform_struct *new_plot_struct;  /* pass to xvf_set_attributes() */

int          display_title;          /* boolean value of 'display_title'*/
char         *display_title_label;   /* label assoc w/ value of 'display_title'*/
kform_struct *display_title_struct;  /* pass to xvf_set_attributes() */

int          display_date;          /* boolean value of 'display_date'*/
char         *display_date_label;   /* label assoc w/ value of 'display_date'*/
kform_struct *display_date_struct;  /* pass to xvf_set_attributes() */

char         *background;         /* string for 'background'*/
kform_struct *background_struct;  /* pass to xvf_set_attributes() */

char         *foreground;         /* string for 'foreground'*/
kform_struct *foreground_struct;  /* pass to xvf_set_attributes() */

} Deflts_deflts;

/*
 * Subform Info Struct for 'Deflts' Subform
 */
typedef struct _xprism_Deflts {

Deflts_deflts  *deflts;          /* ptr to Pane Info struct for pane 'deflts' */
int           deflts_selected;          /* TRUE if input was from pane 'deflts' */
kform_struct  *deflts_struct;          /* pass to xvf_set_attributes() */

}  xprism_Deflts;

/*
 * Form Info Struct for 'xprism' form
 */
typedef struct _gui_info_struct {

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

xvobject     workspace;          /* address of workspace 'workspace'*/
kform_struct *workspace_struct;  /* pass to xvf_set_attributes() */

int          reset_wcs;          /* TRUE when user clicks on 'reset_wcs'*/
kform_struct *reset_wcs_struct;  /* pass to xvf_set_attributes() */

int          add_indicator;          /* TRUE when user clicks on 'add_indicator'*/
kform_struct *add_indicator_struct;  /* pass to xvf_set_attributes() */

int          remove_area;          /* TRUE when user clicks on 'remove_area'*/
kform_struct *remove_area_struct;  /* pass to xvf_set_attributes() */

int          refresh_area;          /* TRUE when user clicks on 'refresh_area'*/
kform_struct *refresh_area_struct;  /* pass to xvf_set_attributes() */

int          clear_layout;          /* TRUE when user clicks on 'clear_layout'*/
kform_struct *clear_layout_struct;  /* pass to xvf_set_attributes() */

int          layout_menu;          /* TRUE when user clicks on 'layout_menu'*/
kform_struct *layout_menu_struct;  /* pass to xvf_set_attributes() */

kform_struct *b0_struct; /* pass to xvf_set_attributes() */

xprism_Plot  *Plot;
int Plot_selected;
kform_struct *Plot_struct;

xprism_Options  *Options;
int Options_selected;
kform_struct *Options_struct;

xprism_Print  *Print;
int Print_selected;
kform_struct *Print_struct;

xprism_Colormap  *Colormap;
int Colormap_selected;
kform_struct *Colormap_struct;

xprism_Deflts  *Deflts;
int Deflts_selected;
kform_struct *Deflts_struct;


kform_struct *xprism_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void xprism_reset_wcs	PROTO((gui_info_struct *));
void xprism_add_indicator	PROTO((gui_info_struct *));
void xprism_remove_area	PROTO((gui_info_struct *));
void xprism_refresh_area	PROTO((gui_info_struct *));
void xprism_clear_layout	PROTO((gui_info_struct *));
void xprism_layout_menu	PROTO((gui_info_struct *));
void _xvf_free_xprism PROTO((gui_info_struct *));
void _xvf_get_xprism  PROTO((gui_info_struct *));

int  _xvf_init_xprism PROTO((kform *, gui_info_struct *));
void run_xprism       PROTO((kform *, ksubform *, kaddr));

void run_Plot      PROTO((xprism_Plot *));
void _xvf_get_Plot PROTO((xprism_Plot *));

void run_file      PROTO((Plot_file *));
void _xvf_get_file PROTO((Plot_file *));
void file_input_file	PROTO((Plot_file *));

void run_function      PROTO((Plot_function *));
void _xvf_get_function PROTO((Plot_function *));
void function_plot_dim	PROTO((Plot_function *));
void function_plot_function	PROTO((Plot_function *));

void run_plot_control      PROTO((Plot_plot_control *));
void _xvf_get_plot_control PROTO((Plot_plot_control *));

void run_Options      PROTO((xprism_Options *));
void _xvf_get_Options PROTO((xprism_Options *));

void run_options      PROTO((Options_options *));
void _xvf_get_options PROTO((Options_options *));
void options_area_list	PROTO((Options_options *));
void options_plot_list	PROTO((Options_options *));
void options_open_area	PROTO((Options_options *));
void options_open_plot	PROTO((Options_options *));
void options_delete_area	PROTO((Options_options *));
void options_delete_plot	PROTO((Options_options *));

void run_Print      PROTO((xprism_Print *));
void _xvf_get_Print PROTO((xprism_Print *));

void run_screen_dump      PROTO((Print_screen_dump *));
void _xvf_get_screen_dump PROTO((Print_screen_dump *));
void screen_dump_display_file	PROTO((Print_screen_dump *));

void run_Colormap      PROTO((xprism_Colormap *));
void _xvf_get_Colormap PROTO((xprism_Colormap *));

void run_colormap      PROTO((Colormap_colormap *));
void _xvf_get_colormap PROTO((Colormap_colormap *));

void run_Deflts      PROTO((xprism_Deflts *));
void _xvf_get_Deflts PROTO((xprism_Deflts *));

void run_deflts      PROTO((Deflts_deflts *));
void _xvf_get_deflts PROTO((Deflts_deflts *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
