 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'xprism'
   >>>> 
   >>>>  Private: 
   >>>> 	run_xprism
   >>>> 	run_Plot
   >>>> 	run_file
   >>>> 	run_function
   >>>> 	run_Options
   >>>> 	run_options
   >>>> 	run_Print
   >>>> 	run_screen_dump
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "xprism.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_xprism
| 
|       Purpose: Main GUI Driver for xprism
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_xprism(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_xprism(master_info);

	if (form->quit)
	{
	    xvf_destroy_allforms();
	    _xvf_free_xprism(master_info);
	    return;
	}

	    /*
	     * user clicked on master action button selection 'reset_wcs'
	     */
	    if (master_info->reset_wcs)
	        xprism_reset_wcs(master_info);
	    /*
	     * user clicked on master action button selection 'add_indicator'
	     */
	    else if (master_info->add_indicator)
	        xprism_add_indicator(master_info);
	    /*
	     * user clicked on master action button selection 'remove_area'
	     */
	    else if (master_info->remove_area)
	        xprism_remove_area(master_info);
	    /*
	     * user clicked on master action button selection 'refresh_area'
	     */
	    else if (master_info->refresh_area)
	        xprism_refresh_area(master_info);
	    /*
	     * user clicked on master action button selection 'clear_layout'
	     */
	    else if (master_info->clear_layout)
	        xprism_clear_layout(master_info);
	    /*
	     * user clicked on master action button selection 'layout_menu'
	     */
	    else if (master_info->layout_menu)
	        xprism_layout_menu(master_info);
	/*
	 * action came from the 'Plot' subform
	 */
	if (master_info->Plot_selected)
	    run_Plot(master_info->Plot);
	/*
	 * action came from the 'Options' subform
	 */
	if (master_info->Options_selected)
	    run_Options(master_info->Options);
	/*
	 * action came from the 'Print' subform
	 */
	if (master_info->Print_selected)
	    run_Print(master_info->Print);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_Plot
| 
|       Purpose: GUI Driver for subform 'Plot'
| 
|         Input: form      - pointer to the form tree
|                Plot_info - pointer to xprism_Plot struct
| 
|        Output: None
|    Written By: conductor -program_name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Plot(
     xprism_Plot *Plot_info)
{

	/*
	 * action came from the 'file' pane
	 */
	if (Plot_info->file_selected)
	    run_file(Plot_info->file);

	/*
	 * action came from the 'function' pane
	 */
	else if (Plot_info->function_selected)
	    run_function(Plot_info->function);


}   /* end run_Plot */



/*-----------------------------------------------------------
| 
|  Routine Name: run_file
| 
|       Purpose: GUI Driver for pane 'file'
| 
|         Input: form - pointer to the form tree
|                file_info - pointer to Plot_file struct
| 
|        Output: None
|    Written By: conductor -program_name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_file(
     Plot_file *file_info)

{

	/*
	 * user selected 'live' input file selection 'input_file'
	 */
	if (file_info->input_file_selected)
	{
	    file_input_file(file_info);
	    file_info->input_file_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_function
| 
|       Purpose: GUI Driver for pane 'function'
| 
|         Input: form - pointer to the form tree
|                function_info - pointer to Plot_function struct
| 
|        Output: None
|    Written By: conductor -program_name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_function(
     Plot_function *function_info)

{

	/*
	 * user selected 'live' cycle selection 'plot_dim'
	 */
	if (function_info->plot_dim_selected)
	{
	    function_plot_dim(function_info);
	    function_info->plot_dim_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'plot_function'
	 */
	else if (function_info->plot_function)
	{
	    function_plot_function(function_info);
	    function_info->plot_function = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Options
| 
|       Purpose: GUI Driver for subform 'Options'
| 
|         Input: form      - pointer to the form tree
|                Options_info - pointer to xprism_Options struct
| 
|        Output: None
|    Written By: conductor -program_name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Options(
     xprism_Options *Options_info)
{

	/*
	 * action came from the 'options' pane
	 */
	if (Options_info->options_selected)
	    run_options(Options_info->options);


}   /* end run_Options */



/*-----------------------------------------------------------
| 
|  Routine Name: run_options
| 
|       Purpose: GUI Driver for pane 'options'
| 
|         Input: form - pointer to the form tree
|                options_info - pointer to Options_options struct
| 
|        Output: None
|    Written By: conductor -program_name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_options(
     Options_options *options_info)

{

	/*
	 * user selected 'live' list selection 'area_list'
	 */
	if (options_info->area_list_selected)
	{
	    options_area_list(options_info);
	    options_info->area_list_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'plot_list'
	 */
	else if (options_info->plot_list_selected)
	{
	    options_plot_list(options_info);
	    options_info->plot_list_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'open_area'
	 */
	else if (options_info->open_area)
	{
	    options_open_area(options_info);
	    options_info->open_area = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'open_plot'
	 */
	else if (options_info->open_plot)
	{
	    options_open_plot(options_info);
	    options_info->open_plot = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'delete_area'
	 */
	else if (options_info->delete_area)
	{
	    options_delete_area(options_info);
	    options_info->delete_area = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'delete_plot'
	 */
	else if (options_info->delete_plot)
	{
	    options_delete_plot(options_info);
	    options_info->delete_plot = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Print
| 
|       Purpose: GUI Driver for subform 'Print'
| 
|         Input: form      - pointer to the form tree
|                Print_info - pointer to xprism_Print struct
| 
|        Output: None
|    Written By: conductor -program_name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Print(
     xprism_Print *Print_info)
{

	/*
	 * action came from the 'screen_dump' pane
	 */
	if (Print_info->screen_dump_selected)
	    run_screen_dump(Print_info->screen_dump);


}   /* end run_Print */



/*-----------------------------------------------------------
| 
|  Routine Name: run_screen_dump
| 
|       Purpose: GUI Driver for pane 'screen_dump'
| 
|         Input: form - pointer to the form tree
|                screen_dump_info - pointer to Print_screen_dump struct
| 
|        Output: None
|    Written By: conductor -program_name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_screen_dump(
     Print_screen_dump *screen_dump_info)

{

	/*
	 * user selected 'live' output file selection 'display_file'
	 */
	if (screen_dump_info->display_file_selected)
	{
	    screen_dump_display_file(screen_dump_info);
	    screen_dump_info->display_file_selected = FALSE;
	}


}


