 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */


/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>          Legend (Class) List Utility Routines
   >>>>
   >>>>  Private: spc_update_legend_color_cb
   >>>>           spc_update_classname_cb
   >>>>           spc_colorbox_cb
   >>>>           spc_set_current_class
   >>>>           spc_update_cluster_stats
   >>>>           spc_update_all_classcontents_labels
   >>>>           spc_update_classcontents_label
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#include "spectrum.h"

/*-----------------------------------------------------------
|
|  Routine Name: spc_update_legend_color_cb
|
|       Purpose: This is the callback for the pseudocolor scrollbars,
|                which updates the legend color and the RGB triple 
|                displayed for the current entry. 
|
|         Input: object      - the pseudocolor object
|                client_data - unused
|                call_data   - passes in the xvw_pseudo_struct 
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro
|          Date: June 13, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void spc_update_legend_color_cb(
    xvobject object,
    kaddr    client_data,	
    kaddr    call_data)
{
	char              temp[KLENGTH];
	LegendEntry       *legend_ptr;
	xvw_pseudo_struct *pseudo_struct = (xvw_pseudo_struct *) call_data;

	legend_ptr = spc_current_class;
	if (legend_ptr == NULL) return;
	
	/*
	 * update the label displaying RGB values in legend display
	 */
	if (pseudo_struct->type == KPSEUDO_RED)
	    legend_ptr->redval = pseudo_struct->value;
	else if (pseudo_struct->type == KPSEUDO_GREEN)
	    legend_ptr->greenval = pseudo_struct->value;
	else if (pseudo_struct->type == KPSEUDO_BLUE)
	    legend_ptr->blueval = pseudo_struct->value;

	ksprintf(temp, " RGB values:  %d %d %d", 
                legend_ptr->redval, legend_ptr->greenval, legend_ptr->blueval);

	xvw_set_attribute(legend_ptr->RGBobj, XVW_LABEL, temp);
	xvw_set_attributes(legend_ptr->colorbox,
		XVW_COLORCELL_REDVAL,   legend_ptr->redval,
		XVW_COLORCELL_GREENVAL, legend_ptr->greenval,
		XVW_COLORCELL_BLUEVAL,  legend_ptr->blueval,
		NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: spc_update_classname_cb
|
|       Purpose: This is the callback which updates the name
|                of the class when the user clicks on the 
|                legend classname text button.
|
|         Input: object      - the colorbox
|                client_data - passes in the legend pointer 
|                call_data   - unused
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro
|          Date: June 13, 1993
| Modifications: Updated from Khoros 1.0 (DA)
|
------------------------------------------------------------*/
/* ARGSUSED */
void spc_update_classname_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        int         accepted;
	char        *text = NULL;
	LegendEntry *legend_ptr;

        legend_ptr = (LegendEntry *) client_data;

	/* get & assign new class name */
	while (text == NULL)
	{
            accepted = spc_get_new_classname(&text);
	    if (!accepted) return;
	}
        kfree(legend_ptr->classname);
	legend_ptr->classname       = kstrdup(text);
	legend_ptr->classname_token = kstring_to_token(text);
	kfree(text);

	xvw_set_attribute(legend_ptr->classnamebutton, XVW_LABEL, legend_ptr->classname);
	if (spc_current_class == legend_ptr)
	    xvf_set_attribute(gui_info->currclass_blk_struct, XVF_TITLE, 
			      legend_ptr->classname);

}

/*-----------------------------------------------------------
|
|  Routine Name: spc_colorbox_cb
|
|       Purpose: This is the callback which updates the
|                current class when the user clicks on
|                the colorbox in the legend entry display.
|
|         Input: xvobject    - the colorbox
|                client_data - passes in the legend pointer
|                call_data   - unused
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro
|          Date: Sept 30, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void spc_colorbox_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        LegendEntry *legend_ptr;

        legend_ptr = (LegendEntry *) client_data;

	/* update the current class */
	spc_set_current_class(legend_ptr);

}

/*-----------------------------------------------------------
|
|  Routine Name: spc_set_current_class
|
|       Purpose: Sets the current class to the legend ptr
|                passed in.  This would be just a simple assignment,
|                except for the need to update the GUI, and set the
|                appropriate clusters (pixel values) on the pseudocolor bars.
|
|         Input: legend_ptr - legend ptr to become the current class
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro
|          Date: Oct 29, 1993
| Modifications:
|
------------------------------------------------------------*/
void spc_set_current_class(
    LegendEntry *legend_ptr)
{
	char         temp[KLENGTH];

	/* update the current class */
	spc_current_class = legend_ptr;

	/* update GUI to reflect current class */
	if (spc_current_class == NULL)
	    xvf_set_attribute(gui_info->currclass_blk_struct, 
			      XVF_TITLE, "none");
	else xvf_set_attribute(gui_info->currclass_blk_struct, 
			       XVF_TITLE, legend_ptr->classname);

	/* update pseudocolor bars to reflect color of latest class */
	spc_set_pseudo_color(legend_ptr);

	if (spc_current_class != NULL)
	{
	    ksprintf(temp, " RGB values:  %d %d %d", legend_ptr->redval, 
		     legend_ptr->greenval, legend_ptr->blueval);
	    xvw_set_attribute(legend_ptr->RGBobj, XVW_LABEL, temp);
	}

}
/*-----------------------------------------------------------
|
|  Routine Name: spc_update_cluster_stats
|
|       Purpose: This event handler gets called when the user
|                moves the pointer across the image or the scatterplot.
|                It updates the statistics on the Statistics/ClassContents
|                subform to give the map column values for the cluster
|                over which the pointer appears.
|
|         Input: object      - image workspace object
|                client_data - unused
|                event       - the ButtonMotion event
|        Output: dispatch    - whether to allow event to propogate
|       Returns: none
|    Written By: Danielle Argiro
|          Date: July 16, 1994
| Modifications: 
|
------------------------------------------------------------*/

/* ARGSUSED */
void spc_update_cluster_stats(
    xvobject object,
    kaddr    client_data,
    XEvent   *event,
    int      *dispatch)
{
	double tmp_double;
        int    i, cluster, point_index;
        char   temp[KLENGTH];

        if (!xvw_check_mapped(gui_info->Stats->stats->stats_wksp))
            return;

	/*
         * here, the event came from the scatter plot.  if we can't identify
         * the device coordinate as a point in the plot, just return;  if
         * so, then get the pixel (cluster) value represented by the point.
         */
        if (object == spc_scatter->area)
        {
            if (!(spc_identify_plot_point(event->xbutton.x,
                                          event->xbutton.y,
                                          &cluster, &point_index)))
                return;
        }

	/*
         * event came from the main spectrum workspace or the zoom window. 
	 * get pixel value at that point.
         */
        else
        {
             xvw_get_attribute(object, XVW_IMAGE_VALUE,  &tmp_double);
             cluster = (int) tmp_double;
        }

	ksprintf(temp, " Cluster: %d", cluster);
	xvw_set_attribute(spc_info->clusternum_obj, XVW_LABEL, temp);

	if ((spc_legend_lookup!= NULL) && 
	    (spc_legend_lookup[cluster] != NULL))
	    ksprintf(temp, " Class: %s", spc_legend_lookup[cluster]->classname);
	else ksprintf(temp, " Class: unassigned");
        xvw_set_attribute(spc_info->assignedclass_obj, XVW_LABEL, temp);

	ksprintf(temp, " Count: %d", spc_count[cluster]);
        xvw_set_attribute(spc_info->count_obj, XVW_LABEL, temp);

	/*
	ksprintf(temp, " Variance: %f", 0.987);
        xvw_set_attribute(spc_info->variance_obj, XVW_LABEL, temp);
	 */

	for (i = 0; i < spc_map_colnum; i++)
	{
	    ksprintf(temp, "%s: %g", 
		     spc_mapcol_names[i], spc_maps[cluster][i]);
	    xvw_set_attribute(spc_info->mapcols_obj[i],
                              XVW_LABEL, temp);
	}

}

/*-----------------------------------------------------------
|
|  Routine Name: spc_update_all_classcontents_labels
|
|       Purpose: This routine gets called when a new image is input,
|                when a new legend file is input, or when the user creates 
|		 a new class.  It updates the labels on the Class Contents
|                subform to show the clusters that are assigned to each class.
|         Input: None
|        Output: None
|       Returns: none
|    Written By: Danielle Argiro
|          Date: July 16, 1994
| Modifications:
|
------------------------------------------------------------*/

void spc_update_all_classcontents_labels(void)
{
        LegendEntry *legend_ptr;

        legend_ptr = spc_legend_list;
        while (legend_ptr != NULL)
        {
	    spc_update_classcontents_label(legend_ptr);
            legend_ptr = legend_ptr->next;
        }

}

/*-----------------------------------------------------------
|
|  Routine Name: spc_update_classcontents_label
|
|       Purpose: Updates the labels on the Class Contents subform to show 
|		 the clusters that are assigned to the specified class.
|
|         Input: legend_ptr - class for which to update classcontents label
|        Output: None
|       Returns: none
|    Written By: Danielle Argiro
|          Date: July 16, 1994
| Modifications:
|
------------------------------------------------------------*/

void spc_update_classcontents_label(
     LegendEntry *legend_ptr)
{
        int  i;
        char *contents;

	contents = spc_set_classcontents_label(legend_ptr);
        xvw_set_attribute(legend_ptr->contents_obj, XVW_LABEL, contents);
}

/*-----------------------------------------------------------
|
|  Routine Name: spc_set_classcontents_label
|
|       Purpose: Returns a string containing the contents of a class.
|
|         Input: legend_ptr - class for which to update classcontents label
|        Output: None
|       Returns: none
|    Written By: Danielle Argiro
|          Date: July 16, 1994
| Modifications:
|
------------------------------------------------------------*/

char *spc_set_classcontents_label(
     LegendEntry *legend_ptr)
{
        int  i;
        char temp[KLENGTH];
        char contents[3*KLENGTH];

        ksprintf(contents, "Contents of Class '%s':\n", legend_ptr->classname);

        if (legend_ptr->clusternum == 0)
            ksprintf(temp, "nothing");

        for (i = 0; i < legend_ptr->clusternum; i++)
        {
                if (i < legend_ptr->clusternum - 1)
                    ksprintf(temp, "%d, ", legend_ptr->clusters[i]);
                else ksprintf(temp, "%d", legend_ptr->clusters[i]);

                if ((i > 0) && ((i % 10) == 0))
                    ksprintf(temp, "%s\n", temp);

                kstring_cat(contents, temp, contents);
        }
	return(kstrdup(contents));
}




