 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for spectrum Form
   >>>> 
   >>>>    Written By: conductor -name spectrum -l 3
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'files' Pane
 */
typedef struct _Files_files{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *in_image;         /* filename for 'in_image'*/
kform_struct *in_image_struct;  /* pass to xvf_set_attributes() */
int          in_image_selected; /* TRUE on <cr> for 'in_image' */

char         *in_legend;         /* filename for 'in_legend'*/
kform_struct *in_legend_struct;  /* pass to xvf_set_attributes() */
int          in_legend_selected; /* TRUE on <cr> for 'in_legend' */

char         *in_environ;         /* filename for 'in_environ'*/
kform_struct *in_environ_struct;  /* pass to xvf_set_attributes() */
int          in_environ_selected; /* TRUE on <cr> for 'in_environ' */

char         *out_image;         /* filename for 'out_image'*/
kform_struct *out_image_struct;  /* pass to xvf_set_attributes() */
int          out_image_selected; /* TRUE on <cr> for 'out_image' */

char         *out_legend;         /* filename for 'out_legend'*/
kform_struct *out_legend_struct;  /* pass to xvf_set_attributes() */
int          out_legend_selected; /* TRUE on <cr> for 'out_legend' */

char         *out_group;         /* filename for 'out_group'*/
kform_struct *out_group_struct;  /* pass to xvf_set_attributes() */
int          out_group_selected; /* TRUE on <cr> for 'out_group' */

char         *out_maps;         /* filename for 'out_maps'*/
kform_struct *out_maps_struct;  /* pass to xvf_set_attributes() */
int          out_maps_selected; /* TRUE on <cr> for 'out_maps' */

kform_struct *blk1_struct; /* pass to xvf_set_attributes() */

kform_struct *blk10_struct; /* pass to xvf_set_attributes() */

} Files_files;

/*
 * Subform Info Struct for 'Files' Subform
 */
typedef struct _spectrum_Files {

Files_files  *files;          /* ptr to Pane Info struct for pane 'files' */
int         files_selected;          /* TRUE if input was from pane 'files' */
kform_struct *files_struct;          /* pass to xvf_set_attributes() */

}  spectrum_Files;

/*
 * Pane Info Struct for 'disp' Pane
 */
typedef struct _Disp_disp{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          norm_type;          /* int value of 'norm_type'*/
char         *norm_type_label;   /* label representing int value of 'norm_type'*/
kform_struct *norm_type_struct;  /* pass to xvf_set_attributes() */
int          norm_type_selected; /* TRUE on <cr> for 'norm_type' */

int          norm_method_val;      /* value of toggle 'norm_method'*/
int          norm_method_num;      /* number of toggle member selected (1-N) */
kform_struct *norm_method_struct;  /* pass to xvf_set_attributes() */
int          norm_method_selected; /* TRUE on <cr> for 'norm_method' */

int          change_mapcol_names;          /* TRUE when user clicks on 'change_mapcol_names'*/
kform_struct *change_mapcol_names_struct;  /* pass to xvf_set_attributes() */

int          list_mapcol_names;          /* TRUE when user clicks on 'list_mapcol_names'*/
kform_struct *list_mapcol_names_struct;  /* pass to xvf_set_attributes() */

int          t;          /* TRUE when user clicks on 't'*/
kform_struct *t_struct;  /* pass to xvf_set_attributes() */

int          red;          /* TRUE when user clicks on 'red'*/
kform_struct *red_struct;  /* pass to xvf_set_attributes() */

int          green;          /* TRUE when user clicks on 'green'*/
kform_struct *green_struct;  /* pass to xvf_set_attributes() */

int          blue;          /* TRUE when user clicks on 'blue'*/
kform_struct *blue_struct;  /* pass to xvf_set_attributes() */

char         *red_func;         /* string for 'red_func'*/
kform_struct *red_func_struct;  /* pass to xvf_set_attributes() */
int          red_func_selected; /* TRUE on <cr> for 'red_func' */

char         *green_func;         /* string for 'green_func'*/
kform_struct *green_func_struct;  /* pass to xvf_set_attributes() */
int          green_func_selected; /* TRUE on <cr> for 'green_func' */

char         *blue_func;         /* string for 'blue_func'*/
kform_struct *blue_func_struct;  /* pass to xvf_set_attributes() */
int          blue_func_selected; /* TRUE on <cr> for 'blue_func' */

kform_struct *blank3A_struct; /* pass to xvf_set_attributes() */

kform_struct *blank4A_struct; /* pass to xvf_set_attributes() */

kform_struct *blank4B_struct; /* pass to xvf_set_attributes() */

kform_struct *redcol_struct; /* pass to xvf_set_attributes() */

kform_struct *grcol_struct; /* pass to xvf_set_attributes() */

kform_struct *blcol_struct; /* pass to xvf_set_attributes() */

kform_struct *blank7_struct; /* pass to xvf_set_attributes() */

kform_struct *blank1A_struct; /* pass to xvf_set_attributes() */

kform_struct *curr_trans_struct; /* pass to xvf_set_attributes() */

} Disp_disp;

/*
 * Subform Info Struct for 'Disp' Subform
 */
typedef struct _spectrum_Disp {

Disp_disp   *disp;          /* ptr to Pane Info struct for pane 'disp' */
int        disp_selected;          /* TRUE if input was from pane 'disp' */
kform_struct *disp_struct;          /* pass to xvf_set_attributes() */

}  spectrum_Disp;

/*
 * Pane Info Struct for 'curve' Pane
 */
typedef struct _Curve_curve{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          update_mode;          /* boolean value of 'update_mode'*/
char         *update_mode_label;   /* label assoc w/ value of 'update_mode'*/
kform_struct *update_mode_struct;  /* pass to xvf_set_attributes() */
int          update_mode_selected; /* TRUE on <cr> for 'update_mode' */

int          clear;          /* TRUE when user clicks on 'clear'*/
kform_struct *clear_struct;  /* pass to xvf_set_attributes() */

xvobject     curve_workspace;          /* address of workspace 'curve_workspace'*/
kform_struct *curve_workspace_struct;  /* pass to xvf_set_attributes() */

} Curve_curve;

/*
 * Subform Info Struct for 'Curve' Subform
 */
typedef struct _spectrum_Curve {

Curve_curve  *curve;          /* ptr to Pane Info struct for pane 'curve' */
int         curve_selected;          /* TRUE if input was from pane 'curve' */
kform_struct *curve_struct;          /* pass to xvf_set_attributes() */

}  spectrum_Curve;

/*
 * Pane Info Struct for 'legend' Pane
 */
typedef struct _Legend_legend{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          empty;          /* TRUE when user clicks on 'empty'*/
kform_struct *empty_struct;  /* pass to xvf_set_attributes() */

int          show;          /* TRUE when user clicks on 'show'*/
kform_struct *show_struct;  /* pass to xvf_set_attributes() */

int          catch_all;          /* TRUE when user clicks on 'catch_all'*/
kform_struct *catch_all_struct;  /* pass to xvf_set_attributes() */

int          hide;          /* TRUE when user clicks on 'hide'*/
kform_struct *hide_struct;  /* pass to xvf_set_attributes() */

int          transfer;          /* TRUE when user clicks on 'transfer'*/
kform_struct *transfer_struct;  /* pass to xvf_set_attributes() */

xvobject     legend_workspace;          /* address of workspace 'legend_workspace'*/
kform_struct *legend_workspace_struct;  /* pass to xvf_set_attributes() */

} Legend_legend;

/*
 * Subform Info Struct for 'Legend' Subform
 */
typedef struct _spectrum_Legend {

Legend_legend  *legend;          /* ptr to Pane Info struct for pane 'legend' */
int           legend_selected;          /* TRUE if input was from pane 'legend' */
kform_struct  *legend_struct;          /* pass to xvf_set_attributes() */

}  spectrum_Legend;

/*
 * Pane Info Struct for 'zoom' Pane
 */
typedef struct _Zoom_zoom{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          zoommode;          /* boolean value of 'zoommode'*/
char         *zoommode_label;   /* label assoc w/ value of 'zoommode'*/
kform_struct *zoommode_struct;  /* pass to xvf_set_attributes() */
int          zoommode_selected; /* TRUE on <cr> for 'zoommode' */

double       zoomfactor;          /* double value of 'zoomfactor'*/
kform_struct *zoomfactor_struct;  /* pass to xvf_set_attributes() */
int          zoomfactor_selected; /* TRUE on <cr> for 'zoomfactor' */

xvobject     zoom_workspace;          /* address of workspace 'zoom_workspace'*/
kform_struct *zoom_workspace_struct;  /* pass to xvf_set_attributes() */

} Zoom_zoom;

/*
 * Subform Info Struct for 'Zoom' Subform
 */
typedef struct _spectrum_Zoom {

Zoom_zoom   *zoom;          /* ptr to Pane Info struct for pane 'zoom' */
int        zoom_selected;          /* TRUE if input was from pane 'zoom' */
kform_struct *zoom_struct;          /* pass to xvf_set_attributes() */

}  spectrum_Zoom;

/*
 * Pane Info Struct for 'scatter' Pane
 */
typedef struct _Scatter_scatter{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          x_column;          /* TRUE when user clicks on 'x_column'*/
kform_struct *x_column_struct;  /* pass to xvf_set_attributes() */

int          y_column;          /* TRUE when user clicks on 'y_column'*/
kform_struct *y_column_struct;  /* pass to xvf_set_attributes() */

char         *x_func;         /* string for 'x_func'*/
kform_struct *x_func_struct;  /* pass to xvf_set_attributes() */
int          x_func_selected; /* TRUE on <cr> for 'x_func' */

char         *y_func;         /* string for 'y_func'*/
kform_struct *y_func_struct;  /* pass to xvf_set_attributes() */
int          y_func_selected; /* TRUE on <cr> for 'y_func' */

int          set;          /* TRUE when user clicks on 'set'*/
kform_struct *set_struct;  /* pass to xvf_set_attributes() */

int          reset;          /* TRUE when user clicks on 'reset'*/
kform_struct *reset_struct;  /* pass to xvf_set_attributes() */

xvobject     plot_workspace;          /* address of workspace 'plot_workspace'*/
kform_struct *plot_workspace_struct;  /* pass to xvf_set_attributes() */

kform_struct *xcol_blank_struct; /* pass to xvf_set_attributes() */

kform_struct *ycol_blank_struct; /* pass to xvf_set_attributes() */

} Scatter_scatter;

/*
 * Subform Info Struct for 'Scatter' Subform
 */
typedef struct _spectrum_Scatter {

Scatter_scatter  *scatter;          /* ptr to Pane Info struct for pane 'scatter' */
int             scatter_selected;          /* TRUE if input was from pane 'scatter' */
kform_struct    *scatter_struct;          /* pass to xvf_set_attributes() */

}  spectrum_Scatter;

/*
 * Pane Info Struct for 'stats' Pane
 */
typedef struct _Stats_stats{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

xvobject     stats_wksp;          /* address of workspace 'stats_wksp'*/
kform_struct *stats_wksp_struct;  /* pass to xvf_set_attributes() */

} Stats_stats;

/*
 * Subform Info Struct for 'Stats' Subform
 */
typedef struct _spectrum_Stats {

Stats_stats  *stats;          /* ptr to Pane Info struct for pane 'stats' */
int         stats_selected;          /* TRUE if input was from pane 'stats' */
kform_struct *stats_struct;          /* pass to xvf_set_attributes() */

}  spectrum_Stats;

/*
 * Pane Info Struct for 'contents' Pane
 */
typedef struct _Contents_contents{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *o;         /* filename for 'o'*/
kform_struct *o_struct;  /* pass to xvf_set_attributes() */
int          o_selected; /* TRUE on <cr> for 'o' */

xvobject     contents_wksp;          /* address of workspace 'contents_wksp'*/
kform_struct *contents_wksp_struct;  /* pass to xvf_set_attributes() */

} Contents_contents;

/*
 * Subform Info Struct for 'Contents' Subform
 */
typedef struct _spectrum_Contents {

Contents_contents  *contents;          /* ptr to Pane Info struct for pane 'contents' */
int               contents_selected;          /* TRUE if input was from pane 'contents' */
kform_struct      *contents_struct;          /* pass to xvf_set_attributes() */

}  spectrum_Contents;

/*
 * Form Info Struct for 'spectrum' form
 */
typedef struct _gui_info_struct {

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

xvobject     image_workspace;          /* address of workspace 'image_workspace'*/
kform_struct *image_workspace_struct;  /* pass to xvf_set_attributes() */

int          add_class;          /* TRUE when user clicks on 'add_class'*/
kform_struct *add_class_struct;  /* pass to xvf_set_attributes() */

int          delete_class;          /* TRUE when user clicks on 'delete_class'*/
kform_struct *delete_class_struct;  /* pass to xvf_set_attributes() */

int          select;          /* TRUE when user clicks on 'select'*/
kform_struct *select_struct;  /* pass to xvf_set_attributes() */

int          cluster_operation_val;      /* value of toggle 'cluster_operation'*/
int          cluster_operation_num;      /* number of toggle member selected (1-N) */
kform_struct *cluster_operation_struct;  /* pass to xvf_set_attributes() */
int          cluster_operation_selected; /* TRUE on <cr> for 'cluster_operation' */

int          add_cluster_manually;          /* TRUE when user clicks on 'add_cluster_manually'*/
kform_struct *add_cluster_manually_struct;  /* pass to xvf_set_attributes() */

int          delete_cluster_manually;          /* TRUE when user clicks on 'delete_cluster_manually'*/
kform_struct *delete_cluster_manually_struct;  /* pass to xvf_set_attributes() */

int          reassign;          /* TRUE when user clicks on 'reassign'*/
kform_struct *reassign_struct;  /* pass to xvf_set_attributes() */

int          autoclass;          /* TRUE when user clicks on 'autoclass'*/
kform_struct *autoclass_struct;  /* pass to xvf_set_attributes() */

kform_struct *b0_struct; /* pass to xvf_set_attributes() */

kform_struct *cl_blk_struct; /* pass to xvf_set_attributes() */

kform_struct *select_blk_struct; /* pass to xvf_set_attributes() */

kform_struct *label_blk_struct; /* pass to xvf_set_attributes() */

kform_struct *currclass_blk_struct; /* pass to xvf_set_attributes() */

spectrum_Files  *Files;
int Files_selected;
kform_struct *Files_struct;

spectrum_Disp  *Disp;
int Disp_selected;
kform_struct *Disp_struct;

spectrum_Curve  *Curve;
int Curve_selected;
kform_struct *Curve_struct;

spectrum_Legend  *Legend;
int Legend_selected;
kform_struct *Legend_struct;

spectrum_Zoom  *Zoom;
int Zoom_selected;
kform_struct *Zoom_struct;

spectrum_Scatter  *Scatter;
int Scatter_selected;
kform_struct *Scatter_struct;

spectrum_Stats  *Stats;
int Stats_selected;
kform_struct *Stats_struct;

spectrum_Contents  *Contents;
int Contents_selected;
kform_struct *Contents_struct;


kform_struct *spectrum_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void spectrum_add_class	PROTO((gui_info_struct *));
void spectrum_delete_class	PROTO((gui_info_struct *));
void spectrum_select	PROTO((gui_info_struct *));
void spectrum_cluster_operation	PROTO((gui_info_struct *));
void spectrum_add_cluster_manually	PROTO((gui_info_struct *));
void spectrum_delete_cluster_manually	PROTO((gui_info_struct *));
void spectrum_reassign	PROTO((gui_info_struct *));
void spectrum_autoclass	PROTO((gui_info_struct *));
void _xvf_free_spectrum PROTO((gui_info_struct *));
void _xvf_get_spectrum  PROTO((gui_info_struct *));

int  _xvf_init_spectrum PROTO((kform *, gui_info_struct *));
void run_spectrum       PROTO((kform *, ksubform *, kaddr));

void run_Files      PROTO((spectrum_Files *));
void _xvf_get_Files PROTO((spectrum_Files *));

void run_files      PROTO((Files_files *));
void _xvf_get_files PROTO((Files_files *));
void files_in_image	PROTO((Files_files *));
void files_in_legend	PROTO((Files_files *));
void files_in_environ	PROTO((Files_files *));
void files_out_image	PROTO((Files_files *));
void files_out_legend	PROTO((Files_files *));
void files_out_group	PROTO((Files_files *));
void files_out_maps	PROTO((Files_files *));

void run_Disp      PROTO((spectrum_Disp *));
void _xvf_get_Disp PROTO((spectrum_Disp *));

void run_disp      PROTO((Disp_disp *));
void _xvf_get_disp PROTO((Disp_disp *));
void disp_norm_type	PROTO((Disp_disp *));
void disp_norm_method	PROTO((Disp_disp *));
void disp_change_mapcol_names	PROTO((Disp_disp *));
void disp_list_mapcol_names	PROTO((Disp_disp *));
void disp_t	PROTO((Disp_disp *));
void disp_red	PROTO((Disp_disp *));
void disp_green	PROTO((Disp_disp *));
void disp_blue	PROTO((Disp_disp *));
void disp_red_func	PROTO((Disp_disp *));
void disp_green_func	PROTO((Disp_disp *));
void disp_blue_func	PROTO((Disp_disp *));

void run_Curve      PROTO((spectrum_Curve *));
void _xvf_get_Curve PROTO((spectrum_Curve *));

void run_curve      PROTO((Curve_curve *));
void _xvf_get_curve PROTO((Curve_curve *));
void curve_update_mode	PROTO((Curve_curve *));
void curve_clear	PROTO((Curve_curve *));

void run_Legend      PROTO((spectrum_Legend *));
void _xvf_get_Legend PROTO((spectrum_Legend *));

void run_legend      PROTO((Legend_legend *));
void _xvf_get_legend PROTO((Legend_legend *));
void legend_empty	PROTO((Legend_legend *));
void legend_show	PROTO((Legend_legend *));
void legend_catch_all	PROTO((Legend_legend *));
void legend_hide	PROTO((Legend_legend *));
void legend_transfer	PROTO((Legend_legend *));

void run_Zoom      PROTO((spectrum_Zoom *));
void _xvf_get_Zoom PROTO((spectrum_Zoom *));

void run_zoom      PROTO((Zoom_zoom *));
void _xvf_get_zoom PROTO((Zoom_zoom *));
void zoom_zoommode	PROTO((Zoom_zoom *));
void zoom_zoomfactor	PROTO((Zoom_zoom *));

void run_Scatter      PROTO((spectrum_Scatter *));
void _xvf_get_Scatter PROTO((spectrum_Scatter *));

void run_scatter      PROTO((Scatter_scatter *));
void _xvf_get_scatter PROTO((Scatter_scatter *));
void scatter_x_column	PROTO((Scatter_scatter *));
void scatter_y_column	PROTO((Scatter_scatter *));
void scatter_x_func	PROTO((Scatter_scatter *));
void scatter_y_func	PROTO((Scatter_scatter *));
void scatter_set	PROTO((Scatter_scatter *));
void scatter_reset	PROTO((Scatter_scatter *));

void run_Stats      PROTO((spectrum_Stats *));
void _xvf_get_Stats PROTO((spectrum_Stats *));

void run_stats      PROTO((Stats_stats *));
void _xvf_get_stats PROTO((Stats_stats *));

void run_Contents      PROTO((spectrum_Contents *));
void _xvf_get_Contents PROTO((spectrum_Contents *));

void run_contents      PROTO((Contents_contents *));
void _xvf_get_contents PROTO((Contents_contents *));
void contents_o	PROTO((Contents_contents *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
