 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane legend
   >>>> 
   >>>>  Private: 
   >>>> 	legend_delete
   >>>> 	legend_empty
   >>>> 	legend_show
   >>>> 	legend_hide
   >>>> 	legend_catch_all
   >>>> 	legend_transfer
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */



#include "spectrum.h"

/*-----------------------------------------------------------
| 
|  Routine Name: legend_delete
| 
|       Purpose: Do routine which is called when
|                  pane action button delete is used
| 
|         Input: legend_info - ptr to PaneInfo struct for legend pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void legend_delete(
     Legend_legend *legend_info)
{
	/* sanity check */
	if (spc_image == NULL)
	{
	    kerror(NULL, "legend_delete",
		   "You must display an image w/ a legend before deleting classes!");
	    kinfo(KHOSTILE, "What a bonehead... ");
	    return;
	}
	spc_delete_or_empty(SPC_DELETE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: legend_empty
| 
|       Purpose: Do routine which is called when
|                  pane action button empty is used
| 
|         Input: legend_info - ptr to PaneInfo struct for legend pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void legend_empty(
     Legend_legend *legend_info)
{
	/* sanity check */
	if (spc_image == NULL)
	{
	    kerror(NULL, "legend_empty",
		   "You must display an image w/ a legend before emptying classes!");
	    kinfo(KHOSTILE, "Get a life!");
	    return;
	}
	spc_delete_or_empty(SPC_EMPTY);
}


/*-----------------------------------------------------------
| 
|  Routine Name: legend_show
| 
|       Purpose: Do routine which is called when
|                  pane action button show is used
| 
|         Input: legend_info - ptr to PaneInfo struct for legend pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void legend_show(
     Legend_legend *legend_info)
{
	/* sanity check */
	if (spc_image == NULL)
	{
	    kerror(NULL, "legend_show",
		   "You must display an image w/ a legend before displaying classes!");
	    kinfo(KHOSTILE, "Does thickheadedness run in your family, or is it just you?");
	    return;
	}
	spc_hide_or_show(SPC_DISPLAYED);
}


/*-----------------------------------------------------------
| 
|  Routine Name: legend_hide
| 
|       Purpose: Do routine which is called when
|                  pane action button hide is used
| 
|         Input: legend_info - ptr to PaneInfo struct for legend pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void legend_hide(
     Legend_legend *legend_info)
{
        /* sanity check */
        if (spc_image == NULL)
        {
            kerror(NULL, "legend_hide",
                   "You must display an image w/ a legend before hiding classes!");
	    kinfo(KHOSTILE, "I hope you're not actually getting paid to do this.");
            return;
        }

	spc_hide_or_show(SPC_HIDDEN);
}


/*-----------------------------------------------------------
| 
|  Routine Name: legend_catch_all
| 
|       Purpose: Do routine which is called when
|                  pane action button catch_all is used
| 
|         Input: legend_info - ptr to PaneInfo struct for legend pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void legend_catch_all(
     Legend_legend *legend_info)
{
	/* sanity check */
        if (spc_image == NULL)
        {
            kerror(NULL, "legend_hide",
                   "You must display an image w/ a legend before creating a catch-all class!");
	    kinfo(KHOSTILE, "Ever heard the term, 'luser'?  Think about it...");
            return;
        }
	spc_catch_all();
}


/*-----------------------------------------------------------
| 
|  Routine Name: legend_transfer
| 
|       Purpose: Do routine which is called when
|                  pane action button transfer is used
| 
|         Input: legend_info - ptr to PaneInfo struct for legend pane
|        Output: None
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void legend_transfer(
     Legend_legend *legend_info)
{
	/* sanity check */
        if (spc_image == NULL)
        {
            kerror(NULL, "legend_hide",
                   "You must display an image w/ a legend before transferring classes!");
	    kinfo(KHOSTILE, "For goodness sake!  Use your brain!");
            return;
        }
	spc_transfer_classes();
}

