 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane curve
   >>>> 
   >>>>  Private: 
   >>>> 	curve_update_mode
   >>>> 	curve_clear
   >>>> 
   >>>>   Static: 
   >>>> 	clear_curve_plots
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "spectrum.h"

static void clear_curve_plots PROTO(());

/*-----------------------------------------------------------
| 
|  Routine Name: curve_update_mode
| 
|       Purpose: Do routine which is called when
|                  logical selection update_mode is used
| 
|         Input: curve_info - ptr to PaneInfo struct for curve pane
| 
|        Output: None
|    Written By: 
|          Date: Jul 19, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void curve_update_mode(
     Curve_curve *curve_info)
{
	int      i;
	xvobject button;

        if (curve_info->update_mode == SPC_CONTINOUS_SINGLE)
        {
            /*
             * remove the event handlers on the image, zoom, & plot 
	     * which updates the single spectral curve on button press
  	     *
             * add the event handler on the image, zoom, & plot 
	     * which updates the single spectral curve on pointer motion
             */
            if (spc_image != NULL)
            {
                xvw_remove_event(spc_display->workspace, ButtonPressMask,
                                 spc_update_spectral_curve, NULL);
                xvw_remove_event(zoom_workspace, ButtonPressMask,
                                 spc_update_spectral_curve, NULL);
                xvw_remove_event(spc_scatter->area, ButtonPressMask,
                                 spc_update_spectral_curve, NULL);
                xvw_add_event(spc_display->workspace, PointerMotionMask,
                              spc_update_spectral_curve, NULL);
                xvw_add_event(zoom_workspace, PointerMotionMask,
                              spc_update_spectral_curve, NULL);
                xvw_add_event(spc_scatter->area, PointerMotionMask,
                              spc_update_spectral_curve, NULL);

		/*
	         * delete multiple plots (if any)
	         */
	   	clear_curve_plots();

		/*
         	 * create the single plot object
         	 */
        	spc_curve->plot = xvw_create_plot2d(spc_curve->area, "plot");
        	xvw_set_attributes(spc_curve->plot,
               		           XVW_AREA_ATTACH,      spc_curve->axis,
                                   XVW_PLOT2D_PLOTTYPE,  KPLOT2D_LINEPLOT,
                                   NULL);
		spc_curve->plotnum = 1;
            }
	    button = xvf_get_xvobject(curve_info->clear_struct, XVF_BUTTON_OBJ,
				      TRUE);
	    xvw_unmap(button);
        }
        else
        {
            /*
             * remove the event handler on the image, zoom, & plot 
	     * which updates the single spectral curve on pointer motion
  	     *
             * add the event handler on the image, zoom, & & plot 
	     * which updates the single spectral curve on button press
             */
            if (spc_image != NULL)
            {
                xvw_remove_event(spc_display->workspace, PointerMotionMask,
                                 spc_update_spectral_curve, NULL);
                xvw_remove_event(zoom_workspace, PointerMotionMask,
                                 spc_update_spectral_curve, NULL);
                xvw_remove_event(spc_scatter->area, PointerMotionMask,
                                 spc_update_spectral_curve, NULL);
                xvw_add_event(spc_display->workspace, ButtonPressMask,
                              spc_update_spectral_curve, NULL);
                xvw_add_event(zoom_workspace, ButtonPressMask,
                              spc_update_spectral_curve, NULL);
                xvw_add_event(spc_scatter->area, ButtonPressMask,
                              spc_update_spectral_curve, NULL);

		/*
	  	 * destroy the single plot object
	         */
		xvw_destroy(spc_curve->plot);
		spc_curve->plotnum = 0;
            }
	    button = xvf_get_xvobject(curve_info->clear_struct, XVF_BUTTON_OBJ,
				      TRUE);
	    xvw_map(button);
        }


}


/*-----------------------------------------------------------
| 
|  Routine Name: curve_clear
| 
|       Purpose: Do routine which is called when
|                  pane action button clear is used
| 
|         Input: curve_info - ptr to PaneInfo struct for curve pane
| 
|        Output: None
|    Written By: 
|          Date: Jul 19, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void curve_clear(
     Curve_curve *curve_info)
{
	clear_curve_plots();
}


static void clear_curve_plots()
{
	int i;

	if (spc_curve->plots != NULL)
        {
            /*
             * delete multiple plots (if any)
             */
            for (i = 0; i < spc_curve->plotnum; i++)
                xvw_destroy(spc_curve->plots[i]);
            kfree(spc_curve->plots);
	}
        spc_curve->plotnum = 0;
	spc_curve->plots = NULL;
}
