 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane contents
   >>>> 
   >>>>  Private: 
   >>>> 	contents_o
   >>>> 
   >>>>   Static: 
   >>>> 	get_date
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "spectrum.h"

static char *get_date PROTO(());

/*-----------------------------------------------------------
| 
|  Routine Name: contents_o
| 
|       Purpose: Do routine which is called when
|                  output selection o is used
| 
|         Input: contents_info - ptr to PaneInfo struct for contents pane
| 
|        Output: None
|    Written By: 
|          Date: Mar 30, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void contents_o(
     Contents_contents *contents_info)
{
        LegendEntry *legend_ptr;
	char        *contents;
	kfile       *file;
	char        *date;

	if (contents_info->o == NULL)
	{
	    kerror(NULL, "contents_o", 
                   "Please provide the name of an output file!");
	    kinfo(KHOSTILE, "doofus!");

	}
	if ((file = kfopen(contents_info->o, "w")) == NULL)
	{
	    kerror(NULL, "contents_o", 
	           "Unable to open output file %s", contents_info->o);
	    return;
	}

	kfprintf(file, "\n---- Summary of Class Contents ----\n\n");
	if (gui_info->Files->files->in_image != NULL)
	   kfprintf(file, "Input Image:  %s\n",
		    gui_info->Files->files->in_image);
	if (gui_info->Files->files->in_legend != NULL)
	   kfprintf(file, "Input Legend: %s\n", 
		    gui_info->Files->files->in_legend);

	date = get_date();
	if (date != NULL)
	{
	   kfprintf(file, "Date:         %s\n", date);
	   kfree(date);
	}
	
	kfprintf(file, "\n\n");

        legend_ptr = spc_legend_list;
        while (legend_ptr != NULL)
        {
            contents = spc_set_classcontents_label(legend_ptr);
	    kfprintf(file, "%s\n\n", contents);
	    kfree(contents);
            legend_ptr = legend_ptr->next;
        }
	kfclose(file);

	kinfo(KSTANDARD, "Class contents written to ascii file %s", 
	      contents_info->o);
}


/*-----------------------------------------------------------
|
|  Routine Name: get_date
|
|       Purpose: Returns a string containing current date & time
|         Input: None
|        Output: None
|    Written By: Danielle Argiro
|          Date: Mar 30, 1995
| Modifications:
|
------------------------------------------------------------*/

static char *get_date()
{
	char       *date;
        struct tm  *tmval;
        time_t     timeval;
        char       temp[KLENGTH];

        /*
         * Get the date/time
         */
        timeval = time(NULL);
        tmval   = localtime(&timeval);

        /*
         * Compare the new date string with the current one,
         * and if different, then update it...
         */
	temp[0] = '\0';
        if (tmval != NULL)
           kstrftime(temp, KLENGTH, "%h %d, 19%y %H:%M", tmval);

	if (kstrlen(temp) > 0)
	   date = kstrdup(temp);
	else date = NULL;

	return(date);
}
