 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for editimage Form
   >>>> 
   >>>>    Written By: conductor -name editimage -l 3
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 20, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'file' Pane
 */
typedef struct _File_file{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *i;         /* filename for 'i'*/
kform_struct *i_struct;  /* pass to xvf_set_attributes() */
int          i_selected; /* TRUE on <cr> for 'i' */

char         *c;         /* filename for 'c'*/
kform_struct *c_struct;  /* pass to xvf_set_attributes() */
int          c_selected; /* TRUE on <cr> for 'c' */

char         *cmap;         /* filename for 'cmap'*/
kform_struct *cmap_struct;  /* pass to xvf_set_attributes() */
int          cmap_selected; /* TRUE on <cr> for 'cmap' */

int          format;          /* int value of 'format'*/
char         *format_label;   /* label representing int value of 'format'*/
kform_struct *format_struct;  /* pass to xvf_set_attributes() */

char         *o;         /* filename for 'o'*/
kform_struct *o_struct;  /* pass to xvf_set_attributes() */
int          o_selected; /* TRUE on <cr> for 'o' */

char         *out_cmap;         /* filename for 'out_cmap'*/
kform_struct *out_cmap_struct;  /* pass to xvf_set_attributes() */
int          out_cmap_selected; /* TRUE on <cr> for 'out_cmap' */

char         *d;         /* filename for 'd'*/
kform_struct *d_struct;  /* pass to xvf_set_attributes() */
int          d_selected; /* TRUE on <cr> for 'd' */

} File_file;

/*
 * Subform Info Struct for 'File' Subform
 */
typedef struct _editimage_File {

File_file   *file;          /* ptr to Pane Info struct for pane 'file' */
int        file_selected;          /* TRUE if input was from pane 'file' */
kform_struct *file_struct;          /* pass to xvf_set_attributes() */

}  editimage_File;

/*
 * Pane Info Struct for 'capture' Pane
 */
typedef struct _options_capture{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int           all;         /* TRUE if the box for 'all' is ON */
kform_struct *all_struct;  /* pass to xvf_set_attributes() */

int           decor;         /* TRUE if the box for 'decor' is ON */
kform_struct *decor_struct;  /* pass to xvf_set_attributes() */

int           b;         /* TRUE if the box for 'b' is ON */
kform_struct *b_struct;  /* pass to xvf_set_attributes() */

char         *o;         /* filename for 'o'*/
kform_struct *o_struct;  /* pass to xvf_set_attributes() */
int          o_selected; /* TRUE on <cr> for 'o' */

int          capture;          /* TRUE when user clicks on 'capture'*/
kform_struct *capture_struct;  /* pass to xvf_set_attributes() */

int           screen;         /* TRUE if the box for 'screen' is ON */
kform_struct *screen_struct;  /* pass to xvf_set_attributes() */

int           win;         /* TRUE if the box for 'win' is ON */
kform_struct *win_struct;  /* pass to xvf_set_attributes() */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

} options_capture;

/*
 * Pane Info Struct for 'lists' Pane
 */
typedef struct _options_lists{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          image_list;          /* int value of 'image_list'*/
char         *image_list_label;   /* label representing int value of 'image_list'*/
kform_struct *image_list_struct;  /* pass to xvf_set_attributes() */
int          image_list_selected; /* TRUE on <cr> for 'image_list' */

int          band_list;          /* int value of 'band_list'*/
char         *band_list_label;   /* label representing int value of 'band_list'*/
kform_struct *band_list_struct;  /* pass to xvf_set_attributes() */
int          band_list_selected; /* TRUE on <cr> for 'band_list' */

int           elements;         /* TRUE if the box for 'elements' is ON */
kform_struct *elements_struct;  /* pass to xvf_set_attributes() */
int          elements_selected; /* TRUE for value change of 'elements' */


int           depth;         /* TRUE if the box for 'depth' is ON */
kform_struct *depth_struct;  /* pass to xvf_set_attributes() */
int          depth_selected; /* TRUE for value change of 'depth' */


int           time;         /* TRUE if the box for 'time' is ON */
kform_struct *time_struct;  /* pass to xvf_set_attributes() */
int          time_selected; /* TRUE for value change of 'time' */


kform_struct *image_band_label_struct; /* pass to xvf_set_attributes() */

} options_lists;

/*
 * Pane Info Struct for 'display' Pane
 */
typedef struct _options_display{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          norm_type;          /* int value of 'norm_type'*/
char         *norm_type_label;   /* label representing int value of 'norm_type'*/
kform_struct *norm_type_struct;  /* pass to xvf_set_attributes() */
int          norm_type_selected; /* TRUE on <cr> for 'norm_type' */

int          norm_method_val;      /* value of toggle 'norm_method'*/
int          norm_method_num;      /* number of toggle member selected (1-N) */
kform_struct *norm_method_struct;  /* pass to xvf_set_attributes() */
int          norm_method_selected; /* TRUE on <cr> for 'norm_method' */

int          red_mapcol;          /* TRUE when user clicks on 'red_mapcol'*/
kform_struct *red_mapcol_struct;  /* pass to xvf_set_attributes() */

int          green_mapcol;          /* TRUE when user clicks on 'green_mapcol'*/
kform_struct *green_mapcol_struct;  /* pass to xvf_set_attributes() */

int          blue_mapcol;          /* TRUE when user clicks on 'blue_mapcol'*/
kform_struct *blue_mapcol_struct;  /* pass to xvf_set_attributes() */

char         *red_function;         /* string for 'red_function'*/
kform_struct *red_function_struct;  /* pass to xvf_set_attributes() */
int          red_function_selected; /* TRUE on <cr> for 'red_function' */

char         *green_function;         /* string for 'green_function'*/
kform_struct *green_function_struct;  /* pass to xvf_set_attributes() */
int          green_function_selected; /* TRUE on <cr> for 'green_function' */

char         *blue_function;         /* string for 'blue_function'*/
kform_struct *blue_function_struct;  /* pass to xvf_set_attributes() */
int          blue_function_selected; /* TRUE on <cr> for 'blue_function' */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

kform_struct *blank2_struct; /* pass to xvf_set_attributes() */

} options_display;

/*
 * Pane Info Struct for 'comment' Pane
 */
typedef struct _options_comment{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

char         *comment_string;         /* string for 'comment_string'*/
kform_struct *comment_string_struct;  /* pass to xvf_set_attributes() */

int          change_comment;          /* TRUE when user clicks on 'change_comment'*/
kform_struct *change_comment_struct;  /* pass to xvf_set_attributes() */

kform_struct *comment_label_struct; /* pass to xvf_set_attributes() */

} options_comment;

/*
 * Pane Info Struct for 'colormap' Pane
 */
typedef struct _options_colormap{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

xvobject     wksp1;          /* address of workspace 'wksp1'*/
kform_struct *wksp1_struct;  /* pass to xvf_set_attributes() */

xvobject     wksp2;          /* address of workspace 'wksp2'*/
kform_struct *wksp2_struct;  /* pass to xvf_set_attributes() */

kform_struct *b1_struct; /* pass to xvf_set_attributes() */

kform_struct *b2_struct; /* pass to xvf_set_attributes() */

} options_colormap;

/*
 * Pane Info Struct for 'roi' Pane
 */
typedef struct _options_roi{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

char         *o;         /* filename for 'o'*/
kform_struct *o_struct;  /* pass to xvf_set_attributes() */
int          o_selected; /* TRUE on <cr> for 'o' */

int          policy;          /* int value of 'policy'*/
char         *policy_label;   /* label representing int value of 'policy'*/
kform_struct *policy_struct;  /* pass to xvf_set_attributes() */
int          policy_selected; /* TRUE on <cr> for 'policy' */

int          disp;          /* boolean value of 'disp'*/
char         *disp_label;   /* label assoc w/ value of 'disp'*/
kform_struct *disp_struct;  /* pass to xvf_set_attributes() */
int          disp_selected; /* TRUE on <cr> for 'disp' */

int          mult;          /* boolean value of 'mult'*/
char         *mult_label;   /* label assoc w/ value of 'mult'*/
kform_struct *mult_struct;  /* pass to xvf_set_attributes() */
int          mult_selected; /* TRUE on <cr> for 'mult' */

int          pres;          /* int value of 'pres'*/
char         *pres_label;   /* label representing int value of 'pres'*/
kform_struct *pres_struct;  /* pass to xvf_set_attributes() */
int          pres_selected; /* TRUE on <cr> for 'pres' */

int          shape_val;      /* value of toggle 'shape'*/
int          shape_num;      /* number of toggle member selected (1-N) */
kform_struct *shape_struct;  /* pass to xvf_set_attributes() */
int          shape_selected; /* TRUE on <cr> for 'shape' */

int          mode_val;      /* value of toggle 'mode'*/
int          mode_num;      /* number of toggle member selected (1-N) */
kform_struct *mode_struct;  /* pass to xvf_set_attributes() */
int          mode_selected; /* TRUE on <cr> for 'mode' */

int          line_x1;          /* int for 'line_x1'*/
kform_struct *line_x1_struct;  /* pass to xvf_set_attributes() */

int          circle_x;          /* int for 'circle_x'*/
kform_struct *circle_x_struct;  /* pass to xvf_set_attributes() */

int          ellipse_x;          /* int for 'ellipse_x'*/
kform_struct *ellipse_x_struct;  /* pass to xvf_set_attributes() */

int          rect_x;          /* int for 'rect_x'*/
kform_struct *rect_x_struct;  /* pass to xvf_set_attributes() */

int          line_x2;          /* int for 'line_x2'*/
kform_struct *line_x2_struct;  /* pass to xvf_set_attributes() */

int          circle_radius;          /* int for 'circle_radius'*/
kform_struct *circle_radius_struct;  /* pass to xvf_set_attributes() */

int          ellipse_a;          /* int for 'ellipse_a'*/
kform_struct *ellipse_a_struct;  /* pass to xvf_set_attributes() */

int          rect_width;          /* int for 'rect_width'*/
kform_struct *rect_width_struct;  /* pass to xvf_set_attributes() */

int          extract_roi;          /* TRUE when user clicks on 'extract_roi'*/
kform_struct *extract_roi_struct;  /* pass to xvf_set_attributes() */

int          line_y1;          /* int for 'line_y1'*/
kform_struct *line_y1_struct;  /* pass to xvf_set_attributes() */

int          circle_y;          /* int for 'circle_y'*/
kform_struct *circle_y_struct;  /* pass to xvf_set_attributes() */

int          ellipse_y;          /* int for 'ellipse_y'*/
kform_struct *ellipse_y_struct;  /* pass to xvf_set_attributes() */

int          rect_y;          /* int for 'rect_y'*/
kform_struct *rect_y_struct;  /* pass to xvf_set_attributes() */

int          line_y2;          /* int for 'line_y2'*/
kform_struct *line_y2_struct;  /* pass to xvf_set_attributes() */

int          ellipse_b;          /* int for 'ellipse_b'*/
kform_struct *ellipse_b_struct;  /* pass to xvf_set_attributes() */

int          rect_height;          /* int for 'rect_height'*/
kform_struct *rect_height_struct;  /* pass to xvf_set_attributes() */

} options_roi;

/*
 * Pane Info Struct for 'function' Pane
 */
typedef struct _options_function{

int          create;          /* TRUE when user clicks on 'create'*/
kform_struct *create_struct;  /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

char         *expr;         /* string for 'expr'*/
kform_struct *expr_struct;  /* pass to xvf_set_attributes() */

double       wbegin;          /* double value of 'wbegin'*/
kform_struct *wbegin_struct;  /* pass to xvf_set_attributes() */
int          wbegin_optsel;   /* TRUE if optional box of 'wbegin' is ON */

double       wend;          /* double value of 'wend'*/
kform_struct *wend_struct;  /* pass to xvf_set_attributes() */
int          wend_optsel;   /* TRUE if optional box of 'wend' is ON */

int          wsize;          /* int for 'wsize'*/
kform_struct *wsize_struct;  /* pass to xvf_set_attributes() */
int          wsize_optsel;   /* TRUE if optional box of 'wsize' is ON */

double       hbegin;          /* double value of 'hbegin'*/
kform_struct *hbegin_struct;  /* pass to xvf_set_attributes() */
int          hbegin_optsel;   /* TRUE if optional box of 'hbegin' is ON */

double       hend;          /* double value of 'hend'*/
kform_struct *hend_struct;  /* pass to xvf_set_attributes() */
int          hend_optsel;   /* TRUE if optional box of 'hend' is ON */

int          hsize;          /* int for 'hsize'*/
kform_struct *hsize_struct;  /* pass to xvf_set_attributes() */
int          hsize_optsel;   /* TRUE if optional box of 'hsize' is ON */

double       dbegin;          /* double value of 'dbegin'*/
kform_struct *dbegin_struct;  /* pass to xvf_set_attributes() */
int          dbegin_optsel;   /* TRUE if optional box of 'dbegin' is ON */

double       dend;          /* double value of 'dend'*/
kform_struct *dend_struct;  /* pass to xvf_set_attributes() */
int          dend_optsel;   /* TRUE if optional box of 'dend' is ON */

int          dsize;          /* int for 'dsize'*/
kform_struct *dsize_struct;  /* pass to xvf_set_attributes() */
int          dsize_optsel;   /* TRUE if optional box of 'dsize' is ON */

double       tbegin;          /* double value of 'tbegin'*/
kform_struct *tbegin_struct;  /* pass to xvf_set_attributes() */
int          tbegin_optsel;   /* TRUE if optional box of 'tbegin' is ON */

double       tend;          /* double value of 'tend'*/
kform_struct *tend_struct;  /* pass to xvf_set_attributes() */
int          tend_optsel;   /* TRUE if optional box of 'tend' is ON */

int          tsize;          /* int for 'tsize'*/
kform_struct *tsize_struct;  /* pass to xvf_set_attributes() */
int          tsize_optsel;   /* TRUE if optional box of 'tsize' is ON */

double       ebegin;          /* double value of 'ebegin'*/
kform_struct *ebegin_struct;  /* pass to xvf_set_attributes() */
int          ebegin_optsel;   /* TRUE if optional box of 'ebegin' is ON */

double       eend;          /* double value of 'eend'*/
kform_struct *eend_struct;  /* pass to xvf_set_attributes() */
int          eend_optsel;   /* TRUE if optional box of 'eend' is ON */

int          esize;          /* int for 'esize'*/
kform_struct *esize_struct;  /* pass to xvf_set_attributes() */
int          esize_optsel;   /* TRUE if optional box of 'esize' is ON */

int          type;          /* int value of 'type'*/
char         *type_label;   /* label representing int value of 'type'*/
kform_struct *type_struct;  /* pass to xvf_set_attributes() */
int          type_optsel;   /* TRUE if optional box of 'type' is ON */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

kform_struct *blank2_struct; /* pass to xvf_set_attributes() */

kform_struct *blank3_struct; /* pass to xvf_set_attributes() */

kform_struct *blank4_struct; /* pass to xvf_set_attributes() */

kform_struct *blank5_struct; /* pass to xvf_set_attributes() */

} options_function;

/*
 * Subform Info Struct for 'options' Subform
 */
typedef struct _editimage_options {

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

options_capture  *capture;          /* ptr to Pane Info struct for pane 'capture' */
int             capture_selected;          /* TRUE if input was from pane 'capture' */
kform_struct    *capture_struct;          /* pass to xvf_set_attributes() */

options_lists  *lists;          /* ptr to Pane Info struct for pane 'lists' */
int           lists_selected;          /* TRUE if input was from pane 'lists' */
kform_struct  *lists_struct;          /* pass to xvf_set_attributes() */

options_display  *display;          /* ptr to Pane Info struct for pane 'display' */
int             display_selected;          /* TRUE if input was from pane 'display' */
kform_struct    *display_struct;          /* pass to xvf_set_attributes() */

options_comment  *comment;          /* ptr to Pane Info struct for pane 'comment' */
int             comment_selected;          /* TRUE if input was from pane 'comment' */
kform_struct    *comment_struct;          /* pass to xvf_set_attributes() */

options_colormap  *colormap;          /* ptr to Pane Info struct for pane 'colormap' */
int              colormap_selected;          /* TRUE if input was from pane 'colormap' */
kform_struct     *colormap_struct;          /* pass to xvf_set_attributes() */

options_roi  *roi;          /* ptr to Pane Info struct for pane 'roi' */
int         roi_selected;          /* TRUE if input was from pane 'roi' */
kform_struct *roi_struct;          /* pass to xvf_set_attributes() */

options_function  *function;          /* ptr to Pane Info struct for pane 'function' */
int              function_selected;          /* TRUE if input was from pane 'function' */
kform_struct     *function_struct;          /* pass to xvf_set_attributes() */

}  editimage_options;

/*
 * Pane Info Struct for 'zoom' Pane
 */
typedef struct _Zoom_zoom{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

float        zoomfactor;          /* float value of 'zoomfactor'*/
kform_struct *zoomfactor_struct;  /* pass to xvf_set_attributes() */
int          zoomfactor_selected; /* TRUE on <cr> for 'zoomfactor' */

int          update_mode;          /* boolean value of 'update_mode'*/
char         *update_mode_label;   /* label assoc w/ value of 'update_mode'*/
kform_struct *update_mode_struct;  /* pass to xvf_set_attributes() */
int          update_mode_selected; /* TRUE on <cr> for 'update_mode' */

xvobject     zoom_object;          /* address of workspace 'zoom_object'*/
kform_struct *zoom_object_struct;  /* pass to xvf_set_attributes() */

} Zoom_zoom;

/*
 * Subform Info Struct for 'Zoom' Subform
 */
typedef struct _editimage_Zoom {

Zoom_zoom   *zoom;          /* ptr to Pane Info struct for pane 'zoom' */
int        zoom_selected;          /* TRUE if input was from pane 'zoom' */
kform_struct *zoom_struct;          /* pass to xvf_set_attributes() */

}  editimage_Zoom;

/*
 * Pane Info Struct for 'pixel' Pane
 */
typedef struct _Pixel_pixel{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          update_mode;          /* boolean value of 'update_mode'*/
char         *update_mode_label;   /* label assoc w/ value of 'update_mode'*/
kform_struct *update_mode_struct;  /* pass to xvf_set_attributes() */
int          update_mode_selected; /* TRUE on <cr> for 'update_mode' */

xvobject     pixel_object;          /* address of workspace 'pixel_object'*/
kform_struct *pixel_object_struct;  /* pass to xvf_set_attributes() */

} Pixel_pixel;

/*
 * Subform Info Struct for 'Pixel' Subform
 */
typedef struct _editimage_Pixel {

Pixel_pixel  *pixel;          /* ptr to Pane Info struct for pane 'pixel' */
int         pixel_selected;          /* TRUE if input was from pane 'pixel' */
kform_struct *pixel_struct;          /* pass to xvf_set_attributes() */

}  editimage_Pixel;

/*
 * Pane Info Struct for 'mapvals' Pane
 */
typedef struct _MapValues_mapvals{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          update_mode;          /* boolean value of 'update_mode'*/
char         *update_mode_label;   /* label assoc w/ value of 'update_mode'*/
kform_struct *update_mode_struct;  /* pass to xvf_set_attributes() */
int          update_mode_selected; /* TRUE on <cr> for 'update_mode' */

int          policy;          /* int value of 'policy'*/
char         *policy_label;   /* label representing int value of 'policy'*/
kform_struct *policy_struct;  /* pass to xvf_set_attributes() */
int          policy_selected; /* TRUE on <cr> for 'policy' */

int          display_width;          /* int for 'display_width'*/
kform_struct *display_width_struct;  /* pass to xvf_set_attributes() */
int          display_width_selected; /* TRUE on <cr> for 'display_width' */

int          display_height;          /* int for 'display_height'*/
kform_struct *display_height_struct;  /* pass to xvf_set_attributes() */
int          display_height_selected; /* TRUE on <cr> for 'display_height' */

xvobject     mapval_object;          /* address of workspace 'mapval_object'*/
kform_struct *mapval_object_struct;  /* pass to xvf_set_attributes() */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

} MapValues_mapvals;

/*
 * Subform Info Struct for 'MapValues' Subform
 */
typedef struct _editimage_MapValues {

MapValues_mapvals  *mapvals;          /* ptr to Pane Info struct for pane 'mapvals' */
int               mapvals_selected;          /* TRUE if input was from pane 'mapvals' */
kform_struct      *mapvals_struct;          /* pass to xvf_set_attributes() */

}  editimage_MapValues;

/*
 * Pane Info Struct for 'pseudo' Pane
 */
typedef struct _Pseudo_pseudo{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          palette_type_val;      /* value of toggle 'palette_type'*/
int          palette_type_num;      /* number of toggle member selected (1-N) */
kform_struct *palette_type_struct;  /* pass to xvf_set_attributes() */
int          palette_type_selected; /* TRUE on <cr> for 'palette_type' */

xvobject     pseudo_object;          /* address of workspace 'pseudo_object'*/
kform_struct *pseudo_object_struct;  /* pass to xvf_set_attributes() */

} Pseudo_pseudo;

/*
 * Subform Info Struct for 'Pseudo' Subform
 */
typedef struct _editimage_Pseudo {

Pseudo_pseudo  *pseudo;          /* ptr to Pane Info struct for pane 'pseudo' */
int           pseudo_selected;          /* TRUE if input was from pane 'pseudo' */
kform_struct  *pseudo_struct;          /* pass to xvf_set_attributes() */

}  editimage_Pseudo;

/*
 * Pane Info Struct for 'thresh' Pane
 */
typedef struct _Thresh_thresh{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          thresholding_val;      /* value of toggle 'thresholding'*/
int          thresholding_num;      /* number of toggle member selected (1-N) */
kform_struct *thresholding_struct;  /* pass to xvf_set_attributes() */
int          thresholding_selected; /* TRUE on <cr> for 'thresholding' */

int          accept;          /* boolean value of 'accept'*/
char         *accept_label;   /* label assoc w/ value of 'accept'*/
kform_struct *accept_struct;  /* pass to xvf_set_attributes() */
int          accept_selected; /* TRUE on <cr> for 'accept' */

int          invert;          /* boolean value of 'invert'*/
char         *invert_label;   /* label assoc w/ value of 'invert'*/
kform_struct *invert_struct;  /* pass to xvf_set_attributes() */
int          invert_selected; /* TRUE on <cr> for 'invert' */

xvobject     thresh_object;          /* address of workspace 'thresh_object'*/
kform_struct *thresh_object_struct;  /* pass to xvf_set_attributes() */

} Thresh_thresh;

/*
 * Subform Info Struct for 'Thresh' Subform
 */
typedef struct _editimage_Thresh {

Thresh_thresh  *thresh;          /* ptr to Pane Info struct for pane 'thresh' */
int           thresh_selected;          /* TRUE if input was from pane 'thresh' */
kform_struct  *thresh_struct;          /* pass to xvf_set_attributes() */

}  editimage_Thresh;

/*
 * Form Info Struct for 'editimage' form
 */
typedef struct _gui_info_struct {

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

xvobject     workspace;          /* address of workspace 'workspace'*/
kform_struct *workspace_struct;  /* pass to xvf_set_attributes() */

kform_struct *b0_struct; /* pass to xvf_set_attributes() */

editimage_File  *File;
int File_selected;
kform_struct *File_struct;

editimage_options  *options;
int options_selected;
kform_struct *options_struct;

editimage_Zoom  *Zoom;
int Zoom_selected;
kform_struct *Zoom_struct;

editimage_Pixel  *Pixel;
int Pixel_selected;
kform_struct *Pixel_struct;

editimage_MapValues  *MapValues;
int MapValues_selected;
kform_struct *MapValues_struct;

editimage_Pseudo  *Pseudo;
int Pseudo_selected;
kform_struct *Pseudo_struct;

editimage_Thresh  *Thresh;
int Thresh_selected;
kform_struct *Thresh_struct;


kform_struct *editimage_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void _xvf_free_editimage PROTO((gui_info_struct *));
void _xvf_get_editimage  PROTO((gui_info_struct *));

int  _xvf_init_editimage PROTO((kform *, gui_info_struct *));
void run_editimage       PROTO((kform *, ksubform *, kaddr));

void run_File      PROTO((editimage_File *));
void _xvf_get_File PROTO((editimage_File *));

void run_file      PROTO((File_file *));
void _xvf_get_file PROTO((File_file *));
void file_i	PROTO((File_file *));
void file_c	PROTO((File_file *));
void file_cmap	PROTO((File_file *));
void file_o	PROTO((File_file *));
void file_out_cmap	PROTO((File_file *));
void file_d	PROTO((File_file *));

void run_options      PROTO((editimage_options *));
void _xvf_get_options PROTO((editimage_options *));

void run_capture      PROTO((options_capture *));
void _xvf_get_capture PROTO((options_capture *));
void capture_o	PROTO((options_capture *));
void capture_capture	PROTO((options_capture *));

void run_lists      PROTO((options_lists *));
void _xvf_get_lists PROTO((options_lists *));
void lists_image_list	PROTO((options_lists *));
void lists_band_list	PROTO((options_lists *));
void lists_elements	PROTO((options_lists *));
void lists_depth	PROTO((options_lists *));
void lists_time	PROTO((options_lists *));

void run_display      PROTO((options_display *));
void _xvf_get_display PROTO((options_display *));
void display_norm_type	PROTO((options_display *));
void display_norm_method	PROTO((options_display *));
void display_red_mapcol	PROTO((options_display *));
void display_green_mapcol	PROTO((options_display *));
void display_blue_mapcol	PROTO((options_display *));
void display_red_function	PROTO((options_display *));
void display_green_function	PROTO((options_display *));
void display_blue_function	PROTO((options_display *));

void run_comment      PROTO((options_comment *));
void _xvf_get_comment PROTO((options_comment *));
void comment_change_comment	PROTO((options_comment *));

void run_colormap      PROTO((options_colormap *));
void _xvf_get_colormap PROTO((options_colormap *));

void run_roi      PROTO((options_roi *));
void _xvf_get_roi PROTO((options_roi *));
void roi_o	PROTO((options_roi *));
void roi_policy	PROTO((options_roi *));
void roi_disp	PROTO((options_roi *));
void roi_mult	PROTO((options_roi *));
void roi_pres	PROTO((options_roi *));
void roi_shape	PROTO((options_roi *));
void roi_mode	PROTO((options_roi *));
void roi_extract_roi	PROTO((options_roi *));

void run_function      PROTO((options_function *));
void _xvf_get_function PROTO((options_function *));
void function_create	PROTO((options_function *));

void run_Zoom      PROTO((editimage_Zoom *));
void _xvf_get_Zoom PROTO((editimage_Zoom *));

void run_zoom      PROTO((Zoom_zoom *));
void _xvf_get_zoom PROTO((Zoom_zoom *));
void zoom_zoomfactor	PROTO((Zoom_zoom *));
void zoom_update_mode	PROTO((Zoom_zoom *));

void run_Pixel      PROTO((editimage_Pixel *));
void _xvf_get_Pixel PROTO((editimage_Pixel *));

void run_pixel      PROTO((Pixel_pixel *));
void _xvf_get_pixel PROTO((Pixel_pixel *));
void pixel_update_mode	PROTO((Pixel_pixel *));

void run_MapValues      PROTO((editimage_MapValues *));
void _xvf_get_MapValues PROTO((editimage_MapValues *));

void run_mapvals      PROTO((MapValues_mapvals *));
void _xvf_get_mapvals PROTO((MapValues_mapvals *));
void mapvals_update_mode	PROTO((MapValues_mapvals *));
void mapvals_policy	PROTO((MapValues_mapvals *));
void mapvals_display_width	PROTO((MapValues_mapvals *));
void mapvals_display_height	PROTO((MapValues_mapvals *));

void run_Pseudo      PROTO((editimage_Pseudo *));
void _xvf_get_Pseudo PROTO((editimage_Pseudo *));

void run_pseudo      PROTO((Pseudo_pseudo *));
void _xvf_get_pseudo PROTO((Pseudo_pseudo *));
void pseudo_palette_type	PROTO((Pseudo_pseudo *));

void run_Thresh      PROTO((editimage_Thresh *));
void _xvf_get_Thresh PROTO((editimage_Thresh *));

void run_thresh      PROTO((Thresh_thresh *));
void _xvf_get_thresh PROTO((Thresh_thresh *));
void thresh_thresholding	PROTO((Thresh_thresh *));
void thresh_accept	PROTO((Thresh_thresh *));
void thresh_invert	PROTO((Thresh_thresh *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
