 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for editimage
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "editimage.h"

clui_info_struct *clui_info = NULL;

gui_info_struct *gui_info;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Interactive Image Display and Manipulation
|
|       Purpose: main program for editimage
|
|         Input:
|		char *clui_info->i_file; {input image filename}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->c_file; {input clip mask filename}
|		int   clui_info->c_flag; {TRUE if -c specified}
|
|		char *clui_info->cmap_file; {input alternate colormap file}
|		int   clui_info->cmap_flag; {TRUE if -cmap specified}
|
|		int clui_info->use_cmap_logic; {use colormap?}
|		int clui_info->use_cmap_flag; {TRUE if -use_cmap specified}
|
|		int clui_info->x_int; {x location for GUI autoplacement}
|		int clui_info->x_flag; {TRUE if -x specified}
|
|		int clui_info->y_int; {y location for GUI autoplacement}
|		int clui_info->y_flag; {TRUE if -y specified}
|
|		float clui_info->zoom_float; {initial zoom factor}
|		int   clui_info->zoom_flag; {TRUE if -zoom specified}
|
|		float clui_info->update_float; {initial update time}
|		int   clui_info->update_flag; {TRUE if -update specified}
|
|		int   clui_info->visual_cycle; {Read Only or Read Write Visual}
|		char *clui_info->visual_label;
|		int   clui_info->visual_flag; {TRUE if -visual specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *form;            /* form tree representing *.form file */
	char   *form_filestring; /* *.form file for editimage    */ 
	char   *form_pathname;   /* location of editimage.form   */
	char   *form_fullpath;   /* expanded editimage.form path */
	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "ENVISION");
	kexit_handler(editimage_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_XVROUTINE, "ENVISION", "editimage",
		editimage_usage_additions);

	editimage_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

	/*
	 * Set location of editimage.form
	 */
	if (clui_info->form_flag)
	{
	    form_filestring = kstrdup(clui_info->form_file);
	    form_pathname   = NULL;
	}
	else
	{
	    form_filestring = kstrdup("editimage.form");
	    form_pathname   = kstrdup("$TOOLBOX/objects/xvroutine/editimage/uis");
	}
	form_fullpath   = kfullpath(form_filestring, form_pathname, NULL);

	/*
	 * Allocate the GUI Info structure 
	 */
	gui_info = (gui_info_struct *)
				kcalloc (1, sizeof (gui_info_struct));
	/*
	 * Create the forms for editimage 
	 */
	form = xvf_create_form(form_fullpath, NONE, run_editimage, gui_info,
				clui_info->x_int, clui_info->y_int,
				XVF_PARTIAL_EDIT);
	if (form == NULL)
	   kexit(KEXIT_FAILURE);

	/*
	 * Initialize the GUI Info structure 
	 */
	if (!(_xvf_init_editimage(form, gui_info)))
	    kexit(KEXIT_FAILURE);

/* -main_before_lib_call */
	/*
	 *  Create the various editimage displays
	 */
	edimg_create_image();
	edimg_create_panicon();
	edimg_create_position();
	edimg_create_printpixel();
	edimg_create_printmapval();
	edimg_create_zoom();
	edimg_create_pseudo();
	edimg_create_threshold();

	/*
	 *  Start up, given values provided on command line
	 */
	edimg_startup_from_clui();
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */

	kfree(form_filestring);
	kfree(form_pathname);
	kfree(form_fullpath);

	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: editimage_usage_additions
| 
|       Purpose: Prints usage additions in editimage_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname editimage
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void editimage_usage_additions(void)
{
	kfprintf(kstderr, "\tInteractive Image Display and Manipulation\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: editimage_free_args
| 
|       Purpose: Frees CLUI struct allocated in editimage_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname editimage
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
editimage_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
		kfree(clui_info->form_file);
	kfree(clui_info->i_file);
	kfree(clui_info->c_file);
	kfree(clui_info->cmap_file);
	kfree(clui_info->visual_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
