 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane roi
   >>>> 
   >>>>  Private: 
   >>>> 	roi_o
   >>>> 	roi_shape
   >>>> 	roi_extract_roi
   >>>> 	roi_insert_roi
   >>>> 	roi_policy
   >>>> 	roi_mult
   >>>> 	roi_disp
   >>>> 	roi_mode
   >>>> 	roi_pres
   >>>> 
   >>>> 	extract_roi
   >>>> 	display_extracted_roi
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "editimage.h"

static kobject extract_roi           PROTO((options_roi *));
static void    display_extracted_roi PROTO((kobject, int));

/*-----------------------------------------------------------
|
|  Routine Name: roi_o
|
|       Purpose: Do routine which is called when
|                  output selection o is used
|
|         Input: roi_info - ptr to PaneInfo struct for roi pane
|
|        Output: None
|    Written By:
|          Date: Jan 13, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void roi_o(
     options_roi *roi_info)
{
	roi_extract_roi(roi_info);
}

/*-----------------------------------------------------------
| 
|  Routine Name: roi_shape
| 
|       Purpose: Do routine which is called when
|                  toggle selection shape is used
| 
|         Input: roi_info - ptr to PaneInfo struct for roi pane
| 
|        Output: None
|    Written By: 
|          Date: Dec 16, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void roi_shape(
     options_roi *roi_info)
{
	xvw_set_attribute(image, XVW_IMAGE_ROI_SHAPE, roi_info->shape_val);

	adjust_gui_from_roi_shape();
}


/*-----------------------------------------------------------
| 
|  Routine Name: roi_extract_roi
| 
|       Purpose: Do routine which is called when
|                  output selection extract is used
| 
|         Input: roi_info - ptr to PaneInfo struct for roi pane
| 
|        Output: None
|    Written By: 
|          Date: Dec 16, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void roi_extract_roi(
     options_roi *roi_info)
{
	kobject  out_object, roi_object;
	xvobject axis;

        /*
         *  open an output object for writing
         */
        out_object = kpds_open_object(roi_info->o, KOBJ_WRITE);
	if (out_object == NULL)
            return;

        /*
         *  set output file format
         */
        kpds_set_attribute(out_object, KPDS_FORMAT, 
			   gui_info->File->file->format_label);


	/*
	 * extract ROI using mouse (interactive) or keyboard (noninteractive)
	 */
	roi_object = extract_roi(roi_info);
	if (roi_object == NULL) return;

        /*
         *  copy the attributes & the data of the ROI to the output object
         */
        kdms_copy_object(roi_object, out_object, TRUE, TRUE);

        /*
         *  go ahead and add the extracted ROI file to our image list
         */
        images = (kobject *) karray_add((char **) images, roi_object,
                                        numimages++);
        edimg_update_image_list(numimages-1);

        /*
         *  we'll be displaying extracted ROI, but have not yet created
         *  the toplevel ROI display object.
         */
        if ((roi_info->disp) && (disp_roi == NULL))
        {
           /*
            *  create manager to be the parent to display extracted ROI
            */
            disp_roi = xvw_create_manager(NULL, "disp_roi");

           /*
            *  for ROI shape of signal, want an area, axis, & plot object
            */
            disp_area = xvw_create_area(disp_roi, "disp_area");
            xvw_set_attributes(disp_area,
                XVW_WIDTH,  350,
                XVW_HEIGHT, 350,
                XVW_GRAPHICS_VIEWPORT_MIN_X, 0.2,
                XVW_GRAPHICS_VIEWPORT_MIN_Y, 0.2,
                XVW_GRAPHICS_VIEWPORT_MAX_X, 0.9,
                XVW_GRAPHICS_VIEWPORT_MAX_Y, 0.9,
                NULL);

            /*
             * for all other ROI shapes, want an image object
             */
            disp_image = xvw_create_image(disp_roi, "disp_image");
        }

	/*
	 *  Display the extracted ROI as a signal, image, or surface,
	 *  depending on the ROI presentation specified.
	 */
        if (disp_roi != NULL)
	    display_extracted_roi(roi_object, roi_info->pres);

        /*
         *  that's all... close the output object & temp ROI object
         */
        kpds_close_object(out_object);

	if (!disp_roi)
            kinfo(KSTANDARD, "Done extracting ROI to output file '%s'",
                  roi_info->extract_roi);

}


/*-----------------------------------------------------------
| 
|  Routine Name: roi_insert_roi
| 
|       Purpose: Do routine which is called when
|                  input selection insert is used
| 
|         Input: roi_info - ptr to PaneInfo struct for roi pane
| 
|        Output: None
|    Written By: 
|          Date: Dec 16, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void roi_insert_roi(
     options_roi *roi_info)
{
	/* PUT YOUR CODE HERE ! */
}


/*-----------------------------------------------------------
| 
|  Routine Name: roi_policy
| 
|       Purpose: Do routine which is called when
|                  list selection policy is used
| 
|         Input: roi_info - ptr to PaneInfo struct for roi pane
| 
|        Output: None
|    Written By: 
|          Date: Jan 04, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void roi_policy(
     options_roi *roi_info)
{
	if ((roi_info->policy == KIMAGE_ROI_OUTSIDE) &&
	    (roi_info->pres == KIMAGE_ROI_SURFACE))
	{
	    kerror(NULL, "roi_policy", "It doesn't make sense to set ROI policy to 'Outside Shape' when the ROI Presentation type is 'Surface'; resetting ROI policy to 'Inside Shape'");
            xvf_set_attribute(roi_info->policy_struct, XVF_LIST_VAL, 
			      KIMAGE_ROI_INSIDE); 
	    roi_info->policy = KIMAGE_ROI_INSIDE;
            return;
        }
	else xvw_set_attribute(image, XVW_IMAGE_ROI_POLICY, roi_info->policy);
}


/*-----------------------------------------------------------
| 
|  Routine Name: roi_mult
| 
|       Purpose: Do routine which is called when
|                  logical selection mult is used
| 
|         Input: roi_info - ptr to PaneInfo struct for roi pane
| 
|        Output: None
|    Written By: 
|          Date: Jan 04, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void roi_mult(
     options_roi *roi_info)
{
	/* 
	 * it doesn't make sense to extract multiple images w/ signal
	 * or surface presentation 
	 */
        if ((roi_info->pres != KIMAGE_ROI_IMAGE) &&
            (roi_info->mult == TRUE))
        {
            kerror(NULL, "roi_mult", "Cannot extract multiple images when ROI presentation type is not set to 'Image'");
            xvf_set_attribute(roi_info->mult_struct, XVF_LOGIC_VAL, FALSE);
            roi_info->mult = FALSE;
	    return;
        }
	xvw_set_attribute(image, XVW_IMAGE_ROI_MULTIPLE, roi_info->mult);
	if (roi_info->mult)
	{
	    xvf_set_attribute(roi_info->mode_struct, XVF_TOGGLE_NUM, 1);
	    roi_info->mode_val =  roi_info->mode_num = EXTRACT_W_MOUSE;
            xvf_set_attribute(roi_info->mode_struct->Selptr->toggle_next->next->back_kformstruct,
                             XVF_ACTIVATE, FALSE);
        }
        else
        {
            xvf_set_attribute(roi_info->mode_struct->Selptr->toggle_next->next->back_kformstruct,
                             XVF_ACTIVATE, TRUE);
        }

	adjust_gui_from_roi_mode();
}

/*-----------------------------------------------------------
|
|  Routine Name: roi_disp
|
|       Purpose: Do routine which is called when
|                  logical selection disp is used
|
|         Input: roi_info - ptr to PaneInfo struct for roi pane
|
|        Output: None
|    Written By:
|          Date: Jan 04, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void roi_disp(
     options_roi *roi_info)
{
        if (disp_roi == NULL)
           return;

        /*
         * unmap/map toplevel according to if the user wants the toplevel
         * displayed
         */
        if (!roi_info->disp)
            xvw_unmap(xvw_toplevel(disp_roi));
        else
            xvw_map(xvw_toplevel(disp_roi));
}


/*-----------------------------------------------------------
| 
|  Routine Name: roi_mode
| 
|       Purpose: Do routine which is called when
|                  toggle selection mode is used
| 
|         Input: roi_info - ptr to PaneInfo struct for roi pane
| 
|        Output: None
|    Written By: 
|          Date: Jan 05, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void roi_mode(
     options_roi *roi_info)
{
	adjust_gui_from_roi_mode();
}

/*-----------------------------------------------------------
| 
|  Routine Name: roi_pres
| 
|       Purpose: Do routine which is called when
|                  list selection pres is used
| 
|         Input: roi_info - ptr to PaneInfo struct for roi pane
| 
|        Output: None
|    Written By: 
|          Date: Jan 05, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void roi_pres(
     options_roi *roi_info)
{
	/* 
	 * it doesn't make sense to display signal or surface
	 * if extracting multiple images
	 */
        if ((roi_info->pres != KIMAGE_ROI_IMAGE) &&
            (roi_info->mult == TRUE))
        {
            kerror(NULL, "roi_pres", "Cannot set ROI presentation type to 'Signal' or 'Surface' unless 'Extract Multiple ROIs' is set to 'FALSE'");
            xvf_set_attribute(roi_info->pres_struct, XVF_LIST_VAL,
                              KIMAGE_ROI_IMAGE);
            roi_info->pres = KIMAGE_ROI_IMAGE;
        }

	/*
	 * doesn't make sense to display surface if extracting outside image
	 */
	if ((roi_info->pres != KIMAGE_ROI_IMAGE) &&
            (roi_info->policy == KIMAGE_ROI_OUTSIDE))
        {
            kerror(NULL, "roi_pres", "Cannot set ROI presentation type to 'Signal' or 'Surface' unless 'ROI Policy' is set to 'Inside Shape' or 'Shape Outline'");
            xvf_set_attribute(roi_info->pres_struct, XVF_LIST_VAL,
                              KIMAGE_ROI_IMAGE);
            roi_info->pres = KIMAGE_ROI_IMAGE;
        }
        else xvw_set_attribute(image, XVW_IMAGE_ROI_PRESENTATION, 
				roi_info->pres);
}


/*-----------------------------------------------------------
|
|  Routine Name: extract_roi
|
|       Purpose: Does interactive (mouse) ROI extraction or
|                non-interactive (keyboard) ROI extraction.
|                When ROI extraction is done interactively with the 
|                mouse, xvw_get_attribute() is used; when ROI 
|                extraction is done non-interactively with the 
|                keyboard, xvw_getroi_xxx() is used.  REMEMBER
|                that this routine is duplicated in extractor.
|
|         Input: roi_info - ptr to PaneInfo struct for roi pane
|
|        Output: None
|    Written By: Danielle Argiro
|          Date: Jan 05, 1995
| Modifications:
|
------------------------------------------------------------*/
static kobject extract_roi(
    options_roi *roi_info)
{
	kobject roi_object;

        /*
         * Insertion/Extraction Mode set to Mouse Specification (interactive)
         * simply set the XVW_IMAGE_ROI attribute on the image object
         */
        if (roi_info->mode_val == EXTRACT_W_MOUSE)
        {
            /*
             *  let image object do the interactive ROI extraction,
             *  it'll pass back a temp kobject.
             */
            xvw_get_attribute(image, XVW_IMAGE_ROI, &roi_object);
        }
        /*
         * Insertion/Extraction Mode set to Keybd Specification (noninteractive)
         * have to call the appropriate getroi() routine w/ specified dimensions
         */
        else
        {
            /* keyboard extraction of a rectangle */
            if (roi_info->shape_val == KIMAGE_ROI_RECTANGLE)
            {
                roi_object = xvw_getroi_rectangle(image, NULL,
                                roi_info->rect_x, roi_info->rect_y,
                                roi_info->rect_width, roi_info->rect_height);
            }

            else if ((roi_info->shape_val == KIMAGE_ROI_POLYLINE) ||
                    (roi_info->shape_val == KIMAGE_ROI_FREEHAND))
            {
                kerror(NULL, "roi_extract_roi",
                       "Sorry, but keyboard (noninteractive) extraction of polyline and freehand ROIs are not supported");
                return(NULL);
            }

            /* keyboard extraction of a line */
            else if (roi_info->shape_val == KIMAGE_ROI_LINE)
            {
                roi_object = xvw_getroi_line(image, NULL,
                                roi_info->line_x1, roi_info->line_y1,
                                roi_info->line_x2, roi_info->line_y2);
            }

            else if (roi_info->shape_val == KIMAGE_ROI_CIRCLE)
            {
                roi_object = xvw_getroi_circle(image, NULL,
                                roi_info->circle_x, roi_info->circle_y,
                                roi_info->circle_radius);
            }
            else if (roi_info->shape_val == KIMAGE_ROI_ELLIPSE)
            {
                roi_object = xvw_getroi_ellipse(image, NULL,
                                roi_info->ellipse_x, roi_info->ellipse_y,
                                roi_info->ellipse_a, roi_info->ellipse_b);
            }
        }
	return(roi_object);
}

/*-----------------------------------------------------------
|
|  Routine Name: display_extracted_roi
|
|       Purpose: Displays the extracted ROI depending on whether 
|                the ROI Presentation is set to signal, image, or surface.
|                REMEMBER that this routine is replicated both in extractor
|                and in editimage.
|
|         Input: roi_object - The kobject associated w/ extracted roi
|		 pres       - KIMAGE_ROI_SIGNAL, 
|                             KIMAGE_ROI_IMAGE or 
|                             KIMAGE_ROI_SURFACE
|        Output:
|       Returns:
|    Written By: Danielle Argiro
|          Date: Jan 06, 1995
| Modifications:
|
------------------------------------------------------------*/

static void display_extracted_roi(
    kobject roi_object,
    int     pres)
{
	/* display extracted ROI in 2D plot object */
        if (pres == KIMAGE_ROI_SIGNAL)
        {
	    xvw_unmanage(disp_image);
            xvw_manage(disp_area);
            if (disp_plot3d != NULL)
            {
		xvw_destroy(disp_plot3d);
                disp_plot3d = NULL;
            }
            if (disp_axis2d == NULL)
            {
                disp_axis2d = xvw_create_axis2d(disp_area, "disp_axis2d");
                xvw_set_attribute(disp_axis2d, XVW_AREA_ATTACH, disp_axis2d);
                disp_plot2d = xvw_create_plot2d(disp_area, "disp_plot2d");
                xvw_set_attribute(disp_plot2d, XVW_AREA_ATTACH, disp_axis2d);
            }
            xvw_set_attribute(disp_plot2d, XVW_PLOT2D_PLOTOBJ, roi_object);
	    xvw_set_attribute(disp_area, XVW_AREA_TITLE_STRING, "Signal");
        }

        /* display extracted ROI in image object */
        else if (pres == KIMAGE_ROI_IMAGE)
        {
            xvw_unmanage(disp_area);
            xvw_manage(disp_image);
            if (disp_axis2d != NULL)
            {
                xvw_destroy(disp_axis2d);
                xvw_destroy(disp_plot2d);
                disp_axis2d = NULL;
                disp_plot2d = NULL;
            }
            if (disp_plot3d != NULL)
            {
                xvw_destroy(disp_plot3d);
                disp_plot3d = NULL;
            }
            xvw_set_attribute(disp_image, XVW_IMAGE_IMAGEOBJ, roi_object);
	}

        /* display extracted ROI in 3D plot object */
        else if (pres == KIMAGE_ROI_SURFACE)
        {
	    xvw_unmanage(disp_image);
            xvw_manage(disp_area);
            if (disp_axis2d != NULL)
            {
		xvw_destroy(disp_axis2d);
                xvw_destroy(disp_plot2d);
                disp_axis2d = NULL;
                disp_plot2d = NULL;
            }
            if (disp_plot3d == NULL)
            {
                disp_plot3d = xvw_create_plot3d(disp_area, "disp_plot3d");
                xvw_set_attributes(disp_plot3d,
                                   XVW_PLOT3D_PLOTOBJ,  roi_object,
                                   XVW_PLOT3D_PLOTTYPE, KPLOT3D_MESH,
                                   NULL);
            }
            else xvw_set_attribute(disp_plot3d, XVW_PLOT3D_PLOTOBJ,
                                   roi_object);
	    xvw_set_attribute(disp_area, XVW_AREA_TITLE_STRING, "Surface");
        }

	else 
	{
	    kerror(NULL, "display_extracted_roi",
		   "Unexpected presentation type!");
	}
}
