 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Utilities for Animate
   >>>> 
   >>>>  Private: 
   >>>>			startup_from_clui()
   >>>>			update_framenum()
   >>>>			init_colormap_display()
   >>>>   Static: 
   >>>>         autocolor_list_cb
   >>>>         operation_list_cb
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "animate.h"

static void autocolor_list_cb PROTO((xvobject, kaddr, kaddr));
static void operation_list_cb PROTO((xvobject, kaddr, kaddr));


/*-----------------------------------------------------------
|
|  Routine Name: startup_from_clui
|
|       Purpose: On startup, makes all changes necessary
|                to properly react to CLUI arguments specified
|
|         Input:
|        Output:
|    Written By: Danielle Argiro
|          Date: Aug 03, 1994
| Modifications:
|
------------------------------------------------------------*/
void startup_from_clui(void)
{
	if (clui_info->i_file)
        {
            input_newimage(clui_info->i_file);
            xvf_set_attribute(gui_info->File->file->i_struct,
                              XVF_FILE_NAME, clui_info->i_file);
            kfree(gui_info->File->file->i);
            gui_info->File->file->i = kstrdup(clui_info->i_file);
        }

	if (clui_info->base_string)
        {
            input_newbasename(clui_info->base_string);
            xvf_set_attribute(gui_info->File->file->b_struct,
                              XVF_STRING_VAL, clui_info->base_string);
            kfree(gui_info->File->file->b);
            gui_info->File->file->b = kstrdup(clui_info->base_string);
            xvf_set_attribute(gui_info->File->file->b_struct,
                              XVF_OPTSEL, 1);
        }

        /*
         * cmap provided in a separate file.
         */
        if (clui_info->cmap_flag)
        {
           xvw_set_attribute(animate, XVW_COLOR_COLORFILE,clui_info->cmap_file);
           xvw_set_attribute(panicon, XVW_COLOR_COLORFILE,clui_info->cmap_file);

	   xvf_set_attribute(gui_info->File->file->cmap_struct,
			     XVF_FILE_NAME, clui_info->cmap_file);
	   kfree(gui_info->File->file->cmap);
           gui_info->File->file->cmap = kstrdup(clui_info->cmap_file);
        }


}

/*-----------------------------------------------------------
|
|  Routine Name: update_framenum
|
|       Purpose: Animate callback for updating the frame number.
|         Input: object - the animate object
|		 client_data - the framenum object
|		 call_data   - the actual frame number
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Oct 11, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void update_framenum(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	int	  num = *((int *) call_data);
	xvobject  framenum = (xvobject) client_data;
	char	  temp[KLENGTH];

	ksprintf(temp, "%d", num);
	xvw_set_attribute(framenum, XVW_LABEL, temp);
}

/*-----------------------------------------------------------
|
|  Routine Name: init_colormap_display
|
|       Purpose: On input of the first image, gets the autocolor
|                list and the colormap operations list, and
|                sets up the two lists on the colormap display
|                with callbacks that will change the colormap
|                when the user selects one.
|
|         Input: object - the data object assoc w/ input image
|        Output: none
|    Written By: Danielle Argiro
|          Date: Aug 03, 1994
| Modifications:
|
------------------------------------------------------------*/
void init_colormap_display(
    kobject data_object)
{
        char     **operation_list, **autocolor_list;
        int      autocolor_num, operation_num;
        xvobject parent, list1, list2, actual_list;

        parent = gui_info->options->colormap->wksp1;
        list1 = xvw_create_list(parent, "Static Autocolor List");
        xvw_set_attributes(list1,
                           XVW_RESIZABLE,     TRUE,
                           XVW_CHAR_HEIGHT,   10.0,
                           XVW_CHAR_WIDTH,    22.0,
                           NULL);
        actual_list = xvw_retrieve_list(list1);

        kcolor_get_attribute(data_object, KCOLOR_MAP_AUTOCOLOR_LIST,
                             &autocolor_list, &autocolor_num);
        xvw_change_list(actual_list, autocolor_list,
                        autocolor_num, FALSE);
        xvw_add_callback(actual_list, XVW_LIST_ITEM_SELECT,
                         autocolor_list_cb, NULL);
        xvw_set_attribute(actual_list, XVW_LIST_HIGHLT_ELEM, 0);

        parent = gui_info->options->colormap->wksp2;
        list2 = xvw_create_list(parent, "Dynamic Autocolor List");
        xvw_set_attributes(list2,
                           XVW_RESIZABLE,     TRUE,
                           XVW_CHAR_HEIGHT,   10.0,
                           XVW_CHAR_WIDTH,    22.0,
                           NULL);
        actual_list = xvw_retrieve_list(list2);
        kcolor_get_attribute(data_object, KCOLOR_MAP_OPERATION_LIST,
                             &operation_list, &operation_num);
        xvw_change_list(actual_list, operation_list,
                        operation_num, FALSE);
        xvw_add_callback(actual_list, XVW_LIST_ITEM_SELECT,
                         operation_list_cb, NULL);
}

static void autocolor_list_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        int  indx;
	char *name;
        xvw_list_struct *list = (xvw_list_struct *) call_data;

	kpds_get_attribute(current_image, KPDS_NAME, &name);
	name = !name ? "(NULL)" : name;
        kcolor_set_attribute(current_image, KCOLOR_MAP_AUTOCOLOR,
                             list->list_index);
}

static void operation_list_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        int             indx;
        xvw_list_struct *list = (xvw_list_struct *) call_data;

	char *name;
	kpds_get_attribute(current_image, KPDS_NAME, &name);
	name = !name ? "(NULL)" : name;

        /* #defines for autocolor operations start at 100 */
        indx = list->list_index+100;
        kcolor_set_attribute(current_image, KCOLOR_MAP_OPERATION, indx);
}
