 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "animate.h"
/*-----------------------------------------------------------
| 
|  Routine Name: animate_get_args
| 
|       Purpose: Gets command line args for animate
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname animate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void animate_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for animate is out of sync with arguments specified in animate's *.pane file; please rerun ghostwriter on animate.";


	/*
	 * allocate the animate structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "animate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "base",
			  &(clui_info->base_string),
			  &(clui_info->base_flag))))
	{
	    kerror(NULL, "animate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "c",
			  &(clui_info->c_file),
			  &(clui_info->c_flag))))
	{
	    kerror(NULL, "animate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "cmap",
			  &(clui_info->cmap_file),
			  &(clui_info->cmap_flag))))
	{
	    kerror(NULL, "animate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "use_cmap",
			  &(clui_info->use_cmap_logic),
			  &(clui_info->use_cmap_flag))))
	{
	    kerror(NULL, "animate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "update",
			  &(clui_info->update_float),
			  &(clui_info->update_flag))))
	{
	    kerror(NULL, "animate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "form",
	                &(clui_info->form_file),
	                &(clui_info->form_flag))))
	{
	    kerror(NULL, "animate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "x",
	                &(clui_info->x_int),
	                &(clui_info->x_flag))))
	{
	    kerror(NULL, "animate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "y",
	                &(clui_info->y_int),
	                &(clui_info->y_flag))))
	{
	    kerror(NULL, "animate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

}



