 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_animate
   >>>> 	_xvf_free_animate
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_animate_warning
   >>>> 	_xvf_init_animate_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "animate.h"

static void _xvf_init_animate_warning PROTO((char *));
static void _xvf_init_animate_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_animate
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_animate_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 18, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_animate(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	kcontrol   *master;
	kcontrol   *guidepane;

	master = form->master;
	/*
	 * initializing 'animate' Form Info structure
	 */

	forminfo->license_struct =
	    kvf_create_struct_from_selname(master->sel_list, "animate.license");
	if (forminfo->license_struct == NULL)
		    _xvf_init_animate_warning("unknown selection 'license' on master form");

	forminfo->help_struct =
	    kvf_create_struct_from_selname(master->sel_list, "animate.help");
	if (forminfo->help_struct == NULL)
		    _xvf_init_animate_warning("unknown selection 'help' on master form");

	forminfo->quit_struct =
	    kvf_create_struct_from_selname(master->sel_list, "animate.quit");
	if (forminfo->quit_struct == NULL)
		    _xvf_init_animate_warning("quit button 'quit' on master form");
	forminfo->quit = FALSE;

	forminfo->reverse_struct =
	    kvf_create_struct_from_selname(master->sel_list, "animate.reverse");
	if (forminfo->reverse_struct == NULL)
	    _xvf_init_animate_warning("master action button 'reverse' on master form");
	forminfo->reverse = FALSE;
	selection = forminfo->reverse_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->previous_struct =
	    kvf_create_struct_from_selname(master->sel_list, "animate.previous");
	if (forminfo->previous_struct == NULL)
	    _xvf_init_animate_warning("master action button 'previous' on master form");
	forminfo->previous = FALSE;
	selection = forminfo->previous_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->stop_struct =
	    kvf_create_struct_from_selname(master->sel_list, "animate.stop");
	if (forminfo->stop_struct == NULL)
	    _xvf_init_animate_warning("master action button 'stop' on master form");
	forminfo->stop = FALSE;
	selection = forminfo->stop_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->next_struct =
	    kvf_create_struct_from_selname(master->sel_list, "animate.next");
	if (forminfo->next_struct == NULL)
	    _xvf_init_animate_warning("master action button 'next' on master form");
	forminfo->next = FALSE;
	selection = forminfo->next_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->forward_struct =
	    kvf_create_struct_from_selname(master->sel_list, "animate.forward");
	if (forminfo->forward_struct == NULL)
	    _xvf_init_animate_warning("master action button 'forward' on master form");
	forminfo->forward = FALSE;
	selection = forminfo->forward_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->object_struct =
	    kvf_create_struct_from_selname(master->sel_list, "animate.object");
	if (forminfo->object_struct == NULL)
	    _xvf_init_animate_warning("workspace 'object' on master form");
	else
	{
	    kvf_get_attribute(forminfo->object_struct, KVF_WORKSPACE,
	                    &(forminfo->object));

	}
	forminfo->b0_struct =
	    kvf_create_struct_from_selname(master->sel_list, "animate.b0");
	if (forminfo->b0_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'b0' on master form");
	forminfo->File_struct =
	    kvf_create_struct_from_subformname(form, "animate.File");
	if (forminfo->File_struct == NULL)
	{
	    _xvf_init_animate_error("subform 'File' on form 'animate'", 
			    "animate_File");
	    return(FALSE);
	}

	/*
	 * initializing 'animate->File' Subform Info structure
	 */

	forminfo->File = (animate_File *)
				kcalloc(1, sizeof(animate_File));
	subform = forminfo->File_struct->Subformptr;

	/*
	 * initializing 'animate->File->file' Pane Info structure
	 */

	forminfo->File->file = (File_file *)
				kcalloc(1, sizeof(File_file));
	forminfo->File->file_struct =
	    kvf_create_struct_from_panename(subform, "animate.File.file");
	if (forminfo->File->file_struct == NULL)
	{
	    _xvf_init_animate_error("pane 'file' on subform 'File'", "File_file");
	    return(FALSE);
	}
	pane = forminfo->File->file_struct->Controlptr;
	forminfo->File->file->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.help");
	if (forminfo->File->file->help_struct == NULL)
		    _xvf_init_animate_warning("unknown selection 'help' on pane 'file' of subform 'File'");

	forminfo->File->file->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.quit");
	if (forminfo->File->file->quit_struct == NULL)
		    _xvf_init_animate_warning("quit button 'quit' on pane 'file' of subform 'File'");
	forminfo->File->file->quit = FALSE;

	forminfo->File->file->c_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.c");
	if (forminfo->File->file->c_struct != NULL)
	{
	    selection = forminfo->File->file->c_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->c_struct, KVF_FILE_DEF,
	                    &(forminfo->File->file->c));
	}
	else
	    _xvf_init_animate_warning("input selection 'c' on pane 'file' of subform 'File'");

	forminfo->File->file->c_selected = FALSE;

	forminfo->File->file->cmap_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.cmap");
	if (forminfo->File->file->cmap_struct != NULL)
	{
	    selection = forminfo->File->file->cmap_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->cmap_struct, KVF_FILE_DEF,
	                    &(forminfo->File->file->cmap));
	}
	else
	    _xvf_init_animate_warning("input selection 'cmap' on pane 'file' of subform 'File'");

	forminfo->File->file->cmap_selected = FALSE;

	forminfo->File->file->o_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.o");
	if (forminfo->File->file->o_struct != NULL)
	{
	    selection = forminfo->File->file->o_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->o_struct, KVF_FILE_DEF,
	                    &(forminfo->File->file->o));
	}
	else
	    _xvf_init_animate_warning("output selection 'o' on pane 'file' of subform 'File'");

	forminfo->File->file->o_selected = FALSE;

	forminfo->File->file->i_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.i");
	if (forminfo->File->file->i_struct != NULL)
	{
	    selection = forminfo->File->file->i_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->i_struct, KVF_FILE_DEF,
	                    &(forminfo->File->file->i));
	}
	else
	    _xvf_init_animate_warning("input selection 'i' on pane 'file' of subform 'File'");

	forminfo->File->file->i_selected = FALSE;
	forminfo->File->file->i_optsel = TRUE;

	forminfo->File->file->b_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.b");
	if (forminfo->File->file->b_struct != NULL)
	{
	    selection = forminfo->File->file->b_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->b_struct, KVF_STRING_DEF,
	                    &(forminfo->File->file->b));
	}
	else
	    _xvf_init_animate_warning("string selection 'b' on pane 'file' of subform 'File'");

	forminfo->File->file->b_selected = FALSE;
	forminfo->File->file->b_optsel = FALSE;

	forminfo->File->file->blk1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.blk1");
	if (forminfo->File->file->blk1_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blk1' on pane 'file' of subform 'File'");
	forminfo->File->file->blk2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.blk2");
	if (forminfo->File->file->blk2_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blk2' on pane 'file' of subform 'File'");
	forminfo->File->file->blk3_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.blk3");
	if (forminfo->File->file->blk3_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blk3' on pane 'file' of subform 'File'");
	forminfo->File->file->blk4_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.blk4");
	if (forminfo->File->file->blk4_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blk4' on pane 'file' of subform 'File'");
	forminfo->File->file->blk5_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.File.file.blk5");
	if (forminfo->File->file->blk5_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blk5' on pane 'file' of subform 'File'");
	forminfo->options_struct =
	    kvf_create_struct_from_subformname(form, "animate.options");
	if (forminfo->options_struct == NULL)
	{
	    _xvf_init_animate_error("subform 'options' on form 'animate'", 
			    "animate_options");
	    return(FALSE);
	}

	/*
	 * initializing 'animate->options' Subform Info structure
	 */

	forminfo->options = (animate_options *)
				kcalloc(1, sizeof(animate_options));
	subform = forminfo->options_struct->Subformptr;
	guidepane = subform->guidepane;
	forminfo->options->help_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "animate.options.help");
	if (forminfo->options->help_struct == NULL)
		    _xvf_init_animate_warning("unknown selection 'help' on subform 'options'");

	forminfo->options->quit_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "animate.options.quit");
	if (forminfo->options->quit_struct == NULL)
		    _xvf_init_animate_warning("quit button 'quit' on subform 'options'");
	forminfo->options->quit = FALSE;


	/*
	 * initializing 'animate->options->attributes' Pane Info structure
	 */

	forminfo->options->attributes = (options_attributes *)
				kcalloc(1, sizeof(options_attributes));
	forminfo->options->attributes_struct =
	    kvf_create_struct_from_panename(subform, "animate.options.attributes");
	if (forminfo->options->attributes_struct == NULL)
	{
	    _xvf_init_animate_error("pane 'attributes' on subform 'options'", "options_attributes");
	    return(FALSE);
	}
	pane = forminfo->options->attributes_struct->Controlptr;
	forminfo->options->attributes->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.attributes.help");
	if (forminfo->options->attributes->help_struct == NULL)
		    _xvf_init_animate_warning("unknown selection 'help' on pane 'attributes' of subform 'options'");

	forminfo->options->attributes->control_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.attributes.control");
	if (forminfo->options->attributes->control_struct != NULL)
	{
	    selection = forminfo->options->attributes->control_struct->Selptr;
	    kvf_get_attribute(forminfo->options->attributes->control_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->options->attributes->control_num));
	    forminfo->options->attributes->control_val = 1;
	}
	else
	    _xvf_init_animate_warning("toggle selection 'control' on pane 'attributes' of subform 'options'");

	forminfo->options->attributes->control_selected = FALSE;

	forminfo->options->attributes->elements_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.attributes.elements");
	if (forminfo->options->attributes->elements_struct != NULL)
	{
	    selection = forminfo->options->attributes->elements_struct->Selptr;
	    kvf_get_attribute(forminfo->options->attributes->elements_struct, KVF_OPTSEL,
	                    &(forminfo->options->attributes->elements));
	}
	else
	    _xvf_init_animate_warning("flag selection 'elements' on pane 'attributes' of subform 'options'");

	forminfo->options->attributes->elements_selected = FALSE;

	forminfo->options->attributes->depth_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.attributes.depth");
	if (forminfo->options->attributes->depth_struct != NULL)
	{
	    selection = forminfo->options->attributes->depth_struct->Selptr;
	    kvf_get_attribute(forminfo->options->attributes->depth_struct, KVF_OPTSEL,
	                    &(forminfo->options->attributes->depth));
	}
	else
	    _xvf_init_animate_warning("flag selection 'depth' on pane 'attributes' of subform 'options'");

	forminfo->options->attributes->depth_selected = FALSE;

	forminfo->options->attributes->time_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.attributes.time");
	if (forminfo->options->attributes->time_struct != NULL)
	{
	    selection = forminfo->options->attributes->time_struct->Selptr;
	    kvf_get_attribute(forminfo->options->attributes->time_struct, KVF_OPTSEL,
	                    &(forminfo->options->attributes->time));
	}
	else
	    _xvf_init_animate_warning("flag selection 'time' on pane 'attributes' of subform 'options'");

	forminfo->options->attributes->time_selected = FALSE;

	forminfo->options->attributes->show_framenum_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.attributes.show_framenum");
	if (forminfo->options->attributes->show_framenum_struct != NULL)
	{
	    selection = forminfo->options->attributes->show_framenum_struct->Selptr;
	    kvf_get_attribute(forminfo->options->attributes->show_framenum_struct, KVF_LOGIC_DEF,
	                    &(forminfo->options->attributes->show_framenum));
	    kvf_get_attribute(forminfo->options->attributes->show_framenum_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->options->attributes->show_framenum_label));
	}
	else
	    _xvf_init_animate_warning("logical selection 'show_framenum' on pane 'attributes' of subform 'options'");

	forminfo->options->attributes->show_framenum_selected = FALSE;

	forminfo->options->attributes->speed_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.attributes.speed");
	if (forminfo->options->attributes->speed_struct != NULL)
	{
	    selection = forminfo->options->attributes->speed_struct->Selptr;
	    kvf_get_attribute(forminfo->options->attributes->speed_struct, KVF_FLOAT_DEF,
	                    &(forminfo->options->attributes->speed));
	}
	else
	    _xvf_init_animate_warning("float selection 'speed' on pane 'attributes' of subform 'options'");

	forminfo->options->attributes->speed_selected = FALSE;

	forminfo->options->attributes->image_band_label_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.attributes.image_band_label");
	if (forminfo->options->attributes->image_band_label_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'image_band_label' on pane 'attributes' of subform 'options'");

	/*
	 * initializing 'animate->options->display' Pane Info structure
	 */

	forminfo->options->display = (options_display *)
				kcalloc(1, sizeof(options_display));
	forminfo->options->display_struct =
	    kvf_create_struct_from_panename(subform, "animate.options.display");
	if (forminfo->options->display_struct == NULL)
	{
	    _xvf_init_animate_error("pane 'display' on subform 'options'", "options_display");
	    return(FALSE);
	}
	pane = forminfo->options->display_struct->Controlptr;
	forminfo->options->display->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.display.help");
	if (forminfo->options->display->help_struct == NULL)
		    _xvf_init_animate_warning("unknown selection 'help' on pane 'display' of subform 'options'");

	forminfo->options->display->norm_type_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.display.norm_type");
	if (forminfo->options->display->norm_type_struct != NULL)
	{
	    selection = forminfo->options->display->norm_type_struct->Selptr;
	    kvf_get_attribute(forminfo->options->display->norm_type_struct, KVF_CYCLE_VAL,
	                    &(forminfo->options->display->norm_type));
	    kvf_get_attribute(forminfo->options->display->norm_type_struct, KVF_CYCLE_LABEL,
	                    &(forminfo->options->display->norm_type_label));
	}
	else
	    _xvf_init_animate_warning("cycle selection 'norm_type' on pane 'display' of subform 'options'");

	forminfo->options->display->norm_type_selected = FALSE;

	forminfo->options->display->norm_method_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.display.norm_method");
	if (forminfo->options->display->norm_method_struct != NULL)
	{
	    selection = forminfo->options->display->norm_method_struct->Selptr;
	    kvf_get_attribute(forminfo->options->display->norm_method_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->options->display->norm_method_num));
	    forminfo->options->display->norm_method_val = 1;
	}
	else
	    _xvf_init_animate_warning("toggle selection 'norm_method' on pane 'display' of subform 'options'");

	forminfo->options->display->norm_method_selected = FALSE;

	forminfo->options->display->red_mapcol_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.display.red_mapcol");
	if (forminfo->options->display->red_mapcol_struct == NULL)
	    _xvf_init_animate_warning("pane action button 'red_mapcol' on pane 'display' of subform 'options'");
	forminfo->options->display->red_mapcol = FALSE;
	selection = forminfo->options->display->red_mapcol_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->display->green_mapcol_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.display.green_mapcol");
	if (forminfo->options->display->green_mapcol_struct == NULL)
	    _xvf_init_animate_warning("pane action button 'green_mapcol' on pane 'display' of subform 'options'");
	forminfo->options->display->green_mapcol = FALSE;
	selection = forminfo->options->display->green_mapcol_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->display->blue_mapcol_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.display.blue_mapcol");
	if (forminfo->options->display->blue_mapcol_struct == NULL)
	    _xvf_init_animate_warning("pane action button 'blue_mapcol' on pane 'display' of subform 'options'");
	forminfo->options->display->blue_mapcol = FALSE;
	selection = forminfo->options->display->blue_mapcol_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->display->red_function_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.display.red_function");
	if (forminfo->options->display->red_function_struct != NULL)
	{
	    selection = forminfo->options->display->red_function_struct->Selptr;
	    kvf_get_attribute(forminfo->options->display->red_function_struct, KVF_STRING_DEF,
	                    &(forminfo->options->display->red_function));
	}
	else
	    _xvf_init_animate_warning("string selection 'red_function' on pane 'display' of subform 'options'");

	forminfo->options->display->red_function_selected = FALSE;

	forminfo->options->display->green_function_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.display.green_function");
	if (forminfo->options->display->green_function_struct != NULL)
	{
	    selection = forminfo->options->display->green_function_struct->Selptr;
	    kvf_get_attribute(forminfo->options->display->green_function_struct, KVF_STRING_DEF,
	                    &(forminfo->options->display->green_function));
	}
	else
	    _xvf_init_animate_warning("string selection 'green_function' on pane 'display' of subform 'options'");

	forminfo->options->display->green_function_selected = FALSE;

	forminfo->options->display->blue_function_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.display.blue_function");
	if (forminfo->options->display->blue_function_struct != NULL)
	{
	    selection = forminfo->options->display->blue_function_struct->Selptr;
	    kvf_get_attribute(forminfo->options->display->blue_function_struct, KVF_STRING_DEF,
	                    &(forminfo->options->display->blue_function));
	}
	else
	    _xvf_init_animate_warning("string selection 'blue_function' on pane 'display' of subform 'options'");

	forminfo->options->display->blue_function_selected = FALSE;

	forminfo->options->display->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.display.blank1");
	if (forminfo->options->display->blank1_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blank1' on pane 'display' of subform 'options'");
	forminfo->options->display->blank2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.display.blank2");
	if (forminfo->options->display->blank2_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blank2' on pane 'display' of subform 'options'");

	/*
	 * initializing 'animate->options->lists' Pane Info structure
	 */

	forminfo->options->lists = (options_lists *)
				kcalloc(1, sizeof(options_lists));
	forminfo->options->lists_struct =
	    kvf_create_struct_from_panename(subform, "animate.options.lists");
	if (forminfo->options->lists_struct == NULL)
	{
	    _xvf_init_animate_error("pane 'lists' on subform 'options'", "options_lists");
	    return(FALSE);
	}
	pane = forminfo->options->lists_struct->Controlptr;
	forminfo->options->lists->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.lists.help");
	if (forminfo->options->lists->help_struct == NULL)
		    _xvf_init_animate_warning("unknown selection 'help' on pane 'lists' of subform 'options'");

	forminfo->options->lists->animate_list_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.lists.animate_list");
	if (forminfo->options->lists->animate_list_struct != NULL)
	{
	    selection = forminfo->options->lists->animate_list_struct->Selptr;
	    kvf_get_attribute(forminfo->options->lists->animate_list_struct, KVF_LIST_VAL,
	                    &(forminfo->options->lists->animate_list));
	    kvf_get_attribute(forminfo->options->lists->animate_list_struct, KVF_LIST_LABEL,
	                    &(forminfo->options->lists->animate_list_label));
	}
	else
	    _xvf_init_animate_warning("displaylist selection 'animate_list' on pane 'lists' of subform 'options'");

	forminfo->options->lists->animate_list_selected = FALSE;

	forminfo->options->lists->band_list_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.lists.band_list");
	if (forminfo->options->lists->band_list_struct != NULL)
	{
	    selection = forminfo->options->lists->band_list_struct->Selptr;
	    kvf_get_attribute(forminfo->options->lists->band_list_struct, KVF_LIST_VAL,
	                    &(forminfo->options->lists->band_list));
	    kvf_get_attribute(forminfo->options->lists->band_list_struct, KVF_LIST_LABEL,
	                    &(forminfo->options->lists->band_list_label));
	}
	else
	    _xvf_init_animate_warning("displaylist selection 'band_list' on pane 'lists' of subform 'options'");

	forminfo->options->lists->band_list_selected = FALSE;


	/*
	 * initializing 'animate->options->colormap' Pane Info structure
	 */

	forminfo->options->colormap = (options_colormap *)
				kcalloc(1, sizeof(options_colormap));
	forminfo->options->colormap_struct =
	    kvf_create_struct_from_panename(subform, "animate.options.colormap");
	if (forminfo->options->colormap_struct == NULL)
	{
	    _xvf_init_animate_error("pane 'colormap' on subform 'options'", "options_colormap");
	    return(FALSE);
	}
	pane = forminfo->options->colormap_struct->Controlptr;
	forminfo->options->colormap->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.colormap.help");
	if (forminfo->options->colormap->help_struct == NULL)
		    _xvf_init_animate_warning("unknown selection 'help' on pane 'colormap' of subform 'options'");

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_options(forminfo->options);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_colormap(forminfo->options->colormap);
	forminfo->options->colormap->wksp1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.colormap.wksp1");
	if (forminfo->options->colormap->wksp1_struct == NULL)
	    _xvf_init_animate_warning("workspace 'wksp1' on pane 'colormap' of subform 'options'");
	else
	{
	    kvf_get_attribute(forminfo->options->colormap->wksp1_struct, KVF_WORKSPACE,
	                    &(forminfo->options->colormap->wksp1));

	}
	forminfo->options->colormap->wksp2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.colormap.wksp2");
	if (forminfo->options->colormap->wksp2_struct == NULL)
	    _xvf_init_animate_warning("workspace 'wksp2' on pane 'colormap' of subform 'options'");
	else
	{
	    kvf_get_attribute(forminfo->options->colormap->wksp2_struct, KVF_WORKSPACE,
	                    &(forminfo->options->colormap->wksp2));

	}
	forminfo->options->colormap->b1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.colormap.b1");
	if (forminfo->options->colormap->b1_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'b1' on pane 'colormap' of subform 'options'");
	forminfo->options->colormap->b2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.colormap.b2");
	if (forminfo->options->colormap->b2_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'b2' on pane 'colormap' of subform 'options'");

	/*
	 * initializing 'animate->options->function' Pane Info structure
	 */

	forminfo->options->function = (options_function *)
				kcalloc(1, sizeof(options_function));
	forminfo->options->function_struct =
	    kvf_create_struct_from_panename(subform, "animate.options.function");
	if (forminfo->options->function_struct == NULL)
	{
	    _xvf_init_animate_error("pane 'function' on subform 'options'", "options_function");
	    return(FALSE);
	}
	pane = forminfo->options->function_struct->Controlptr;
	forminfo->options->function->create_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.create");
	if (forminfo->options->function->create_struct == NULL)
	    _xvf_init_animate_warning("pane action button 'create' on pane 'function' of subform 'options'");
	forminfo->options->function->create = FALSE;
	selection = forminfo->options->function->create_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->function->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.help");
	if (forminfo->options->function->help_struct == NULL)
		    _xvf_init_animate_warning("unknown selection 'help' on pane 'function' of subform 'options'");

	forminfo->options->function->expr_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.expr");
	if (forminfo->options->function->expr_struct != NULL)
	{
	    selection = forminfo->options->function->expr_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->expr_struct, KVF_STRING_DEF,
	                    &(forminfo->options->function->expr));
	}
	else
	    _xvf_init_animate_warning("string selection 'expr' on pane 'function' of subform 'options'");


	forminfo->options->function->wbegin_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.wbegin");
	if (forminfo->options->function->wbegin_struct != NULL)
	{
	    selection = forminfo->options->function->wbegin_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->wbegin_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->wbegin));
	}
	else
	    _xvf_init_animate_warning("double selection 'wbegin' on pane 'function' of subform 'options'");

	forminfo->options->function->wbegin_optsel = TRUE;

	forminfo->options->function->wend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.wend");
	if (forminfo->options->function->wend_struct != NULL)
	{
	    selection = forminfo->options->function->wend_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->wend_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->wend));
	}
	else
	    _xvf_init_animate_warning("double selection 'wend' on pane 'function' of subform 'options'");

	forminfo->options->function->wend_optsel = TRUE;

	forminfo->options->function->wsize_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.wsize");
	if (forminfo->options->function->wsize_struct != NULL)
	{
	    selection = forminfo->options->function->wsize_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->wsize_struct, KVF_INT_DEF,
	                    &(forminfo->options->function->wsize));
	}
	else
	    _xvf_init_animate_warning("integer selection 'wsize' on pane 'function' of subform 'options'");

	forminfo->options->function->wsize_optsel = TRUE;

	forminfo->options->function->hbegin_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.hbegin");
	if (forminfo->options->function->hbegin_struct != NULL)
	{
	    selection = forminfo->options->function->hbegin_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->hbegin_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->hbegin));
	}
	else
	    _xvf_init_animate_warning("double selection 'hbegin' on pane 'function' of subform 'options'");

	forminfo->options->function->hbegin_optsel = TRUE;

	forminfo->options->function->hend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.hend");
	if (forminfo->options->function->hend_struct != NULL)
	{
	    selection = forminfo->options->function->hend_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->hend_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->hend));
	}
	else
	    _xvf_init_animate_warning("double selection 'hend' on pane 'function' of subform 'options'");

	forminfo->options->function->hend_optsel = TRUE;

	forminfo->options->function->hsize_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.hsize");
	if (forminfo->options->function->hsize_struct != NULL)
	{
	    selection = forminfo->options->function->hsize_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->hsize_struct, KVF_INT_DEF,
	                    &(forminfo->options->function->hsize));
	}
	else
	    _xvf_init_animate_warning("integer selection 'hsize' on pane 'function' of subform 'options'");

	forminfo->options->function->hsize_optsel = TRUE;

	forminfo->options->function->dbegin_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.dbegin");
	if (forminfo->options->function->dbegin_struct != NULL)
	{
	    selection = forminfo->options->function->dbegin_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->dbegin_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->dbegin));
	}
	else
	    _xvf_init_animate_warning("double selection 'dbegin' on pane 'function' of subform 'options'");

	forminfo->options->function->dbegin_optsel = TRUE;

	forminfo->options->function->dend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.dend");
	if (forminfo->options->function->dend_struct != NULL)
	{
	    selection = forminfo->options->function->dend_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->dend_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->dend));
	}
	else
	    _xvf_init_animate_warning("double selection 'dend' on pane 'function' of subform 'options'");

	forminfo->options->function->dend_optsel = TRUE;

	forminfo->options->function->dsize_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.dsize");
	if (forminfo->options->function->dsize_struct != NULL)
	{
	    selection = forminfo->options->function->dsize_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->dsize_struct, KVF_INT_DEF,
	                    &(forminfo->options->function->dsize));
	}
	else
	    _xvf_init_animate_warning("integer selection 'dsize' on pane 'function' of subform 'options'");

	forminfo->options->function->dsize_optsel = TRUE;

	forminfo->options->function->tbegin_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.tbegin");
	if (forminfo->options->function->tbegin_struct != NULL)
	{
	    selection = forminfo->options->function->tbegin_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->tbegin_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->tbegin));
	}
	else
	    _xvf_init_animate_warning("double selection 'tbegin' on pane 'function' of subform 'options'");

	forminfo->options->function->tbegin_optsel = TRUE;

	forminfo->options->function->tend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.tend");
	if (forminfo->options->function->tend_struct != NULL)
	{
	    selection = forminfo->options->function->tend_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->tend_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->tend));
	}
	else
	    _xvf_init_animate_warning("double selection 'tend' on pane 'function' of subform 'options'");

	forminfo->options->function->tend_optsel = TRUE;

	forminfo->options->function->tsize_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.tsize");
	if (forminfo->options->function->tsize_struct != NULL)
	{
	    selection = forminfo->options->function->tsize_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->tsize_struct, KVF_INT_DEF,
	                    &(forminfo->options->function->tsize));
	}
	else
	    _xvf_init_animate_warning("integer selection 'tsize' on pane 'function' of subform 'options'");

	forminfo->options->function->tsize_optsel = TRUE;

	forminfo->options->function->ebegin_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.ebegin");
	if (forminfo->options->function->ebegin_struct != NULL)
	{
	    selection = forminfo->options->function->ebegin_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->ebegin_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->ebegin));
	}
	else
	    _xvf_init_animate_warning("double selection 'ebegin' on pane 'function' of subform 'options'");

	forminfo->options->function->ebegin_optsel = TRUE;

	forminfo->options->function->eend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.eend");
	if (forminfo->options->function->eend_struct != NULL)
	{
	    selection = forminfo->options->function->eend_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->eend_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->eend));
	}
	else
	    _xvf_init_animate_warning("double selection 'eend' on pane 'function' of subform 'options'");

	forminfo->options->function->eend_optsel = TRUE;

	forminfo->options->function->esize_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.esize");
	if (forminfo->options->function->esize_struct != NULL)
	{
	    selection = forminfo->options->function->esize_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->esize_struct, KVF_INT_DEF,
	                    &(forminfo->options->function->esize));
	}
	else
	    _xvf_init_animate_warning("integer selection 'esize' on pane 'function' of subform 'options'");

	forminfo->options->function->esize_optsel = TRUE;

	forminfo->options->function->type_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.type");
	if (forminfo->options->function->type_struct != NULL)
	{
	    selection = forminfo->options->function->type_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->type_struct, KVF_LIST_VAL,
	                    &(forminfo->options->function->type));
	    kvf_get_attribute(forminfo->options->function->type_struct, KVF_LIST_LABEL,
	                    &(forminfo->options->function->type_label));
	}
	else
	    _xvf_init_animate_warning("list selection 'type' on pane 'function' of subform 'options'");

	forminfo->options->function->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.blank1");
	if (forminfo->options->function->blank1_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blank1' on pane 'function' of subform 'options'");
	forminfo->options->function->blank2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.blank2");
	if (forminfo->options->function->blank2_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blank2' on pane 'function' of subform 'options'");
	forminfo->options->function->blank3_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.blank3");
	if (forminfo->options->function->blank3_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blank3' on pane 'function' of subform 'options'");
	forminfo->options->function->blank4_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.blank4");
	if (forminfo->options->function->blank4_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blank4' on pane 'function' of subform 'options'");
	forminfo->options->function->blank5_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "animate.options.function.blank5");
	if (forminfo->options->function->blank5_struct == NULL)
	    _xvf_init_animate_warning("blank selection 'blank5' on pane 'function' of subform 'options'");
	forminfo->animate_struct =
	    kvf_create_struct_from_mastername(form, "animate");
	if (forminfo->animate_struct == NULL)
	{
	    _xvf_init_animate_error("form 'animate'",
			    "gui_info");
	    return(FALSE);
	}

	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_animate_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 18, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_animate_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_animate_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 18, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_animate_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_animate
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_animate_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 18, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_animate(
    gui_info_struct *forminfo)
{
	if (forminfo->license_struct != NULL)
	    kfree(forminfo->license_struct);
	if (forminfo->help_struct != NULL)
	    kfree(forminfo->help_struct);
	if (forminfo->quit_struct != NULL)
	    kfree(forminfo->quit_struct);
	if (forminfo->reverse_struct != NULL)
	    kfree(forminfo->reverse_struct);
	if (forminfo->previous_struct != NULL)
	    kfree(forminfo->previous_struct);
	if (forminfo->stop_struct != NULL)
	    kfree(forminfo->stop_struct);
	if (forminfo->next_struct != NULL)
	    kfree(forminfo->next_struct);
	if (forminfo->forward_struct != NULL)
	    kfree(forminfo->forward_struct);
	if (forminfo->object_struct != NULL)
	    kfree(forminfo->object_struct);
	if (forminfo->b0_struct != NULL)
	    kfree(forminfo->b0_struct);
	if (forminfo->File->file->help_struct != NULL)
	    kfree(forminfo->File->file->help_struct);
	if (forminfo->File->file->quit_struct != NULL)
	    kfree(forminfo->File->file->quit_struct);
	kfree(forminfo->File->file->c);
	if (forminfo->File->file->c_struct != NULL)
	    kfree(forminfo->File->file->c_struct);
	kfree(forminfo->File->file->cmap);
	if (forminfo->File->file->cmap_struct != NULL)
	    kfree(forminfo->File->file->cmap_struct);
	kfree(forminfo->File->file->o);
	if (forminfo->File->file->o_struct != NULL)
	    kfree(forminfo->File->file->o_struct);
	kfree(forminfo->File->file->i);
	if (forminfo->File->file->i_struct != NULL)
	    kfree(forminfo->File->file->i_struct);
	kfree(forminfo->File->file->b);
	if (forminfo->File->file->b_struct != NULL)
	    kfree(forminfo->File->file->b_struct);
	if (forminfo->File->file->blk1_struct != NULL)
	    kfree(forminfo->File->file->blk1_struct);
	if (forminfo->File->file->blk2_struct != NULL)
	    kfree(forminfo->File->file->blk2_struct);
	if (forminfo->File->file->blk3_struct != NULL)
	    kfree(forminfo->File->file->blk3_struct);
	if (forminfo->File->file->blk4_struct != NULL)
	    kfree(forminfo->File->file->blk4_struct);
	if (forminfo->File->file->blk5_struct != NULL)
	    kfree(forminfo->File->file->blk5_struct);
	kfree(forminfo->File->file);
	if (forminfo->File->file_struct != NULL)
	    kfree(forminfo->File->file_struct);


	if (forminfo->File_struct != NULL)
	    kfree(forminfo->File_struct);
	kfree(forminfo->File);
	if (forminfo->options->help_struct != NULL)
	    kfree(forminfo->options->help_struct);
	if (forminfo->options->quit_struct != NULL)
	    kfree(forminfo->options->quit_struct);
	if (forminfo->options->attributes->help_struct != NULL)
	    kfree(forminfo->options->attributes->help_struct);
	if (forminfo->options->attributes->control_struct != NULL)
	    kfree(forminfo->options->attributes->control_struct);
	if (forminfo->options->attributes->elements_struct != NULL)
	    kfree(forminfo->options->attributes->elements_struct);
	if (forminfo->options->attributes->depth_struct != NULL)
	    kfree(forminfo->options->attributes->depth_struct);
	if (forminfo->options->attributes->time_struct != NULL)
	    kfree(forminfo->options->attributes->time_struct);
	if (forminfo->options->attributes->show_framenum_struct != NULL)
	    kfree(forminfo->options->attributes->show_framenum_struct);
	kfree(forminfo->options->attributes->show_framenum_label);
	if (forminfo->options->attributes->speed_struct != NULL)
	    kfree(forminfo->options->attributes->speed_struct);
	if (forminfo->options->attributes->image_band_label_struct != NULL)
	    kfree(forminfo->options->attributes->image_band_label_struct);
	kfree(forminfo->options->attributes);
	if (forminfo->options->attributes_struct != NULL)
	    kfree(forminfo->options->attributes_struct);

	if (forminfo->options->display->help_struct != NULL)
	    kfree(forminfo->options->display->help_struct);
	if (forminfo->options->display->norm_type_struct != NULL)
	    kfree(forminfo->options->display->norm_type_struct);
	kfree(forminfo->options->display->norm_type_label);
	if (forminfo->options->display->norm_method_struct != NULL)
	    kfree(forminfo->options->display->norm_method_struct);
	if (forminfo->options->display->red_mapcol_struct != NULL)
	    kfree(forminfo->options->display->red_mapcol_struct);
	if (forminfo->options->display->green_mapcol_struct != NULL)
	    kfree(forminfo->options->display->green_mapcol_struct);
	if (forminfo->options->display->blue_mapcol_struct != NULL)
	    kfree(forminfo->options->display->blue_mapcol_struct);
	kfree(forminfo->options->display->red_function);
	if (forminfo->options->display->red_function_struct != NULL)
	    kfree(forminfo->options->display->red_function_struct);
	kfree(forminfo->options->display->green_function);
	if (forminfo->options->display->green_function_struct != NULL)
	    kfree(forminfo->options->display->green_function_struct);
	kfree(forminfo->options->display->blue_function);
	if (forminfo->options->display->blue_function_struct != NULL)
	    kfree(forminfo->options->display->blue_function_struct);
	if (forminfo->options->display->blank1_struct != NULL)
	    kfree(forminfo->options->display->blank1_struct);
	if (forminfo->options->display->blank2_struct != NULL)
	    kfree(forminfo->options->display->blank2_struct);
	kfree(forminfo->options->display);
	if (forminfo->options->display_struct != NULL)
	    kfree(forminfo->options->display_struct);

	if (forminfo->options->lists->help_struct != NULL)
	    kfree(forminfo->options->lists->help_struct);
	if (forminfo->options->lists->animate_list_struct != NULL)
	    kfree(forminfo->options->lists->animate_list_struct);
	kfree(forminfo->options->lists->animate_list_label);
	if (forminfo->options->lists->band_list_struct != NULL)
	    kfree(forminfo->options->lists->band_list_struct);
	kfree(forminfo->options->lists->band_list_label);
	kfree(forminfo->options->lists);
	if (forminfo->options->lists_struct != NULL)
	    kfree(forminfo->options->lists_struct);

	if (forminfo->options->colormap->help_struct != NULL)
	    kfree(forminfo->options->colormap->help_struct);
	if (forminfo->options->colormap->wksp1_struct != NULL)
	    kfree(forminfo->options->colormap->wksp1_struct);
	if (forminfo->options->colormap->wksp2_struct != NULL)
	    kfree(forminfo->options->colormap->wksp2_struct);
	if (forminfo->options->colormap->b1_struct != NULL)
	    kfree(forminfo->options->colormap->b1_struct);
	if (forminfo->options->colormap->b2_struct != NULL)
	    kfree(forminfo->options->colormap->b2_struct);
	kfree(forminfo->options->colormap);
	if (forminfo->options->colormap_struct != NULL)
	    kfree(forminfo->options->colormap_struct);

	if (forminfo->options->function->create_struct != NULL)
	    kfree(forminfo->options->function->create_struct);
	if (forminfo->options->function->help_struct != NULL)
	    kfree(forminfo->options->function->help_struct);
	kfree(forminfo->options->function->expr);
	if (forminfo->options->function->expr_struct != NULL)
	    kfree(forminfo->options->function->expr_struct);
	if (forminfo->options->function->wbegin_struct != NULL)
	    kfree(forminfo->options->function->wbegin_struct);
	if (forminfo->options->function->wend_struct != NULL)
	    kfree(forminfo->options->function->wend_struct);
	if (forminfo->options->function->wsize_struct != NULL)
	     kfree(forminfo->options->function->wsize_struct);
	if (forminfo->options->function->hbegin_struct != NULL)
	    kfree(forminfo->options->function->hbegin_struct);
	if (forminfo->options->function->hend_struct != NULL)
	    kfree(forminfo->options->function->hend_struct);
	if (forminfo->options->function->hsize_struct != NULL)
	     kfree(forminfo->options->function->hsize_struct);
	if (forminfo->options->function->dbegin_struct != NULL)
	    kfree(forminfo->options->function->dbegin_struct);
	if (forminfo->options->function->dend_struct != NULL)
	    kfree(forminfo->options->function->dend_struct);
	if (forminfo->options->function->dsize_struct != NULL)
	     kfree(forminfo->options->function->dsize_struct);
	if (forminfo->options->function->tbegin_struct != NULL)
	    kfree(forminfo->options->function->tbegin_struct);
	if (forminfo->options->function->tend_struct != NULL)
	    kfree(forminfo->options->function->tend_struct);
	if (forminfo->options->function->tsize_struct != NULL)
	     kfree(forminfo->options->function->tsize_struct);
	if (forminfo->options->function->ebegin_struct != NULL)
	    kfree(forminfo->options->function->ebegin_struct);
	if (forminfo->options->function->eend_struct != NULL)
	    kfree(forminfo->options->function->eend_struct);
	if (forminfo->options->function->esize_struct != NULL)
	     kfree(forminfo->options->function->esize_struct);
	if (forminfo->options->function->type_struct != NULL)
	    kfree(forminfo->options->function->type_struct);
	kfree(forminfo->options->function->type_label);
	if (forminfo->options->function->blank1_struct != NULL)
	    kfree(forminfo->options->function->blank1_struct);
	if (forminfo->options->function->blank2_struct != NULL)
	    kfree(forminfo->options->function->blank2_struct);
	if (forminfo->options->function->blank3_struct != NULL)
	    kfree(forminfo->options->function->blank3_struct);
	if (forminfo->options->function->blank4_struct != NULL)
	    kfree(forminfo->options->function->blank4_struct);
	if (forminfo->options->function->blank5_struct != NULL)
	    kfree(forminfo->options->function->blank5_struct);
	kfree(forminfo->options->function);
	if (forminfo->options->function_struct != NULL)
	    kfree(forminfo->options->function_struct);


	if (forminfo->options_struct != NULL)
	    kfree(forminfo->options_struct);
	kfree(forminfo->options);
	kfree(forminfo);
}
