 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane lists
   >>>> 
   >>>>  Private: 
   >>>> 	update_animate_list
   >>>> 	update_band_list
   >>>> 	lists_animate_list
   >>>> 	lists_band_list
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "animate.h"

/*-----------------------------------------------------------
|
|  Routine Name: update_animate_list
|
|       Purpose: Do routine which are called to update the animation list.
|         Input:
|        Output:
|    Written By: Mark Young
|          Date: Aug 10, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void update_animate_list(
   int animation)
{
        options_lists *list_info = gui_info->options->lists;
 
        int  i;
        char **list, *name;
        kform_struct *kformstruct;
 
 
        kformstruct = list_info->animate_list_struct;
        for (i = 0, list = NULL; i < numimages; i++)
        {
           name = NULL;
           kpds_get_attribute(images[i], KPDS_NAME, &name);
	   if (!name) name = "(NULL)";
           list = karray_insert(list, name, i, KLIST_TAIL, TRUE);
        }
	update_band_list();
        xvf_set_attribute(kformstruct, XVF_LIST_SIZE, numimages);
        xvf_set_attribute(kformstruct, XVF_LIST_CONTENTS, list);
        xvf_set_attribute(kformstruct, XVF_LIST_INDEX, animation);
        kfree(list);
}

/*-----------------------------------------------------------
|
|  Routine Name: update_band_list
|
|       Purpose: Do routine which are called to update the band list.
|         Input:
|        Output:
|    Written By: Mark Young
|          Date: Jul 03, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void update_band_list(void)
{
	options_lists *lists_info = gui_info->options->lists;

	int  i, num, indx;
	kform_struct *kformstruct;
	char **list, temp[KLENGTH];


	xvw_get_attribute(animate, XVW_IMAGE_BANDNUM, &indx);
	xvw_get_attribute(animate, XVW_IMAGE_BAND_MAXNUM, &num); num++;
	kformstruct = lists_info->band_list_struct;
	for (i = 0, list = NULL; i < num; i++)
	{
	   ksprintf(temp,"Image Band %d", i);
	   list = karray_add(list, kstrdup(temp), i);
	}
	xvf_set_attribute(kformstruct, XVF_LIST_SIZE, num);
	xvf_set_attribute(kformstruct, XVF_LIST_CONTENTS, list);
	xvf_set_attribute(kformstruct, XVF_LIST_INDEX, indx);
	karray_free(list, num, NULL);
}

/*-----------------------------------------------------------
| 
|  Routine Name: lists_animate_list
| 
|       Purpose: Do routine which is called when
|                  displaylist selection animate_list is used
| 
|         Input: lists_info - ptr to PaneInfo struct for lists pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Aug 10, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void lists_animate_list(
     options_lists *lists_info)
{
        int indx = lists_info->animate_list - 1;
 

	/*
	 *  Sanity check to see if we are already at the image being
	 *  displayed.  If so then just return....
	 */
	if (current_image == images[indx])
	   return;

        /*
         *  set all editimage displays to have their objects associated
         *  with the data object associated with the file just read in,
         *  so that we are displaying, zooming, etc all on the same info.
         */
	current_image = images[indx];
        xvw_set_attribute(animate, XVW_IMAGE_IMAGEOBJ, current_image);
        xvw_set_attribute(panicon, XVW_IMAGE_IMAGEOBJ, current_image);
	update_band_list();
}

/*-----------------------------------------------------------
| 
|  Routine Name: lists_band_list
| 
|       Purpose: Do routine which is called when
|                  displaylist selection band_list is used
| 
|         Input: lists_info - ptr to PaneInfo struct for lists pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Aug 10, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void lists_band_list(
     options_lists *lists_info)
{
	int indx = lists_info->band_list - 1;
	char	  temp[KLENGTH];

	/*
	 *  set all animate displays to have their objects associated
	 *  with the correct band associated with the current data object
	 *  being display.
	 */
	xvw_set_attribute(animate, XVW_IMAGE_BANDNUM, indx);
	xvw_set_attribute(panicon, XVW_IMAGE_BANDNUM, indx);
        ksprintf(temp, "%d", indx);
        xvw_set_attribute(framenum, XVW_LABEL, temp);
}
