 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/* 
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane display
   >>>> 
   >>>>  Private: 
   >>>> 	display_norm_type
   >>>> 	display_norm_method
   >>>> 	display_red_mapcol
   >>>> 	display_green_mapcol
   >>>> 	display_blue_mapcol
   >>>> 	display_red_function
   >>>> 	display_green_function
   >>>> 	display_blue_function
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "animate.h"


/*-----------------------------------------------------------
| 
|  Routine Name: display_norm_type
| 
|       Purpose: Do routine which is called when
|                  cycle selection norm_type is used
| 
|         Input: display_info - ptr to PaneInfo struct for display pane
| 
|        Output: None
|    Written By: Danielle Argiro & Mark Young
|          Date: Jun 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void display_norm_type(
     options_display *display_info)
{
 	xvw_set_attribute(animate, XVW_COLOR_NORM_TYPE,
		          display_info->norm_type);
}


/*-----------------------------------------------------------
| 
|  Routine Name: display_norm_method
| 
|       Purpose: Do routine which is called when
|                  toggle selection norm_method is used
| 
|         Input: display_info - ptr to PaneInfo struct for display pane
| 
|        Output: None
|    Written By: Danielle Argiro & Mark Young
|          Date: Jun 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void display_norm_method(
     options_display *display_info)
{
	xvw_set_attribute(animate, XVW_COLOR_NORM_METHOD,
		          display_info->norm_method_val);
}


/*-----------------------------------------------------------
| 
|  Routine Name: display_red_mapcol
| 
|       Purpose: Do routine which is called when
|                  pane action button red_mapcol is used
| 
|         Input: display_info - ptr to PaneInfo struct for display pane
| 
|        Output: None
|    Written By: Danielle Argiro & Mark Young
|          Date: Jun 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void display_red_mapcol(
     options_display *display_info)
{
	if (current_image == NULL)
	{
	    kerror(NULL, "display_norm_type", 
		   "You must input an image sequence before doing this.");
            kinfo(KHOSTILE, "duh. uh.");
	    return;
	}
	xvw_set_attribute(animate, XVW_COLOR_CHANGE_RED_MAPCOL, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: display_green_mapcol
| 
|       Purpose: Do routine which is called when
|                  pane action button green_mapcol is used
| 
|         Input: display_info - ptr to PaneInfo struct for display pane
| 
|        Output: None
|    Written By: Danielle Argiro & Mark Young
|          Date: Jun 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void display_green_mapcol(
     options_display *display_info)
{
	if (current_image == NULL)
	{
	    kerror(NULL, "display_norm_type", 
		   "You must input an image sequence before doing this.");
            kinfo(KHOSTILE, "Learn The Computer. Tape only $18.99 from RONCO");
	    return;
	}
	xvw_set_attribute(animate, XVW_COLOR_CHANGE_GREEN_MAPCOL, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: display_blue_mapcol
| 
|       Purpose: Do routine which is called when
|                  pane action button blue_mapcol is used
| 
|         Input: display_info - ptr to PaneInfo struct for display pane
| 
|        Output: None
|    Written By: Danielle Argiro & Mark Young
|          Date: Jun 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void display_blue_mapcol(
     options_display *display_info)
{
	if (current_image == NULL)
	{
	    kerror(NULL, "display_norm_type", 
		   "You must input an image sequence before doing this.");
            kinfo(KHOSTILE, "Film at 11:00. Be there");
	    return;
	}
	xvw_set_attribute(animate, XVW_COLOR_CHANGE_BLUE_MAPCOL, TRUE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: display_red_function
| 
|       Purpose: Do routine which is called when
|                  string selection red_function is used
| 
|         Input: display_info - ptr to PaneInfo struct for display pane
| 
|        Output: None
|    Written By: Danielle Argiro & Mark Young
|          Date: Jun 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void display_red_function(
     options_display *display_info)
{
	if (current_image == NULL)
	{
	    kerror(NULL, "display_norm_type", 
		   "You must input an image sequence before doing this.");
            kinfo(KHOSTILE, "Having a hard day?");
	    return;
	}
	xvw_set_attribute(animate, XVW_COLOR_RED_FUNCTION,
		          display_info->red_function);
}


/*-----------------------------------------------------------
| 
|  Routine Name: display_green_function
| 
|       Purpose: Do routine which is called when
|                  string selection green_function is used
| 
|         Input: display_info - ptr to PaneInfo struct for display pane
| 
|        Output: None
|    Written By: Danielle Argiro & Mark Young
|          Date: Jun 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void display_green_function(
     options_display *display_info)
{
	if (current_image == NULL)
	{
	    kerror(NULL, "display_norm_type", 
                   "You must input an image sequence before doing this.");
            kinfo(KHOSTILE, "bonehead.");
	    return;
	}
	xvw_set_attribute(animate, XVW_COLOR_GREEN_FUNCTION,
		          display_info->red_function);
}


/*-----------------------------------------------------------
| 
|  Routine Name: display_blue_function
| 
|       Purpose: Do routine which is called when
|                  string selection blue_function is used
| 
|         Input: display_info - ptr to PaneInfo struct for display pane
| 
|        Output: None
|    Written By: Danielle Argiro & Mark Young
|          Date: Jun 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void display_blue_function(
     options_display *display_info)
{
	if (current_image == NULL)
	{
	    kerror(NULL, "display_norm_type", 
		   "You must input an image sequence before doing this.");
            kinfo(KHOSTILE, "doofus.");
	    return;
	}
	xvw_set_attribute(animate, XVW_COLOR_BLUE_FUNCTION,
		          display_info->red_function);
}
