 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kautocolor
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kautocolor.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Automatically Color Data Object by Manipulating the Map
|
|       Purpose: main program for kautocolor
|
|         Input:
|		int clui_info->autocolor_toggle; {autocolor by}
|		int clui_info->autocolor_flag; {TRUE if -autocolor specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->i_file; {First Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	int     autocolor;
	kobject src, dest;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "ENVISION");
	kexit_handler(kautocolor_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "ENVISION", "kautocolor",
		kautocolor_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kautocolor_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if (!(dest = kpds_open_output_object(clui_info->o_file)))
	{
	   kpds_close_object(src);
	   kerror(NULL, "kautocolor",
		  "Failed to open output object '%s'.", clui_info->o_file);
	   kexit(KEXIT_FAILURE);
	}

	if (clui_info->i_file == NULL)
	{
	   src = dest;
	}
	else if (!(src = kpds_open_input_object(clui_info->i_file)))
	{
	   kerror(NULL, "kautocolor",
		  "Failed to open input object '%s'.", clui_info->i_file);
	   kexit(KEXIT_FAILURE);
	}

	switch (clui_info->autocolor_toggle)
	{
	   case  0: autocolor = KORIGINAL; break;
	   case  1: autocolor = KRGB_CUBE; break;
	   case  2: autocolor = KRGB_TRIANGLE; break;
	   case  3: autocolor = KRGB_SPIRAL; break;
	   case  4: autocolor = KHLS_SPIRAL; break;
	   case  5: autocolor = KHSV_RINGS; break;
	   case  6: autocolor = KHLS_RINGS; break;
	   case  7: autocolor = KRGB_DISTANCE; break;
	   case  8: autocolor = KCIE_DIAGRAM; break;
	   case  9: autocolor = KDENSITY_SLICE; break;
	   case 10: autocolor = KGREYSCALE; break;
	   case 11: autocolor = KEQUALIZE; break;
	   case 12: autocolor = KSTRETCH; break;
	   case 13: autocolor = KSTDDEV; break;
	   case 14: autocolor = KSA_PSEUDO; break;
	   case 15: autocolor = KRAINBOW; break;
	   case 16: autocolor = KDISJOINT; break;
	   case 17: autocolor = KGREYCODE; break;
	   case 18: autocolor = KMAP332; break;
	   case 19: autocolor = KRANDOM; break;
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!kcolor_set_attribute(src, KCOLOR_MAP_AUTOCOLOR, autocolor))
	{
	   kerror(NULL, "kautocolor", "kcolor_set_attribute failed to \
autocolor on input image '%s'.", clui_info->i_file);
	   kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
	/*
	 * The autocolor should have no side effects on the destination
	 * object.  It will only manipulate the map data.
	 *
	 * Since the source object may contain additional attributes
	 * that may or may not be part of the image data model,
	 * the source object needs to be copied to the destination object
	 * so that the user is not surprised by unwanted side effects.
	 * Example: removal of value or location data.
	 */
	if (src != dest && !kpds_copy_object(src, dest))
	{
	   kerror(NULL, "kautocolor", "kpds_copy_object failed to copy '%s' \
to '%s'.", clui_info->i_file, clui_info->o_file);
	   kexit(KEXIT_FAILURE);
	}
	kpds_close_object(src);
	kpds_close_object(dest);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kautocolor_usage_additions
| 
|       Purpose: Prints usage additions in kautocolor_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kautocolor
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kautocolor_usage_additions(void)
{
	kfprintf(kstderr, "\tAutomatically Color Data Object by Manipulating the Map\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kautocolor_free_args
| 
|       Purpose: Frees CLUI struct allocated in kautocolor_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kautocolor
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kautocolor_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->o_file);
	kfree(clui_info->i_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
