#include <xvinclude.h>

/* 
 * This example displays a big image which needs a pan icon; the image and
 * the pan icon are created in separate windows. The filename can
 * be specified from the command line if desired, using % example filename
 * although by default, the large albuquerque image is used.  If the filename
 * is provided on the command line, and the file specified is not large enough
 * to need a pan icon, it is made artificially larger, so that the pan icon
 * will be forced to come up for the sake of this example.  In general, you 
 * don't want the pan icon to appear unless it is needed.  Specifying NULL as 
 * the parent for both the image and the pan icon, they are displayed in 
 * independent windows.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kobject  data_object;
	xvobject image, panicon, parent;
 	char *filename = "clust:albq_big";
	int  w, h, d, t, e;
	int  desired_width  = 2000;
	int  desired_height = 2000;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");


	if (argc > 1)
	   filename = argv[1];

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 * If we input an image that is smaller than 2000 x 2000, scale it UP 
         * to that size, so that we will actually need a pan icon.  The pan 
	 * icon will not display unless it is needed; it is considered needed 
         * only when the image object is able to to display only a portion of 
         * it.  In general, you *don't* want to do this!
	 */
	data_object = kpds_open_object(filename, KOBJ_READ);
        kpds_get_attribute(data_object, KPDS_VALUE_SIZE, &w, &h, &d, &t, &e);
        w = kmax(w, desired_width);
        h = kmax(h, desired_height);
        kpds_set_attributes(data_object,
			    KPDS_VALUE_SIZE, w, h, d, t, e,
			    KPDS_VALUE_INTERPOLATE, KZERO_ORDER,
			    NULL);

	image = xvw_create_image(NULL, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEOBJ, data_object);

	/*
	 * create the pan icon;  it will only be displayed when it is necessary;
	 * although in this program we have forced it to be necessary.
         * note that setting the parent to NULL forces the pan icon to have
         * a window that is independent from the window in which the image is
         * displayed.  more often, it is useful to have a single backplane
         * hold both the image and the pan icon.
	 */
	panicon = xvw_create_panicon(image, "panicon");
	xvw_set_attribute(panicon, XVW_IMAGE_IMAGEOBJ, data_object);

	/* display & run; there is no way to exit the program but ^C */
	xvf_run_form();
}
