#include <xvinclude.h>

int num = 4;

void  quit_program PROTO((xvobject, kaddr, XEvent *));
void  invert_img   PROTO((xvobject, kaddr, XEvent *, Boolean *));

/*
 * Like example 12.invert_region/, this program also inverts the image. 
 * However, while example 12 inverts the image region by region, this 
 * example inverts the image line by line (when you button press in the 
 * image).
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kobject  img_data_obj;   /* image data object   */
        xvobject img_visual_obj; /* image visual object */
	char     *filename = "image:moon";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
        }

	/* allow filename specification from cmd line */
	if (argc > 1)
	    filename = argv[1];

	/* create a kobject from the moon image */
	img_data_obj  = kpds_open_input_object(filename);

	/* create an image xvobject */
        img_visual_obj = xvw_create_image(NULL, "image");

	/* associate the moon image in w/ the image xvobject */
        xvw_set_attributes(img_visual_obj,
		XVW_IMAGE_BACKING,  FALSE,
		XVW_IMAGE_IMAGEOBJ, img_data_obj,
		NULL);

	/* add the action handler to quit on KeyPress 'q' */
	xvw_add_action(img_visual_obj, "<Key>q", quit_program,
	              img_data_obj, TRUE);

	/* add the event handler to scramble image on KeyPress '<' or '>'*/
	xvw_add_event(img_visual_obj, KeyPressMask | ButtonPressMask,
		      invert_img, img_data_obj);

	/* display & run */
        xvf_run_form();
}

/*
 *  event handler to quit program on Button Press
 */
void  quit_program(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
	kobject img_data_obj = (kobject) client_data;

	xvw_destroy(object);
	kpds_close_object(img_data_obj);
        kexit(KEXIT_SUCCESS);
}

/*
 *  event handler to invert image line by line
 *  on button press or key press
 */
void invert_img(
   xvobject object,
   kaddr    client_data,
   XEvent   *event,
   Boolean  *dispatch)
{
	int      i, w;
        kobject  img_data_obj;
        unsigned char *data = NULL;

        img_data_obj = (kobject) client_data;
 
	/* get the size of the image data */
	kpds_get_attribute(img_data_obj, KPDS_VALUE_SIZE, 
			   &w, NULL, NULL, NULL, NULL);
 
	/*
	 *  get data line by line, invert the line, put line back
	 */
	while ((data = kpds_get_data(img_data_obj, KPDS_VALUE_LINE, data)))
	{
           /* invert the value; note this will only work for byte images */
           for (i = 0; i < w; i++) 
              data[i] = 255 - data[i];
 
           /* put the region back w/ inverted value */
           kpds_put_data(img_data_obj, KPDS_VALUE_LINE, data);
        }
}
